/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna.masterBalance;

import java.rmi.RemoteException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.masterBalance.MasterBalanceManagerDisabled;
import oracle.kv.impl.sna.masterBalance.MasterBalanceManagerInterface;
import oracle.kv.impl.sna.masterBalance.MasterBalancingInterface;
import oracle.kv.impl.sna.masterBalance.MasterLeaseManager;
import oracle.kv.impl.sna.masterBalance.RebalanceThread;
import oracle.kv.impl.sna.masterBalance.TopoCache;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;

public class MasterBalanceManager
implements MasterBalanceManagerInterface {
    private final SNInfo snInfo;
    private final MasterLeaseManager masterLeaseManager;
    private final TopoCache topoCache;
    private final RebalanceThread rebalanceThread;
    final AtomicBoolean shutdown = new AtomicBoolean(false);
    final Logger logger;
    final LoginManager loginMgr;

    private MasterBalanceManager(SNInfo snInfo, Logger logger, LoginManager loginMgr) {
        this.snInfo = snInfo;
        this.logger = logger;
        this.loginMgr = loginMgr;
        this.masterLeaseManager = new MasterLeaseManager(logger);
        this.topoCache = new TopoCache(snInfo, logger, this.getLoginManager()){

            @Override
            Set<RepNodeId> getActiveRNs() {
                return MasterBalanceManager.this.rebalanceThread.getActiveRNs();
            }
        };
        this.rebalanceThread = new RebalanceThread(this);
        this.rebalanceThread.start();
    }

    public static MasterBalanceManagerInterface create(boolean enabled, SNInfo snInfo, Logger logger, LoginManager loginMgr) {
        return enabled ? new MasterBalanceManager(snInfo, logger, loginMgr) : new MasterBalanceManagerDisabled(logger);
    }

    SNInfo getSnInfo() {
        return this.snInfo;
    }

    RebalanceThread getRebalanceThread() {
        return this.rebalanceThread;
    }

    TopoCache getTopoCache() {
        return this.topoCache;
    }

    @Override
    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.topoCache.shutdown();
        this.masterLeaseManager.shutdown();
        this.rebalanceThread.shutdownThread(this.logger);
        this.logger.info("Master balance manager shutdown");
    }

    @Override
    public void noteExit(RepNodeId rnId) {
        if (this.shutdown.get()) {
            return;
        }
        this.masterLeaseManager.cancel(rnId);
        try {
            this.rebalanceThread.noteExit(rnId);
        }
        catch (InterruptedException e) {
            this.logger.info("NoteExit call interrupted");
        }
    }

    @Override
    public synchronized void noteState(MasterBalancingInterface.StateInfo stateInfo, short serialVersion) {
        this.noteState(stateInfo, null, serialVersion);
    }

    @Override
    public synchronized void noteState(MasterBalancingInterface.StateInfo stateInfo, AuthContext authContext, short serialVersion) {
        if (this.shutdown.get()) {
            return;
        }
        RepNodeId rnId = stateInfo.rnId;
        this.topoCache.noteLatestTopo(stateInfo);
        try {
            if (stateInfo.state.isMaster()) {
                this.masterLeaseManager.cancel(rnId);
            }
            this.rebalanceThread.noteState(stateInfo);
        }
        catch (InterruptedException e) {
            this.logger.info("State change call interrupted");
        }
    }

    @Override
    public MasterBalancingInterface.MDInfo getMDInfo(short serialVersion) {
        return this.getMDInfo(null, serialVersion);
    }

    @Override
    public synchronized MasterBalancingInterface.MDInfo getMDInfo(AuthContext authContext, short serialVersion) {
        if (!this.topoCache.isInitialized() || this.shutdown.get()) {
            return null;
        }
        return new MasterBalancingInterface.MDInfo(this.rebalanceThread.getMasterCount(), this.masterLeaseManager.leaseCount(), this.topoCache.getRnCount(), this.rebalanceThread.getBMD());
    }

    @Override
    public synchronized boolean cancelMasterLease(StorageNode lesseeSN, RepNode rn, short serialVersion) {
        return this.cancelMasterLease(lesseeSN, rn, null, serialVersion);
    }

    @Override
    public synchronized boolean cancelMasterLease(StorageNode lesseeSN, RepNode rn, AuthContext authContext, short serialVersion) {
        if (this.shutdown.get()) {
            return false;
        }
        return this.masterLeaseManager.cancel(lesseeSN, rn);
    }

    @Override
    public synchronized boolean getMasterLease(MasterBalancingInterface.MasterLeaseInfo masterLease, short serialVersion) {
        return this.getMasterLease(masterLease, null, serialVersion);
    }

    @Override
    public synchronized boolean getMasterLease(MasterBalancingInterface.MasterLeaseInfo masterLease, AuthContext authContext, short serialVersion) {
        if (!this.topoCache.isInitialized() || this.shutdown.get()) {
            return false;
        }
        if (this.rebalanceThread.willShutDownServices()) {
            return false;
        }
        MasterBalancingInterface.MDInfo mdInfo = this.getMDInfo(serialVersion);
        if (mdInfo == null || mdInfo.getPTMD() > masterLease.limitPTMD) {
            return false;
        }
        return this.rebalanceThread.isReplica(masterLease.getRepNodeId()) ? this.masterLeaseManager.getMasterLease(masterLease) : false;
    }

    void setWillRNsShutDown(boolean willRNsShutDown) {
        this.rebalanceThread.setShutDownServices(willRNsShutDown);
    }

    @Override
    public void transferMastersForShutdown() {
        if (!this.topoCache.isInitialized() || this.shutdown.get()) {
            return;
        }
        this.rebalanceThread.transferMastersForShutdown();
    }

    @Override
    public void overloadedNeighbor(StorageNodeId storageNodeId, short serialVersion) throws RemoteException {
        this.overloadedNeighbor(storageNodeId, null, serialVersion);
    }

    @Override
    public void overloadedNeighbor(StorageNodeId storageNodeId, AuthContext authContext, short serialVersion) throws RemoteException {
        if (this.shutdown.get()) {
            return;
        }
        this.rebalanceThread.overloadedNeighbor(storageNodeId);
    }

    public LoginManager getLoginManager() {
        return this.loginMgr;
    }

    public static class SNInfo {
        final String storename;
        final StorageNodeId snId;
        final String snHostname;
        final int snRegistryPort;

        public SNInfo(String storename, StorageNodeId snId, String snHostname, int snRegistryPort) {
            this.storename = storename;
            this.snId = snId;
            this.snHostname = snHostname;
            this.snRegistryPort = snRegistryPort;
        }
    }
}

