/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna.masterBalance;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.topo.RepNodeId;

abstract class LeaseManager {
    protected final Map<RepNodeId, LeaseTask> leaseTasks;
    private final Timer leaseTimer = new Timer(true);
    private final AtomicBoolean shutdown;
    protected final Logger logger;

    LeaseManager(Logger logger) {
        this.logger = logger;
        this.shutdown = new AtomicBoolean(false);
        this.leaseTasks = new ConcurrentHashMap<RepNodeId, LeaseTask>();
    }

    synchronized int leaseCount() {
        return this.leaseTasks.size();
    }

    synchronized boolean hasLease(RepNodeId rnId) {
        return this.leaseTasks.get(rnId) != null;
    }

    synchronized boolean cancel(RepNodeId rnId) {
        assert (Thread.holdsLock(this));
        LeaseTask leaseTask = this.leaseTasks.get(rnId);
        if (leaseTask == null) {
            return false;
        }
        leaseTask.cancel();
        return true;
    }

    public void shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            this.leaseTimer.cancel();
        }
    }

    class LeaseTask
    extends TimerTask {
        private final Lease lease;

        LeaseTask(Lease lease) {
            assert (Thread.holdsLock(LeaseManager.this));
            this.lease = lease;
            LeaseManager.this.leaseTasks.put(lease.getRepNodeId(), this);
            LeaseManager.this.leaseTimer.schedule((TimerTask)this, lease.getLeaseDuration());
        }

        public Lease getLease() {
            return this.lease;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            LeaseManager leaseManager = LeaseManager.this;
            synchronized (leaseManager) {
                LeaseTask leaseTask = LeaseManager.this.leaseTasks.remove(this.lease.getRepNodeId());
                assert (leaseTask == this);
                LeaseManager.this.logger.info("Cancelled lease:" + this.lease + " lease count:" + LeaseManager.this.leaseTasks.size());
                return super.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LeaseManager.this.shutdown.get()) {
                return;
            }
            try {
                LeaseManager leaseManager = LeaseManager.this;
                synchronized (leaseManager) {
                    if (LeaseManager.this.leaseTasks.containsKey(this.lease.getRepNodeId())) {
                        this.cancel();
                    }
                }
            }
            catch (Exception e) {
                LeaseManager.this.logger.log(Level.SEVERE, "Lease expiration task exiting due to exception.", e);
            }
        }
    }

    public static interface Lease {
        public RepNodeId getRepNodeId();

        public int getLeaseDuration();
    }
}

