/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.net.SocketTimeoutException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.sna.ManagedRepNode;
import oracle.kv.impl.sna.ServiceManager;
import oracle.kv.impl.sna.StorageNodeAgent;

class RNShutdownThread
implements Runnable {
    private final StorageNodeAgent sna;
    private final Logger logger;
    private final int serviceWaitMs;
    private final ServiceManager mgr;
    private final boolean stopService;
    private final boolean force;

    RNShutdownThread(StorageNodeAgent sna, ServiceManager mgr, int serviceWaitMs, boolean stopService, boolean force) {
        this.sna = sna;
        this.serviceWaitMs = serviceWaitMs;
        this.logger = sna.getLogger();
        this.mgr = mgr;
        this.stopService = stopService;
        this.force = force;
    }

    public ServiceManager getMgr() {
        return this.mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ManagedRepNode mrn;
            RepNodeAdminAPI rna;
            this.mgr.dontRestart();
            if (this.mgr.forceOK(this.force)) {
                this.mgr.stop();
                return;
            }
            if (!this.stopService) {
                return;
            }
            if (this.mgr.isRunning() && (rna = (mrn = (ManagedRepNode)this.mgr.getService()).waitForRepNodeAdmin(this.sna, 5)) != null) {
                try {
                    rna.shutdown(this.force);
                }
                catch (RemoteException e) {
                    Throwable ce = e.getCause();
                    if (!(ce instanceof SocketTimeoutException)) {
                        throw e;
                    }
                    this.logger.warning(String.format("Socket timed out waiting for %s. Message:%s. Wait %,d ms for process exit.", this.mgr.getService().getServiceName(), ce.getMessage(), this.serviceWaitMs));
                }
            }
            this.mgr.waitFor(this.serviceWaitMs);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, this.mgr.getService().getServiceName() + ": Exception stopping RepNode", e);
            this.mgr.stop();
        }
        finally {
            this.sna.unbindService(this.sna.makeRepNodeBindingName(this.mgr.getService().getServiceName()));
        }
    }
}

