/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.sna.ManagedService;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;
import oracle.kv.impl.util.registry.RegistryUtils;

public class ManagedRepNode
extends ManagedService {
    private SecurityParams sp;
    private RepNodeParams rnp;
    private RepNodeAdminAPI repNodeAdmin;
    private LoadParameters lp;

    public ManagedRepNode(SecurityParams sp, RepNodeParams rnp, File kvRoot, File kvSNDir, String kvName) {
        super(kvRoot, sp.getConfigDir(), kvSNDir, kvName, "RepNode", rnp.getRepNodeId().getFullName(), rnp.getMap());
        this.sp = sp;
        this.rnp = rnp;
        this.repNodeAdmin = null;
    }

    public ManagedRepNode(String kvSecDir, String kvSNDir, String kvName, String serviceClass, String serviceName) {
        super(null, ManagedRepNode.nullableFile(kvSecDir), new File(kvSNDir), kvName, serviceClass, serviceName, null);
        this.resetParameters(!usingThreads);
        this.startLogger(RepNodeService.class, this.rnp.getRepNodeId(), this.lp);
        this.repNodeAdmin = null;
    }

    @Override
    public void resetParameters(boolean inTarget) {
        this.sp = this.getSecurityParameters();
        this.lp = this.getParameters();
        this.params = this.lp.getMap(this.serviceName, "repNodeParams");
        this.rnp = new RepNodeParams(this.params);
        this.rnp.validateCacheAndHeap(inTarget);
    }

    @Override
    public String getDefaultJavaArgs(String overrideJvmArgs) {
        String defaultJavaArgs = RepNodeService.DEFAULT_MISC_JAVA_ARGS + " " + (overrideJvmArgs != null && overrideJvmArgs.contains("-XX:+UseG1GC") ? "-XX:+UseG1GC -XX:NewRatio=15 -XX:MaxTenuringThreshold=10 -XX:InitiatingHeapOccupancyPercent=80" : "-XX:+UseConcMarkSweepGC -XX:+UseParNewGC -XX:+DisableExplicitGC -XX:NewRatio=18 -XX:SurvivorRatio=4 -XX:MaxTenuringThreshold=10 -XX:CMSInitiatingOccupancyFraction=80 ");
        String resourceName = this.rnp.getRepNodeId().toString();
        Parameter numGCLogFiles = this.rnp.getMap().getOrDefault("rnNumGCLogFiles");
        Parameter gcLogFileSize = this.rnp.getMap().getOrDefault("rnGCLogFileSize");
        return defaultJavaArgs + this.getGCLoggingArgs(numGCLogFiles, gcLogFileSize, resourceName);
    }

    @Override
    public ResourceId getResourceId() {
        if (this.rnp != null) {
            return this.rnp.getRepNodeId();
        }
        throw new IllegalStateException("No resource id");
    }

    @Override
    public void resetHandles() {
        this.repNodeAdmin = null;
    }

    @Override
    public String getJVMArgs() {
        if (this.params != null) {
            String args = "";
            if (this.params.exists("javaMiscParams")) {
                args = args + this.params.get("javaMiscParams").asString();
            }
            return args;
        }
        return null;
    }

    public RepNodeParams getRepNodeParams() {
        return this.rnp;
    }

    public RepNodeAdminAPI getRepNodeAdmin(StorageNodeAgent sna) throws RemoteException {
        if (this.repNodeAdmin == null) {
            try {
                this.repNodeAdmin = RegistryUtils.getRepNodeAdmin(sna.getStoreName(), sna.getHostname(), sna.getRegistryPort(), this.rnp.getRepNodeId(), sna.getLoginManager());
            }
            catch (NotBoundException ne) {
                String msg = "Cannot get handle from Registry: " + this.rnp.getRepNodeId().getFullName() + ": " + ne.getMessage();
                sna.getLogger().severe(msg);
                throw new RemoteException(msg, ne);
            }
        }
        return this.repNodeAdmin;
    }

    protected RepNodeAdminAPI waitForRepNodeAdmin(StorageNodeAgent sna, int timeoutSec) {
        if (this.repNodeAdmin == null) {
            try {
                ConfigurableService.ServiceStatus[] target = new ConfigurableService.ServiceStatus[]{ConfigurableService.ServiceStatus.RUNNING};
                this.repNodeAdmin = ServiceUtils.waitForRepNodeAdmin(sna.getStoreName(), sna.getHostname(), sna.getRegistryPort(), this.rnp.getRepNodeId(), sna.getStorageNodeId(), sna.getLoginManager(), timeoutSec, target);
            }
            catch (Exception e) {
                String msg = "Cannot get RepNodeAdmin handle from Registry: " + this.rnp.getRepNodeId().getFullName() + ": " + e.getMessage();
                sna.getLogger().severe(msg);
                return null;
            }
        }
        return this.repNodeAdmin;
    }

    @Override
    public void start(boolean threads) {
        final RepNodeService rns = new RepNodeService(threads);
        rns.getFaultHandler().setLogger(this.logger);
        rns.getFaultHandler().execute(new ProcessFaultHandler.Procedure<RuntimeException>(){

            @Override
            public void execute() {
                rns.initialize(ManagedRepNode.this.sp, ManagedRepNode.this.rnp, ManagedRepNode.this.lp);
                rns.start();
            }
        });
    }
}

