/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.sna.ManagedService;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.registry.RegistryUtils;

public class ManagedAdmin
extends ManagedService {
    protected SecurityParams sp;
    protected AdminParams ap;
    protected CommandServiceAPI cs;
    private LoadParameters lp;

    public ManagedAdmin(SecurityParams sp, AdminParams ap, File kvRoot, File kvSNDir, String kvName) {
        super(kvRoot, sp.getConfigDir(), kvSNDir, kvName, "Admin", ap.getAdminId().getFullName(), ap.getMap());
        this.sp = sp;
        this.ap = ap;
        this.cs = null;
    }

    public ManagedAdmin(File rootDir, File secDir, String serviceName) {
        super(null, secDir, rootDir, null, "Admin", serviceName, null);
        this.sp = null;
        this.ap = null;
        this.cs = null;
    }

    public ManagedAdmin(String kvSecDir, String kvSNDir, String kvName, String serviceClass, String serviceName) {
        super(null, ManagedAdmin.nullableFile(kvSecDir), new File(kvSNDir), kvName, serviceClass, serviceName, null);
        this.resetParameters(true);
        this.startLogger(AdminService.class, this.ap.getAdminId(), this.lp);
        this.cs = null;
    }

    @Override
    public void resetParameters(boolean inTarget) {
        this.sp = this.getSecurityParameters();
        this.lp = this.getParameters();
        this.params = this.lp.getMap(this.serviceName, "adminParams");
        if (this.params == null) {
            this.params = this.lp.getMapByType("adminParams");
        }
        if (this.params != null) {
            this.ap = new AdminParams(this.params);
        }
    }

    @Override
    public String getDefaultJavaArgs(String overrideJvmArgs) {
        if (this.ap == null || this.ap.getMap() == null) {
            return "-XX:+DisableExplicitGC -Xms96M -Xmx128M -XX:+HeapDumpOnOutOfMemoryError -server -Dje.rep.skipHelperHostResolution=true";
        }
        Parameter gcLogFiles = this.ap.getMap().getOrDefault("numGCLogFiles");
        Parameter gcLogFileSize = this.ap.getMap().getOrDefault("GCLogFileSize");
        String resourceName = this.ap.getAdminId().toString();
        return "-XX:+DisableExplicitGC -Xms96M -Xmx128M -XX:+HeapDumpOnOutOfMemoryError -server -Dje.rep.skipHelperHostResolution=true" + this.getGCLoggingArgs(gcLogFiles, gcLogFileSize, resourceName);
    }

    @Override
    public ResourceId getResourceId() {
        if (this.ap != null) {
            return this.ap.getAdminId();
        }
        return new AdminId(0);
    }

    @Override
    public void resetHandles() {
        this.cs = null;
    }

    public AdminParams getAdminParams() {
        return this.ap;
    }

    public CommandServiceAPI getAdmin(StorageNodeAgent sna) throws RemoteException {
        if (this.cs == null) {
            try {
                this.cs = RegistryUtils.getAdmin(sna.getHostname(), sna.getRegistryPort(), sna.getLoginManager());
            }
            catch (NotBoundException ne) {
                String msg = "Cannot get admin handle from Registry: " + ne.getMessage();
                sna.getLogger().severe(msg);
                throw new RemoteException(msg, ne);
            }
        }
        return this.cs;
    }

    @Override
    public void start(boolean threads) {
        AdminService as = new AdminService(threads);
        as.initialize(this.sp, this.ap, this.lp);
        as.start();
    }

    @Override
    public boolean resetOnRestart() {
        return true;
    }
}

