/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import oracle.kv.impl.security.util.Cache;
import oracle.kv.impl.security.util.LruCacheImpl;

public class CacheBuilder {
    private CacheBuilder() {
    }

    public static <K, V extends CacheEntry> Cache<K, V> build(CacheConfig config) {
        switch (config.getEvictionPolicy()) {
            case LRU: {
                return new LruCacheImpl(config);
            }
            case LFU: {
                throw new UnsupportedOperationException("LFU cache is not yet supported in this version");
            }
        }
        throw new AssertionError();
    }

    public static abstract class TimeBasedCleanupTask
    implements Runnable {
        private volatile boolean terminated = false;
        private final long cleanupPeriodMs;
        private final Thread cleanUpThread;

        TimeBasedCleanupTask(long cleanupPeriodMs) {
            this.cleanupPeriodMs = cleanupPeriodMs;
            this.cleanUpThread = new Thread((Runnable)this, "CacheCleanUpThread");
            this.cleanUpThread.setDaemon(true);
            this.cleanUpThread.start();
        }

        void stop(boolean wait) {
            this.terminated = true;
            this.cleanUpThread.interrupt();
            if (wait) {
                try {
                    this.cleanUpThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            while (!this.terminated) {
                try {
                    Thread.sleep(this.cleanupPeriodMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.terminated) {
                    return;
                }
                this.cleanup();
            }
            return;
        }

        abstract void cleanup();
    }

    public static class CacheEntry {
        private final long createTime = System.currentTimeMillis();

        protected CacheEntry() {
        }

        public long getCreateTime() {
            return this.createTime;
        }
    }

    public static class CacheConfig {
        private int capacity = -1;
        private long entryLifetime = -1L;
        private boolean enableEviction = true;
        private EvictionPolicy evictionPolicy = EvictionPolicy.LRU;
        private float thresholdRatio = 1.0f;
        private int evictionBatchSize = 1;

        public CacheConfig capacity(int newCapacity) {
            this.capacity = newCapacity;
            return this;
        }

        public CacheConfig entryLifetime(long newLifetime) {
            this.entryLifetime = newLifetime;
            return this;
        }

        public CacheConfig evictionPolicy(EvictionPolicy policy) {
            this.evictionPolicy = policy;
            return this;
        }

        public CacheConfig enableEviction() {
            this.enableEviction = true;
            return this;
        }

        public CacheConfig thresholdRatio(float thdRatio) {
            if (Float.compare(0.0f, thdRatio) >= 0 || Float.compare(thdRatio, 1.0f) > 0) {
                throw new IllegalArgumentException("Threshold ratio must fall in range of (0, 1]");
            }
            this.thresholdRatio = thdRatio;
            return this;
        }

        public CacheConfig evictionBatchSize(int batchSize) {
            if (batchSize <= 0) {
                throw new IllegalArgumentException("Batch size must be positive");
            }
            this.evictionBatchSize = batchSize;
            return this;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public long getEntryLifetime() {
            return this.entryLifetime;
        }

        public boolean isEvictionEnabled() {
            return this.enableEviction;
        }

        public float getThresholdRatio() {
            return this.thresholdRatio;
        }

        public int getEvictionBatchSize() {
            return this.evictionBatchSize;
        }

        public EvictionPolicy getEvictionPolicy() {
            return this.evictionPolicy;
        }
    }

    public static enum EvictionPolicy {
        LRU,
        LFU;

    }
}

