/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import java.util.Random;

public class BloomFilter {
    private static final long FNVOffsetBasis = 2166136261L;
    private static final long FNVPrime = 16777619L;
    private static final int M_N_RATIO = 8;
    private static final int K = 3;

    public static void add(byte[] bf, byte[] key, HashContext hc) {
        BloomFilter.hash(bf, key, hc);
        for (int idx : hc.hashes) {
            BloomFilter.setBit(bf, idx);
        }
    }

    public static boolean contains(byte[] bf, byte[] key) {
        HashContext hc = new HashContext();
        BloomFilter.hash(bf, key, hc);
        for (int idx : hc.hashes) {
            if (BloomFilter.getBit(bf, idx)) continue;
            return false;
        }
        return true;
    }

    private static void hash(byte[] bf, byte[] key, HashContext hc) {
        assert (hc.hashes.length == 3);
        hc.rng.setSeed(BloomFilter.hashFNV(key, hc.initFNVvalue));
        int numBits = bf.length * 8;
        if (numBits <= 1024) {
            int hash = hc.rng.nextInt();
            hc.hashes[0] = (hash & 0x3FF) % numBits;
            hc.hashes[1] = ((hash >>= 10) & 0x3FF) % numBits;
            hc.hashes[2] = ((hash >>= 10) & 0x3FF) % numBits;
        } else {
            hc.hashes[0] = hc.rng.nextInt() % numBits;
            hc.hashes[1] = hc.rng.nextInt() % numBits;
            hc.hashes[2] = hc.rng.nextInt() % numBits;
        }
    }

    private static long hashFNV(byte[] key, long initValue) {
        long hash = initValue;
        for (byte b : key) {
            hash = hash * 16777619L & 0xFFFFFFFFFFFFFFFFL;
            hash ^= (long)b;
        }
        return hash;
    }

    public static int getByteSize(int numKeys) {
        assert (numKeys > 0);
        int nbits = numKeys * 8;
        return (nbits + 7) / 8;
    }

    public static String toString(byte[] bf) {
        StringBuilder sb = new StringBuilder();
        int nbits = bf.length * 8;
        for (int i = 0; i < nbits; ++i) {
            sb.append(BloomFilter.getBit(bf, i) ? 1 : 0);
        }
        return sb.toString();
    }

    private static void setBit(byte[] bf, int idx) {
        int n = idx / 8;
        bf[n] = (byte)(bf[n] | 1 << idx % 8);
    }

    private static boolean getBit(byte[] bf, int idx) {
        return (bf[idx / 8] & 1 << idx % 8) != 0;
    }

    public static class HashContext {
        public int[] hashes = new int[3];
        public Random rng = new Random();
        public long initFNVvalue = 2166136261L;
    }
}

