/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMDChange;
import oracle.kv.impl.security.metadata.SecurityMetadataInfo;
import oracle.kv.impl.util.SerializationUtil;

public class SecurityMetadata
implements Metadata<SecurityMetadataInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final KVStoreUserMap kvstoreUserMap = new KVStoreUserMap(this);
    private KVStoreRoleMap kvstoreRoleMap = new KVStoreRoleMap(this);
    private final String kvstoreName;
    private final LinkedList<SecurityMDChange> changeList = new LinkedList();
    private int sequenceNumber = 0;
    private static final TreeMap<String, RoleInstance.RoleDescription> builtInRoleInfoMap = new TreeMap();

    public SecurityMetadata(String storeName) {
        this(storeName, "SecurityMD-" + System.currentTimeMillis());
    }

    public SecurityMetadata(String storeName, String id) {
        this.kvstoreName = storeName;
        this.id = id;
    }

    public String getKVStoreName() {
        return this.kvstoreName;
    }

    public String getId() {
        return this.id;
    }

    public KVStoreUser getUser(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Collection users = this.kvstoreUserMap.getAll();
        for (KVStoreUser user : users) {
            if (!name.equals(user.getName())) continue;
            return user;
        }
        return null;
    }

    public RoleInstance getRole(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Collection roles = this.kvstoreRoleMap.getAll();
        for (RoleInstance role : roles) {
            if (!name.equalsIgnoreCase(role.name())) continue;
            return role;
        }
        return null;
    }

    public KVStoreUser getUserById(String uid) {
        return (KVStoreUser)this.kvstoreUserMap.get(uid);
    }

    public RoleInstance getRoleById(String rid) {
        return (RoleInstance)this.kvstoreRoleMap.get(rid);
    }

    public Collection<KVStoreUser> getAllUsers() {
        return this.kvstoreUserMap.getAll();
    }

    public Collection<RoleInstance> getAllRoles() {
        return this.kvstoreRoleMap.getAll();
    }

    public KVStoreUserMap getKVStoreUserMap() {
        return this.kvstoreUserMap;
    }

    public KVStoreRoleMap getRoleInstanceMap() {
        return this.kvstoreRoleMap;
    }

    public KVStoreUser addUser(KVStoreUser user) {
        return this.kvstoreUserMap.add(user);
    }

    public RoleInstance addRole(RoleInstance role) {
        return this.kvstoreRoleMap.add(role);
    }

    public KVStoreUser removeUser(String uid) {
        return (KVStoreUser)this.kvstoreUserMap.remove(uid);
    }

    public RoleInstance removeRole(String rid) {
        return (RoleInstance)this.kvstoreRoleMap.remove(rid);
    }

    public KVStoreUser updateUser(String uid, KVStoreUser user) {
        return this.kvstoreUserMap.update(uid, user);
    }

    public RoleInstance updateRole(String rid, RoleInstance role) {
        return this.kvstoreRoleMap.update(rid, role);
    }

    public boolean verifyUserPassword(String userName, char[] password) {
        KVStoreUser user = this.getUser(userName);
        if (user == null) {
            return false;
        }
        return user.verifyPassword(password);
    }

    public SortedMap<String, KVStoreUser.UserDescription> getUsersDescription() {
        Collection<KVStoreUser> users = this.getAllUsers();
        TreeMap<String, KVStoreUser.UserDescription> userInfoMap = new TreeMap<String, KVStoreUser.UserDescription>();
        for (KVStoreUser user : users) {
            userInfoMap.put(user.getName(), user.getDescription());
        }
        return userInfoMap;
    }

    public SortedMap<String, RoleInstance.RoleDescription> getRolesDescription() {
        TreeMap<String, RoleInstance.RoleDescription> roleDescMap = new TreeMap<String, RoleInstance.RoleDescription>((SortedMap<String, RoleInstance.RoleDescription>)builtInRoleInfoMap);
        for (RoleInstance role : this.kvstoreRoleMap.getAll()) {
            roleDescMap.put(role.name(), role.getDescription());
        }
        return roleDescMap;
    }

    public Map<String, KVStoreUser.UserDescription> getCurrentUserDescription() {
        KVStoreUserPrincipal currentUserPrinc = KVStoreUserPrincipal.getCurrentUser();
        if (currentUserPrinc == null) {
            return null;
        }
        KVStoreUser currentUser = (KVStoreUser)this.kvstoreUserMap.get(currentUserPrinc.getUserId());
        if (currentUser == null) {
            return null;
        }
        HashMap<String, KVStoreUser.UserDescription> userInfoMap = new HashMap<String, KVStoreUser.UserDescription>();
        userInfoMap.put(currentUser.getName(), currentUser.getDescription());
        return userInfoMap;
    }

    public boolean isLastSysadminUser(String userName) {
        KVStoreUser existUser = this.getUser(userName);
        if (existUser != null && existUser.isAdmin()) {
            for (KVStoreUser user : this.getAllUsers()) {
                if (user.getName().equals(userName) || !user.isEnabled() || !user.isAdmin()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean apply(List<SecurityMDChange> changes) {
        if (changes == null || changes.isEmpty()) {
            return false;
        }
        if (changes.get(0).getSeqNum() > this.getSequenceNumber() + 1) {
            throw new IllegalStateException("Unexpected gap in security metadata sequence. Current sequence = " + this.getSequenceNumber() + ", first change =" + changes.get(0).getSeqNum());
        }
        int changedCount = 0;
        for (SecurityMDChange change : changes) {
            if (change.getSeqNum() <= this.getSequenceNumber()) continue;
            if (change.getElementType() == SecurityElementType.KVSTOREUSER) {
                this.kvstoreUserMap.apply(change);
                ++changedCount;
                continue;
            }
            if (change.getElementType() == SecurityElementType.KVSTOREROLE) {
                this.kvstoreRoleMap.apply(change);
                ++changedCount;
                continue;
            }
            throw new IllegalArgumentException("Unknown security element type: " + (Object)((Object)change.getElementType()));
        }
        return changedCount > 0;
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.SECURITY;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public SecurityMetadataInfo getChangeInfo(int startSeqNum) {
        return new SecurityMetadataInfo(this, this.getChanges(startSeqNum));
    }

    public int getFirstChangeSeqNum() {
        return this.changeList.size() == 0 ? -1 : this.changeList.getFirst().getSeqNum();
    }

    public List<SecurityMDChange> getChanges(int startSeqNum) {
        if (this.changeList.isEmpty()) {
            return null;
        }
        if (startSeqNum < this.getFirstChangeSeqNum() || startSeqNum > this.changeList.getLast().getSeqNum()) {
            return null;
        }
        LinkedList<SecurityMDChange> retChanges = new LinkedList<SecurityMDChange>();
        for (SecurityMDChange change : this.changeList) {
            if (change.getSeqNum() < startSeqNum) continue;
            retChanges.add(change.clone());
        }
        return retChanges;
    }

    public List<SecurityMDChange> getChanges() {
        return this.getChanges(this.changeList.size() == 0 ? 0 : this.changeList.getFirst().seqNum);
    }

    public SecurityMDChange getLatestChange() {
        return this.changeList.getLast();
    }

    public void discardChanges(int newStartSeqNum) {
        Iterator itr = this.changeList.iterator();
        while (itr.hasNext() && ((SecurityMDChange)itr.next()).getSeqNum() < newStartSeqNum) {
            itr.remove();
        }
    }

    public SecurityMetadata getCopy() {
        byte[] mdBytes = SerializationUtil.getBytes(this);
        return (SecurityMetadata)SerializationUtil.getObject(mdBytes, this.getClass());
    }

    public String toString() {
        return String.format("SecurityMetadata id=%s seq# %d", this.id, this.sequenceNumber);
    }

    public void logChange(SecurityMDChange change) {
        ++this.sequenceNumber;
        change.setSeqNum(this.sequenceNumber);
        this.changeList.add(change);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.kvstoreRoleMap == null) {
            this.kvstoreRoleMap = new KVStoreRoleMap(this);
        }
    }

    public static Map<String, RoleInstance.RoleDescription> getBuiltInRoleInfo() {
        return Collections.unmodifiableMap(builtInRoleInfoMap);
    }

    public void setRoleMapId(int id) {
        this.kvstoreRoleMap.setId(id);
    }

    static {
        builtInRoleInfoMap.put("dbadmin", RoleInstance.DBADMIN.getDescription());
        builtInRoleInfoMap.put("readonly", RoleInstance.READONLY.getDescription());
        builtInRoleInfoMap.put("readwrite", RoleInstance.READWRITE.getDescription());
        builtInRoleInfoMap.put("sysadmin", RoleInstance.SYSADMIN.getDescription());
        builtInRoleInfoMap.put("writeonly", RoleInstance.WRITEONLY.getDescription());
        builtInRoleInfoMap.put("public", RoleInstance.PUBLIC.getDescription());
    }

    protected static abstract class ElementMap<T extends SecurityElement>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SecurityMetadata securityMD;
        private final HashMap<String, T> elementMap = new HashMap();
        int idSequence;

        public ElementMap(SecurityMetadata securityMD) {
            this.securityMD = securityMD;
        }

        T get(String elementId) {
            return (T)((SecurityElement)this.elementMap.get(elementId));
        }

        Collection<T> getAll() {
            return this.elementMap.values();
        }

        T add(T element) {
            return this.add(this.nextId(), element);
        }

        T add(String elementId, T element) {
            ((SecurityElement)element).setElementId(elementId);
            SecurityElement prev = (SecurityElement)this.elementMap.put(elementId, element);
            this.securityMD.logChange(new SecurityMDChange.Add((SecurityElement)element));
            if (prev != null) {
                throw new IllegalStateException("Element " + prev + " was been overwritten by " + element);
            }
            return element;
        }

        T update(String elementId, T element) {
            if (this.elementMap.get(elementId) == null) {
                throw new IllegalArgumentException("Element " + elementId + " absent from security metadata.");
            }
            ((SecurityElement)element).setElementId(elementId);
            SecurityElement prev = (SecurityElement)this.elementMap.put(elementId, element);
            assert (prev != null);
            this.securityMD.logChange(new SecurityMDChange.Update((SecurityElement)element));
            return element;
        }

        T remove(String elementId) {
            SecurityElement prev = (SecurityElement)this.elementMap.remove(elementId);
            if (prev == null) {
                throw new IllegalArgumentException("Element " + elementId + "was not found.");
            }
            this.securityMD.logChange(new SecurityMDChange.Remove(elementId, this.getElementType(), prev));
            return (T)prev;
        }

        void apply(SecurityMDChange change) {
            SecurityMDChange.SecurityMDChangeType changeType = change.getChangeType();
            String changeElementId = change.getElementId();
            switch (changeType) {
                case REMOVE: {
                    this.remove(changeElementId);
                    break;
                }
                case ADD: {
                    String newId = this.nextId();
                    if (!newId.equals(changeElementId)) {
                        throw new IllegalStateException("Element sequence out of sync; expected: " + newId + " replayId: " + changeElementId);
                    }
                    this.add(newId, change.getElement());
                    break;
                }
                case UPDATE: {
                    this.update(changeElementId, change.getElement());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown change type: " + (Object)((Object)changeType));
                }
            }
            if (this.securityMD.getSequenceNumber() != change.getSeqNum()) {
                throw new IllegalStateException("Mismatched security metadata change sequence: log# " + change.getSeqNum() + ", replay# " + this.securityMD.getSequenceNumber());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 527 + this.elementMap.hashCode();
            return result * 31 + this.idSequence;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ElementMap other = (ElementMap)obj;
            return this.idSequence == other.idSequence && this.elementMap.equals(other.elementMap);
        }

        abstract String nextId();

        abstract SecurityElementType getElementType();
    }

    public static abstract class SecurityElement
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private String elementId;

        protected SecurityElement() {
        }

        protected SecurityElement(SecurityElement other) {
            this.elementId = other.elementId;
        }

        public void setElementId(String eId) {
            this.elementId = eId;
        }

        public String getElementId() {
            return this.elementId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SecurityElement)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            SecurityElement other = (SecurityElement)obj;
            return this.elementId == other.elementId || this.elementId != null && this.elementId.equals(other.elementId);
        }

        public abstract int hashCode();

        public abstract SecurityElement clone();

        public abstract SecurityElementType getElementType();
    }

    public static class KVStoreRoleMap
    extends ElementMap<RoleInstance> {
        private static final long serialVersionUID = 1L;
        private int currentId;

        public KVStoreRoleMap(SecurityMetadata securityMD) {
            super(securityMD);
        }

        @Override
        String nextId() {
            return "r" + this.getNextId();
        }

        void setId(int id) {
            this.idSequence = id;
        }

        private int getNextId() {
            if (this.idSequence < Integer.MAX_VALUE) {
                this.currentId = this.idSequence++;
                return this.idSequence;
            }
            this.currentId = 1;
            while (this.currentId < this.idSequence) {
                if (this.get("r" + this.currentId) == null) {
                    return this.currentId;
                }
                ++this.currentId;
            }
            throw new IllegalStateException("Could not add role, the number of roles exceeds the limit");
        }

        @Override
        SecurityElementType getElementType() {
            return SecurityElementType.KVSTOREROLE;
        }
    }

    public static class KVStoreUserMap
    extends ElementMap<KVStoreUser> {
        private static final long serialVersionUID = 1L;

        public KVStoreUserMap(SecurityMetadata securityMD) {
            super(securityMD);
        }

        @Override
        String nextId() {
            return "u" + ++this.idSequence;
        }

        @Override
        SecurityElementType getElementType() {
            return SecurityElementType.KVSTOREUSER;
        }
    }

    public static enum SecurityElementType {
        KVSTOREUSER,
        KVSTOREROLE;

    }
}

