/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.impl.security.metadata.SecurityMDChange;
import oracle.kv.impl.security.metadata.SecurityMDListener;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class SecurityMDUpdater {
    private final Set<UserChangeUpdater> userUpdaters = Collections.synchronizedSet(new HashSet());
    private final Set<RoleChangeUpdater> roleUpdaters = Collections.synchronizedSet(new HashSet());

    public void addUserChangeUpdaters(UserChangeUpdater ... updaters) {
        for (UserChangeUpdater updater : updaters) {
            this.userUpdaters.add(updater);
        }
    }

    public void addRoleChangeUpdaters(RoleChangeUpdater ... updaters) {
        for (RoleChangeUpdater updater : updaters) {
            this.roleUpdaters.add(updater);
        }
    }

    public static interface RoleChangeUpdater {
        public void newRoleDefinition(SecurityMDChange var1);
    }

    public static interface UserChangeUpdater {
        public void newUserDefinition(SecurityMDChange var1);
    }

    public class RoleChangeListener
    implements SecurityMDListener {
        @Override
        public void notifyMetadataChange(SecurityMDChange mdChange) {
            if (mdChange.getElementType() != SecurityMetadata.SecurityElementType.KVSTOREROLE) {
                return;
            }
            for (RoleChangeUpdater roleUpdater : SecurityMDUpdater.this.roleUpdaters) {
                roleUpdater.newRoleDefinition(mdChange);
            }
        }
    }

    public class UserChangeListener
    implements SecurityMDListener {
        @Override
        public void notifyMetadataChange(SecurityMDChange mdChange) {
            if (mdChange.getElementType() != SecurityMetadata.SecurityElementType.KVSTOREUSER) {
                return;
            }
            for (UserChangeUpdater userUpdater : SecurityMDUpdater.this.userUpdaters) {
                userUpdater.newUserDefinition(mdChange);
            }
        }
    }
}

