/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.metadata.PasswordHashDigest;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class KVStoreUser
extends SecurityMetadata.SecurityElement {
    private static final long serialVersionUID = 1L;
    private static final Set<String> USER_V1_DEFAULT_ROLES;
    private static final Set<String> ADMIN_V1_DEFAULT_ROLES;
    final String userName;
    private UserType userType = UserType.LOCAL;
    private PasswordHashDigest primaryPassword;
    private PasswordHashDigest retainedPassword;
    private boolean enabled;
    boolean isAdmin;

    public static KVStoreUser newInstance(String name, boolean enableRoles) {
        if (enableRoles) {
            return new KVStoreUserV2(name);
        }
        return new KVStoreUser(name);
    }

    private KVStoreUser(String name) {
        this.userName = name;
    }

    private KVStoreUser(KVStoreUser other) {
        super(other);
        this.userName = other.userName;
        this.userType = other.userType;
        this.enabled = other.enabled;
        this.isAdmin = other.isAdmin;
        this.primaryPassword = other.primaryPassword == null ? null : other.primaryPassword.clone();
        this.retainedPassword = other.retainedPassword == null ? null : other.retainedPassword.clone();
    }

    KVStoreUser setUserType(UserType type) {
        this.userType = type;
        return this;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String getName() {
        return this.userName;
    }

    public KVStoreUser setPassword(PasswordHashDigest primaryPasswd) {
        this.primaryPassword = primaryPasswd;
        return this;
    }

    public KVStoreUser setPasswordLifetime(long amount) {
        this.primaryPassword.setLifetime(amount);
        return this;
    }

    public KVStoreUser retainPassword() {
        if (this.retainedPasswordValid()) {
            throw new IllegalStateException("Could not override an existing retained password.");
        }
        this.retainedPassword = this.primaryPassword;
        this.retainedPassword.refreshCreateTime();
        return this;
    }

    public PasswordHashDigest getPassword() {
        return this.primaryPassword;
    }

    public PasswordHashDigest getRetainedPassword() {
        return this.retainedPassword;
    }

    public void clearRetainedPassword() {
        this.retainedPassword = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAdmin() {
        return this.getGrantedRoles().contains("sysadmin");
    }

    public boolean retainedPasswordValid() {
        return this.retainedPassword != null && !this.retainedPassword.isExpired();
    }

    public KVStoreUser setAdmin(boolean flag) {
        this.isAdmin = flag;
        return this;
    }

    public KVStoreUser setEnabled(boolean flag) {
        this.enabled = flag;
        return this;
    }

    public UserDescription getDescription() {
        String retainInfo;
        boolean rPassActive = this.retainedPasswordValid();
        if (rPassActive) {
            String expireInfo = String.format("%d minutes", TimeUnit.MILLISECONDS.toMinutes(this.retainedPassword.getLifetime()));
            retainInfo = String.format("active [expiration: %s]", expireInfo);
        } else {
            retainInfo = "inactive";
        }
        String briefAsJSON = String.format("{\"id\":\"%s\", \"name\":\"%s\"}", super.getElementId(), this.userName);
        String details = String.format("%s enabled=%b type=%s retain-passwd=%s granted-roles=%s", new Object[]{this.toString(), this.enabled, this.userType, retainInfo, this.getGrantedRoles()});
        String detailsAsJSON = String.format("{\"id\":\"%s\", \"name\":\"%s\", \"enabled\":\"%b\", \"type\":\"%s\", \"retain-passwd\":\"%s\", \"granted-roles\":%s}", new Object[]{this.getElementId(), this.userName, this.enabled, this.userType, retainInfo, this.grantedRolesAsJSON()});
        return new UserDescription(this.toString(), briefAsJSON, details, detailsAsJSON);
    }

    public KVStoreUser grantRoles(Collection<String> roles) {
        return new KVStoreUserV2(this).grantRoles((Collection)roles);
    }

    public KVStoreUser revokeRoles(Collection<String> roles) {
        return new KVStoreUserV2(this).revokeRoles((Collection)roles);
    }

    public Set<String> getGrantedRoles() {
        if (this.isAdmin) {
            return ADMIN_V1_DEFAULT_ROLES;
        }
        return USER_V1_DEFAULT_ROLES;
    }

    private String grantedRolesAsJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (String role : this.getGrantedRoles()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("\"");
            sb.append(role);
            sb.append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean verifyPassword(char[] password) {
        if (password == null || password.length == 0) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        return this.getPassword().verifyPassword(password) || this.retainedPasswordValid() && this.getRetainedPassword().verifyPassword(password);
    }

    public boolean isPasswordExpired() {
        return this.primaryPassword.isExpired();
    }

    public Subject makeKVSubject() {
        String userId = this.getElementId();
        HashSet<Principal> userPrincipals = new HashSet<Principal>();
        userPrincipals.add(KVStoreRolePrincipal.AUTHENTICATED);
        if (this.isAdmin) {
            userPrincipals.add(KVStoreRolePrincipal.ADMIN);
        }
        userPrincipals.add(new KVStoreUserPrincipal(this.userName, userId));
        HashSet publicCreds = new HashSet();
        HashSet privateCreds = new HashSet();
        return new Subject(true, userPrincipals, publicCreds, privateCreds);
    }

    @Override
    public SecurityMetadata.SecurityElementType getElementType() {
        return SecurityMetadata.SecurityElementType.KVSTOREUSER;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 527 + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KVStoreUser)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        KVStoreUser other = (KVStoreUser)obj;
        if (this.userName == null) {
            return other.userName == null;
        }
        return this.userName.equals(other.userName);
    }

    public String toString() {
        return String.format("id=%s name=%s", super.getElementId(), this.userName);
    }

    @Override
    public KVStoreUser clone() {
        return new KVStoreUser(this);
    }

    static {
        String[] userV1RoleNames = new String[]{"public", "readwrite"};
        USER_V1_DEFAULT_ROLES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(userV1RoleNames)));
        String[] adminV1RoleNames = new String[]{"sysadmin", "readwrite", "public"};
        ADMIN_V1_DEFAULT_ROLES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(adminV1RoleNames)));
    }

    static class KVStoreUserV2
    extends KVStoreUser {
        private static final long serialVersionUID = 1L;
        private final Set<String> grantedRoles = new HashSet<String>();

        private KVStoreUserV2(String name) {
            super(name);
            this.grantedRoles.add("public");
        }

        private KVStoreUserV2(KVStoreUser other) {
            super(other);
            this.grantedRoles.addAll(other.getGrantedRoles());
        }

        @Override
        public KVStoreUserV2 setAdmin(boolean flag) {
            if (flag != this.isAdmin()) {
                this.isAdmin = flag;
                if (this.isAdmin) {
                    this.grantedRoles.add("sysadmin");
                } else {
                    this.grantedRoles.remove("sysadmin");
                }
            }
            return this;
        }

        @Override
        public KVStoreUserV2 grantRoles(Collection<String> roles) {
            for (String role : roles) {
                this.grantedRoles.add(RoleInstance.getNormalizedName(role));
            }
            return this;
        }

        @Override
        public KVStoreUserV2 revokeRoles(Collection<String> roles) {
            for (String role : roles) {
                this.grantedRoles.remove(RoleInstance.getNormalizedName(role));
            }
            return this;
        }

        @Override
        public Set<String> getGrantedRoles() {
            return Collections.unmodifiableSet(this.grantedRoles);
        }

        @Override
        public KVStoreUserV2 clone() {
            return new KVStoreUserV2(this);
        }

        @Override
        public Subject makeKVSubject() {
            String userId = this.getElementId();
            HashSet<Principal> userPrincipals = new HashSet<Principal>();
            for (String role : this.getGrantedRoles()) {
                KVStoreRolePrincipal princ = KVStoreRolePrincipal.get(role);
                userPrincipals.add(princ);
            }
            userPrincipals.add(new KVStoreUserPrincipal(this.userName, userId));
            HashSet publicCreds = new HashSet();
            HashSet privateCreds = new HashSet();
            return new Subject(true, userPrincipals, publicCreds, privateCreds);
        }
    }

    public static class UserDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String brief;
        private final String briefAsJSON;
        private final String details;
        private final String detailsAsJSON;

        public UserDescription(String brief, String briefAsJSON, String details, String detailsAsJSON) {
            this.brief = brief;
            this.briefAsJSON = briefAsJSON;
            this.details = details;
            this.detailsAsJSON = detailsAsJSON;
        }

        public String brief() {
            return this.brief;
        }

        public String briefAsJSON() {
            return this.briefAsJSON;
        }

        public String details() {
            return this.details;
        }

        public String detailsAsJSON() {
            return this.detailsAsJSON;
        }
    }

    public static enum UserType {
        LOCAL;

    }
}

