/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.security.login.TopologyResolver;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

public class TopoTopoResolver
implements TopologyResolver {
    private final TopoHandle topoHandle;
    private final TopologyResolver.SNInfo localSNInfo;
    private final Logger logger;

    public TopoTopoResolver(TopoHandle topoHandle, TopologyResolver.SNInfo localSNInfo, Logger logger) {
        this.topoHandle = topoHandle;
        this.localSNInfo = localSNInfo;
        this.logger = logger;
    }

    @Override
    public TopologyResolver.SNInfo getStorageNode(ResourceId target) {
        if (this.localSNInfo != null && target instanceof StorageNodeId && target.equals(this.localSNInfo.getStorageNodeId())) {
            this.logger.fine("TopoTopoResolver resolved target from localSNInfo");
            return this.localSNInfo;
        }
        Topology topo = this.topoHandle.getTopology();
        if (topo == null) {
            this.logger.info("TopoTopoResolver unable to resolve target: " + target + " without topology");
            return null;
        }
        Topology.Component<?> comp = topo.get(target);
        if (comp == null) {
            return null;
        }
        if (comp instanceof RepNode) {
            RepNode rn = (RepNode)comp;
            StorageNode sn = topo.get(rn.getStorageNodeId());
            if (sn == null) {
                throw new IllegalStateException("corrupted Topology");
            }
            return new TopologyResolver.SNInfo(sn.getHostname(), sn.getRegistryPort(), sn.getStorageNodeId());
        }
        if (comp instanceof StorageNode) {
            StorageNode sn = (StorageNode)comp;
            return new TopologyResolver.SNInfo(sn.getHostname(), sn.getRegistryPort(), sn.getStorageNodeId());
        }
        return null;
    }

    @Override
    public List<RepNodeId> listRepNodeIds(int maxReturn) {
        Topology topo = this.topoHandle.getTopology();
        if (topo == null) {
            return null;
        }
        ArrayList<RepNodeId> rnList = new ArrayList<RepNodeId>();
        for (RepNodeId rnId : topo.getRepNodeIds()) {
            if (rnList.size() >= maxReturn) break;
            rnList.add(rnId);
        }
        return rnList;
    }

    public static class TopoMgrTopoHandle
    implements TopoHandle {
        private volatile TopologyManager topoMgr;

        public TopoMgrTopoHandle(TopologyManager topoMgr) {
            this.topoMgr = topoMgr;
        }

        @Override
        public Topology getTopology() {
            return this.topoMgr.getTopology();
        }

        public void setTopoMgr(TopologyManager newTopoMgr) {
            this.topoMgr = newTopoMgr;
        }
    }

    public static class TopoTopoHandle
    implements TopoHandle {
        private volatile Topology topo;

        public TopoTopoHandle(Topology initialTopo) {
            this.topo = initialTopo;
        }

        @Override
        public Topology getTopology() {
            return this.topo;
        }

        public void setTopology(Topology newTopo) {
            this.topo = newTopo;
        }
    }

    public static interface TopoHandle {
        public Topology getTopology();
    }
}

