/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.security.auth.Subject;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.SessionId;
import oracle.kv.impl.security.login.TokenResolver;
import oracle.kv.impl.security.util.Cache;
import oracle.kv.impl.security.util.CacheBuilder;

public class TokenCache {
    private static final int REFRESH_QUEUE_MAX = 100;
    private final Cache<SessionId, SessionEntry> cache;
    private volatile long entryLifetimeMax;
    private final EntryRefresher refresher;

    public TokenCache(CacheBuilder.CacheConfig cacheConfig, TokenResolver resolver) {
        this.entryLifetimeMax = cacheConfig.getEntryLifetime();
        this.cache = CacheBuilder.build(cacheConfig);
        this.refresher = resolver == null ? null : new EntryRefresher(resolver);
    }

    public Subject lookup(LoginToken token) {
        long now;
        SessionId id = token.getSessionId();
        SessionEntry entry = this.cache.get(id);
        if (entry == null) {
            return null;
        }
        if (this.entryLifetimeMax > 0L && this.refresher != null && (now = System.currentTimeMillis()) > entry.getCreateTime() + this.entryLifetimeMax / 2L) {
            this.refresher.queueForRefresh(entry);
        }
        return entry.getSubject();
    }

    public void add(LoginToken token, Subject subject) {
        SessionId id = token.getSessionId();
        this.cache.put(id, new SessionEntry(token, subject));
    }

    public void stop(boolean wait) {
        if (this.refresher != null) {
            this.refresher.stop(wait);
        }
    }

    public long getEntryLifeTime() {
        return this.entryLifetimeMax;
    }

    public void setEntryLifeTime(long lifeTimeInMillis) {
        this.entryLifetimeMax = lifeTimeInMillis;
        this.cache.setEntryLifetime(lifeTimeInMillis);
    }

    public int getCacheSize() {
        return this.cache.getCapacity();
    }

    public EntryRefreshStats getRefreshStats() {
        return this.refresher == null ? new EntryRefreshStats(0) : this.refresher.getRefreshStats();
    }

    public List<SessionId> lookupSessionByUser(String userName) {
        ArrayList<SessionId> ids = new ArrayList<SessionId>();
        for (SessionEntry entry : this.cache.getAllValues()) {
            Subject subject = entry.getSubject();
            KVStoreUserPrincipal sessUserPrinc = ExecutionContext.getSubjectUserPrincipal(subject);
            if (sessUserPrinc == null || !sessUserPrinc.getName().equals(userName)) continue;
            ids.add(entry.getToken().getSessionId());
        }
        return ids;
    }

    public void updateSessionSubject(SessionId id, Subject newSubject) {
        SessionEntry entry = this.cache.get(id);
        if (entry != null && !entry.getSubject().equals(newSubject)) {
            entry.setSubject(newSubject);
        }
    }

    private final class EntryRefresher
    implements Runnable {
        private volatile boolean terminated = false;
        private final TokenResolver resolver;
        private final BlockingQueue<SessionEntry> refreshQueue;
        private final Thread refresherThread;
        private volatile int entryRefreshAttempts = 0;

        private EntryRefresher(TokenResolver resolver) {
            this.resolver = resolver;
            this.refreshQueue = new LinkedBlockingQueue<SessionEntry>(100);
            String threadName = "TokenRefresh";
            this.refresherThread = new Thread((Runnable)this, "TokenRefresh");
            this.refresherThread.setDaemon(true);
            this.refresherThread.start();
        }

        private void stop(boolean wait) {
            this.terminated = true;
            this.refresherThread.interrupt();
            if (wait) {
                try {
                    this.refresherThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueForRefresh(SessionEntry entry) {
            SessionEntry sessionEntry = entry;
            synchronized (sessionEntry) {
                if (!entry.isQueuedForRefresh() && this.refreshQueue.offer(entry)) {
                    entry.setQueuedForRefresh();
                }
            }
        }

        private EntryRefreshStats getRefreshStats() {
            return new EntryRefreshStats(this.entryRefreshAttempts);
        }

        @Override
        public void run() {
            while (!this.terminated) {
                try {
                    SessionEntry entry = this.refreshQueue.take();
                    ++this.entryRefreshAttempts;
                    Subject resolved = this.resolver.resolve(entry.getToken());
                    if (resolved == null) continue;
                    TokenCache.this.add(entry.getToken(), resolved);
                }
                catch (SessionAccessException sae) {
                }
                catch (InterruptedException ie) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    public static final class EntryRefreshStats {
        private int refreshAttempts;

        public EntryRefreshStats(int refreshAttempts) {
            this.refreshAttempts = refreshAttempts;
        }

        public int getRefreshAttempts() {
            return this.refreshAttempts;
        }
    }

    private final class SessionEntry
    extends CacheBuilder.CacheEntry {
        private final LoginToken token;
        private volatile Subject subject;
        private boolean queuedForRefresh;

        private SessionEntry(LoginToken token, Subject subject) {
            this.token = token;
            this.subject = subject;
            this.queuedForRefresh = false;
        }

        private LoginToken getToken() {
            return this.token;
        }

        private Subject getSubject() {
            return this.subject;
        }

        private void setSubject(Subject subject) {
            this.subject = subject;
        }

        private void setQueuedForRefresh() {
            this.queuedForRefresh = true;
        }

        private boolean isQueuedForRefresh() {
            return this.queuedForRefresh;
        }
    }
}

