/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.security.auth.Subject;

public class LoginSession {
    private final Id id;
    private volatile Subject subject;
    private final String clientHost;
    private final boolean isPersistentSession;
    private volatile long expireTime;

    public LoginSession(Id id, Subject subject, String clientHost, boolean persistent) {
        if (id == null) {
            throw new IllegalArgumentException("id may mnot be null");
        }
        this.id = id;
        this.subject = subject;
        this.clientHost = clientHost;
        this.expireTime = 0L;
        this.isPersistentSession = persistent;
    }

    public Id getId() {
        return this.id;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public boolean isExpired() {
        return this.expireTime != 0L && System.currentTimeMillis() > this.expireTime;
    }

    public boolean isPersistent() {
        return this.isPersistentSession;
    }

    public LoginSession clone() {
        LoginSession session = new LoginSession(this.getId(), this.getSubject(), this.getClientHost(), this.isPersistentSession);
        session.setExpireTime(this.getExpireTime());
        return session;
    }

    public static final class Id {
        private final byte[] idValue;

        public Id(byte[] value) {
            this.idValue = value;
        }

        public int hashCode() {
            return Arrays.hashCode(this.idValue);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            Id otherId = (Id)other;
            return Arrays.equals(this.idValue, otherId.idValue);
        }

        public byte[] getValue() {
            return Arrays.copyOf(this.idValue, this.idValue.length);
        }

        public boolean beginsWith(byte[] prefix) {
            if (this.idValue.length < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (this.idValue[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }

        public static int hashId(byte[] idValue) {
            String hashAlgo = "SHA-256";
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(idValue, 0, idValue.length);
                byte[] mdbytes = md.digest();
                return mdbytes[0] & 0xFF | (mdbytes[1] & 0xFF) << 8 | (mdbytes[2] & 0xFF) << 16 | (mdbytes[3] & 0x7F) << 24;
            }
            catch (NoSuchAlgorithmException nsae) {
                return -1;
            }
        }

        public int hashId() {
            return Id.hashId(this.idValue);
        }
    }
}

