/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.security.auth.DestroyFailedException;
import oracle.kv.FaultException;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.security.SignatureFaultException;
import oracle.kv.impl.security.SignatureHelper;
import oracle.kv.impl.security.ssl.KeyStorePasswordSource;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.topo.Topology;

public class TopoSignatureHelper
implements SignatureHelper<Topology> {
    private static final String SIG_PRIVATE_KEY_ALIAS_DEFAULT = "shared";
    private static final String SIG_PUBLIC_KEY_ALIAS_DEFAULT = "mykey";
    private static final String SIG_ALGORITHM_DEFAULT = "SHA256withRSA";
    private final KeyStore keyStore;
    private final KeyStore certStore;
    private final String privKeyAlias;
    private final String certAlias;
    private final KeyStorePasswordSource ksPwdSource;
    private final Signature signature;
    private PublicKey publicKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TopoSignatureHelper buildFromSecurityParams(SecurityParams sp) {
        KeyStorePasswordSource pwdSrc;
        String certAlias;
        if (sp == null) {
            throw new IllegalArgumentException("Security params must not be null");
        }
        String keyAlias = sp.getKeystoreSigPrivateKeyAlias();
        if (keyAlias == null) {
            keyAlias = SIG_PRIVATE_KEY_ALIAS_DEFAULT;
        }
        if ((certAlias = sp.getTruststoreSigPublicKeyAlias()) == null) {
            certAlias = SIG_PUBLIC_KEY_ALIAS_DEFAULT;
        }
        if ((pwdSrc = KeyStorePasswordSource.create(sp)) == null) {
            throw new IllegalArgumentException("Unable to create keystore password source");
        }
        String keyStoreName = sp.getConfigDir() + File.separator + sp.getKeystoreFile();
        String certStoreName = sp.getConfigDir() + File.separator + sp.getTruststoreFile();
        char[] ksPwd = null;
        try {
            ksPwd = pwdSrc.getPassword();
            KeyStore keyStore = TopoSignatureHelper.loadStore(keyStoreName, ksPwd, "keystore", sp.getKeystoreType());
            KeyStore certStore = TopoSignatureHelper.loadStore(certStoreName, ksPwd, "truststore", sp.getTruststoreType());
            String sigAlgorithm = sp.getSignatureAlgorithm();
            if (sigAlgorithm == null || sigAlgorithm.isEmpty()) {
                sigAlgorithm = SIG_ALGORITHM_DEFAULT;
            }
            TopoSignatureHelper topoSignatureHelper = new TopoSignatureHelper(sigAlgorithm, keyStore, keyAlias, certStore, certAlias, pwdSrc);
            return topoSignatureHelper;
        }
        finally {
            SecurityUtils.clearPassword(ksPwd);
        }
    }

    private static KeyStore loadStore(String storeName, char[] storePassword, String storeFlavor, String storeType) throws IllegalArgumentException {
        FileInputStream fis;
        KeyStore ks;
        if (storeType == null || storeType.isEmpty()) {
            storeType = KeyStore.getDefaultType();
        }
        try {
            ks = KeyStore.getInstance(storeType);
        }
        catch (KeyStoreException kse) {
            throw new IllegalArgumentException("Unable to find a " + storeFlavor + " instance of type " + storeType, kse);
        }
        try {
            fis = new FileInputStream(storeName);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalArgumentException("Unable to locate specified " + storeFlavor + " " + storeName, fnfe);
        }
        try {
            ks.load(fis, storePassword);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error reading from " + storeFlavor + " file " + storeName, ioe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException("Unable to check " + storeFlavor + " integrity: " + storeName, nsae);
        }
        catch (CertificateException ce) {
            throw new IllegalArgumentException("Not all certificates could be loaded: " + storeName, ce);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {}
        }
        return ks;
    }

    private TopoSignatureHelper(String sigAlgorithm, KeyStore keyStore, String privKeyAlias, KeyStore certStore, String certAlias, KeyStorePasswordSource ksPwdSource) {
        try {
            this.signature = Signature.getInstance(sigAlgorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException("Unrecognized signature algorithm: " + sigAlgorithm);
        }
        this.keyStore = keyStore;
        this.privKeyAlias = privKeyAlias;
        this.certStore = certStore;
        this.certAlias = certAlias;
        this.ksPwdSource = ksPwdSource;
    }

    @Override
    public byte[] sign(Topology topo) throws SignatureFaultException {
        byte[] topoSerialBytes;
        try {
            topoSerialBytes = topo.toByteArrayForSignature();
        }
        catch (IOException ioe) {
            throw new SignatureFaultException("Failed to get topology bytes", ioe);
        }
        Signature signature = this.signature;
        synchronized (signature) {
            try {
                this.signature.initSign(this.getPrivateKey());
                this.signature.update(topoSerialBytes);
                return this.signature.sign();
            }
            catch (InvalidKeyException ike) {
                throw new SignatureFaultException("Private key used to generate signature is invalid", ike);
            }
            catch (KeyAccessException kae) {
                throw new SignatureFaultException("Failed to access private key", kae);
            }
            catch (SignatureException se) {
                throw new SignatureFaultException("Problem while attempting to sign topology", se);
            }
        }
    }

    @Override
    public boolean verify(Topology topo, byte[] sigBytes) throws SignatureFaultException {
        byte[] topoSerialBytes;
        try {
            topoSerialBytes = topo.toByteArrayForSignature();
        }
        catch (IOException ioe) {
            throw new SignatureFaultException("Failed to get topology bytes", ioe);
        }
        Signature signature = this.signature;
        synchronized (signature) {
            try {
                this.signature.initVerify(this.getPublicKey());
                this.signature.update(topoSerialBytes);
                return this.signature.verify(sigBytes);
            }
            catch (InvalidKeyException ike) {
                throw new SignatureFaultException("Public key used to verify signature is invalid", ike);
            }
            catch (KeyAccessException kae) {
                throw new SignatureFaultException("Failed to access public key", kae);
            }
            catch (SignatureException se) {
                throw new SignatureFaultException("Problem while attempting to verify topology", se);
            }
        }
    }

    private PrivateKey getPrivateKey() throws KeyAccessException {
        char[] ksPassword = null;
        KeyStore.PasswordProtection pwdParam = null;
        try {
            ksPassword = this.ksPwdSource.getPassword();
            pwdParam = new KeyStore.PasswordProtection(ksPassword);
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.privKeyAlias, pwdParam);
            if (pkEntry == null) {
                throw new KeyAccessException("Could not find private key entry with alias of " + this.privKeyAlias);
            }
            PrivateKey privateKey = pkEntry.getPrivateKey();
            return privateKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyAccessException("Unable to recover private key entry from keystore", nsae);
        }
        catch (UnrecoverableEntryException uee) {
            throw new KeyAccessException("Password parameter is invalid or insufficent to recover private key entry from keystore", uee);
        }
        catch (KeyStoreException kse) {
            throw new KeyAccessException("Keystore is not loaded or initialized", kse);
        }
        finally {
            SecurityUtils.clearPassword(ksPassword);
            if (pwdParam != null) {
                try {
                    pwdParam.destroy();
                }
                catch (DestroyFailedException e) {}
            }
        }
    }

    private PublicKey getPublicKey() throws KeyAccessException {
        if (this.publicKey == null) {
            try {
                Certificate cert = this.certStore.getCertificate(this.certAlias);
                if (cert == null) {
                    throw new KeyAccessException("Could not find certificate with alias of " + this.certAlias + " or other");
                }
                this.publicKey = cert.getPublicKey();
            }
            catch (KeyStoreException kse) {
                throw new KeyAccessException("Certificate store is not loaded or initialized", kse);
            }
        }
        return this.publicKey;
    }

    private static class KeyAccessException
    extends FaultException {
        private static final long serialVersionUID = 1L;

        public KeyAccessException(String msg, Throwable cause) {
            super(msg, cause, false);
        }

        public KeyAccessException(String msg) {
            super(msg, false);
        }
    }
}

