/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.Serializable;
import oracle.kv.impl.util.ObjectUtil;

public class ResourceOwner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;

    public ResourceOwner(String id, String name) {
        ObjectUtil.checkNull("id", id);
        ObjectUtil.checkNull("name", name);
        this.id = id;
        this.name = name;
    }

    public ResourceOwner(ResourceOwner other) {
        ObjectUtil.checkNull("Other owner", other);
        this.id = other.id;
        this.name = other.name;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return String.format("%s(id:%s)", this.name, this.id);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceOwner)) {
            return false;
        }
        ResourceOwner otherOwner = (ResourceOwner)other;
        return this.id.equals(otherOwner.id) && this.name.equals(otherOwner.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 527 + this.id.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }
}

