/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class PasswordHash {
    public static final String SUGG_ALGO = "PBKDF2WithHmacSHA1";
    public static final int SUGG_SALT_BYTES = 16;
    public static final int SUGG_HASH_ITERS = 5000;

    private PasswordHash() {
    }

    public static byte[] pbeHash(char[] password, String algorithm, byte[] salt, int iters, int bytes) throws NoSuchAlgorithmException, InvalidKeySpecException, IllegalArgumentException {
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("The password must be non-null and not empty");
        }
        if (salt == null || salt.length == 0) {
            throw new IllegalArgumentException("The salt must be non-null and not empty");
        }
        if (iters <= 0) {
            throw new IllegalArgumentException("The number of iterations must be > 0");
        }
        if (bytes <= 0) {
            throw new IllegalArgumentException("The number of result bytes must be > 0");
        }
        PBEKeySpec spec = new PBEKeySpec(password, salt, iters, bytes * 8);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
        return skf.generateSecret(spec).getEncoded();
    }

    public static byte[] generateSalt(SecureRandom random, int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException("The number of result bytes must be > 0");
        }
        byte[] salt = new byte[nBytes];
        random.nextBytes(salt);
        return salt;
    }
}

