/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.RoleInstance;

public final class KVStoreRolePrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private final KVStoreRole role;
    private String roleName;
    public static final KVStoreRolePrincipal PUBLIC = new KVStoreRolePrincipal("public");
    public static final KVStoreRolePrincipal DBADMIN = new KVStoreRolePrincipal("dbadmin");
    public static final KVStoreRolePrincipal SYSADMIN = new KVStoreRolePrincipal("sysadmin");
    public static final KVStoreRolePrincipal READONLY = new KVStoreRolePrincipal("readonly");
    public static final KVStoreRolePrincipal WRITEONLY = new KVStoreRolePrincipal("writeonly");
    public static final KVStoreRolePrincipal READWRITE = new KVStoreRolePrincipal("readwrite");
    public static final KVStoreRolePrincipal INTERNAL = new KVStoreRolePrincipal(KVStoreRole.INTERNAL);
    public static final KVStoreRolePrincipal ADMIN = new KVStoreRolePrincipal(KVStoreRole.ADMIN);
    public static final KVStoreRolePrincipal AUTHENTICATED = new KVStoreRolePrincipal(KVStoreRole.AUTHENTICATED);
    private static final Map<String, KVStoreRolePrincipal> roleMap = new HashMap<String, KVStoreRolePrincipal>();

    public static KVStoreRolePrincipal get(String roleName) {
        KVStoreRolePrincipal rolePrinc = roleMap.get(RoleInstance.getNormalizedName(roleName));
        return rolePrinc == null ? new KVStoreRolePrincipal(roleName) : rolePrinc;
    }

    public static String[] getSubjectRoleNames(Subject subj) {
        return ExecutionContext.getSubjectRoles(subj);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.roleName.equals(((KVStoreRolePrincipal)other).roleName);
    }

    @Override
    public String getName() {
        return this.roleName;
    }

    @Override
    public int hashCode() {
        return this.roleName.hashCode();
    }

    @Override
    public String toString() {
        return "KVStoreRolePrincipal(" + this.roleName + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.role != null) {
            if (this.roleName == null) {
                this.roleName = this.role.toString();
            } else if (!this.role.toString().equalsIgnoreCase(this.roleName)) {
                throw new IOException(String.format("Role %s and role name %s are mismatched", new Object[]{this.role, this.roleName}));
            }
        } else if (this.roleName == null) {
            throw new IOException("Unexpected error when read KVStoreRolePrinciple object,role and roleName are both null");
        }
    }

    private KVStoreRolePrincipal(KVStoreRole role) {
        this.role = role;
        this.roleName = RoleInstance.getNormalizedName(role.toString());
    }

    private KVStoreRolePrincipal(String roleName) {
        if (roleName == null) {
            throw new IllegalArgumentException("Role name should not be null");
        }
        this.role = null;
        this.roleName = RoleInstance.getNormalizedName(roleName);
    }

    static {
        roleMap.put(INTERNAL.getName(), INTERNAL);
        roleMap.put(PUBLIC.getName(), PUBLIC);
        roleMap.put(DBADMIN.getName(), DBADMIN);
        roleMap.put(SYSADMIN.getName(), SYSADMIN);
        roleMap.put(READONLY.getName(), READONLY);
        roleMap.put(WRITEONLY.getName(), WRITEONLY);
        roleMap.put(READWRITE.getName(), READWRITE);
        roleMap.put(ADMIN.getName(), ADMIN);
        roleMap.put(AUTHENTICATED.getName(), AUTHENTICATED);
    }
}

