/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.RoleResolver;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.TokenVerifier;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.util.BloomFilter;
import oracle.kv.impl.security.util.Cache;
import oracle.kv.impl.security.util.CacheBuilder;

public class AccessCheckerImpl
implements AccessChecker {
    private final TokenVerifier verifier;
    private final RoleResolver roleResolver;
    private volatile Logger logger;
    private final Cache<String, PrivilegeEntry> userPrivCache;

    public AccessCheckerImpl(TokenVerifier verifier, RoleResolver resolver, CacheBuilder.CacheConfig config, Logger logger) {
        this.verifier = verifier;
        this.roleResolver = resolver;
        this.logger = logger;
        this.userPrivCache = config != null ? CacheBuilder.build(config) : null;
    }

    public void logError(String msg, ExecutionContext execCtx, OperationContext opCtx) {
        AccessCheckUtils.logSecurityError(msg, opCtx.describe(), execCtx, this.logger);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Subject identifyRequestor(AuthContext context) throws SessionAccessException {
        if (context == null) {
            return null;
        }
        LoginToken token = context.getLoginToken();
        if (token == null) {
            return null;
        }
        try {
            return this.verifier.verifyToken(token);
        }
        catch (SessionAccessException sae) {
            throw new SessionAccessException(sae, false);
        }
    }

    @Override
    public void checkAccess(ExecutionContext execCtx, OperationContext opCtx) throws AuthenticationRequiredException, UnauthorizedException {
        List<? extends KVStorePrivilege> requiredPrivileges = opCtx.getRequiredPrivileges();
        if (requiredPrivileges.size() == 0) {
            return;
        }
        Subject subject = execCtx.requestorSubject();
        if (subject == null) {
            AuthContext secCtx = execCtx.requestorContext();
            if (secCtx == null || secCtx.getLoginToken() == null) {
                this.logError("Attempt to call method without authentication", execCtx, opCtx);
                throw new AuthenticationRequiredException("Authentication required for access", false);
            }
            this.logError("Attempt to call method with invalid authentication", execCtx, opCtx);
            throw new AuthenticationRequiredException("Authentication required for access", false);
        }
        if (!execCtx.hasAllPrivileges(requiredPrivileges)) {
            this.logError("Insufficient access rights", execCtx, opCtx);
            throw new UnauthorizedException("Insufficient access rights granted");
        }
    }

    @Override
    public Set<KVStorePrivilege> identifyPrivileges(Subject reqSubj) {
        PrivilegeEntry privEntry;
        if (reqSubj == null) {
            return null;
        }
        KVStoreUserPrincipal user = ExecutionContext.getSubjectUserPrincipal(reqSubj);
        if (this.userPrivCache != null && user != null && (privEntry = this.userPrivCache.get(user.getUserId())) != null) {
            return privEntry.getPrivileges();
        }
        HashSet<KVStorePrivilege> subjPrivSet = new HashSet<KVStorePrivilege>();
        HashSet<String> subjRoleSet = new HashSet<String>();
        Set<KVStoreRolePrincipal> reqRoles = reqSubj.getPrincipals(KVStoreRolePrincipal.class);
        for (KVStoreRolePrincipal princ : reqRoles) {
            String roleName = princ.getName();
            this.recursiveGetRolesAndPrivis(roleName, subjRoleSet, subjPrivSet);
        }
        if (this.userPrivCache != null && user != null) {
            this.userPrivCache.put(user.getUserId(), new PrivilegeEntry(user.getUserId(), subjPrivSet, subjRoleSet));
        }
        return subjPrivSet;
    }

    private void recursiveGetRolesAndPrivis(String roleName, Set<String> roleSet, Set<KVStorePrivilege> priviSet) {
        RoleInstance role = this.roleResolver.resolve(roleName);
        if (role == null) {
            this.logger.info("Could not resolve role with name of " + roleName);
        } else {
            this.logger.fine("Role " + roleName + " resolved successfully.");
            priviSet.addAll(role.getPrivileges());
            roleSet.add(roleName);
            for (String grantedRole : role.getGrantedRoles()) {
                this.recursiveGetRolesAndPrivis(grantedRole, roleSet, priviSet);
            }
        }
    }

    public boolean updateRoleDefinition(RoleInstance role) {
        boolean removed = false;
        Set<PrivilegeEntry> allPrivEntries = this.userPrivCache.getAllValues();
        for (PrivilegeEntry privEntry : allPrivEntries) {
            if (!privEntry.hasRole(role.name())) continue;
            PrivilegeEntry entry = this.userPrivCache.invalidate(privEntry.getPrincId());
            if (removed) continue;
            removed = entry != null;
        }
        return removed;
    }

    public boolean updateUserDefinition(KVStoreUser user) {
        return this.userPrivCache.invalidate(user.getElementId()) != null;
    }

    public static class PrivilegeEntry
    extends CacheBuilder.CacheEntry {
        private final Set<KVStorePrivilege> privsSet;
        private final String princId;
        private final byte[] leafRoleBf;

        public PrivilegeEntry(String princId, Set<KVStorePrivilege> privsSet, Set<String> leafRoles) {
            this.privsSet = privsSet;
            this.princId = princId;
            if (leafRoles == null || leafRoles.isEmpty()) {
                this.leafRoleBf = null;
            } else {
                int bfSize = BloomFilter.getByteSize(leafRoles.size());
                this.leafRoleBf = new byte[bfSize];
                BloomFilter.HashContext hc = new BloomFilter.HashContext();
                for (String role : leafRoles) {
                    BloomFilter.add(this.leafRoleBf, RoleInstance.getNormalizedName(role).getBytes(), hc);
                }
            }
        }

        String getPrincId() {
            return this.princId;
        }

        public Set<KVStorePrivilege> getPrivileges() {
            return Collections.unmodifiableSet(this.privsSet);
        }

        public boolean hasRole(String name) {
            if (this.leafRoleBf == null) {
                return false;
            }
            return BloomFilter.contains(this.leafRoleBf, RoleInstance.getNormalizedName(name).getBytes());
        }
    }
}

