/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.table;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.Key;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.fault.DatabaseNotReadyException;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.rep.MetadataManager;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.StateTracker;
import oracle.kv.impl.rep.table.IndexKeyCreator;
import oracle.kv.impl.rep.table.MaintenanceThread;
import oracle.kv.impl.rep.table.SecondaryInfoMap;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.DatabaseUtils;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.table.Index;
import oracle.kv.table.Table;

public class TableManager
extends MetadataManager<TableMetadata>
implements SecondaryAssociation {
    private final RepNodeService.Params params;
    private final StateTracker stateTracker;
    private volatile TableMetadata tableMetadata = null;
    private final Map<String, SecondaryDatabase> secondaryDbMap = new HashMap<String, SecondaryDatabase>();
    private UpdateThread updateThread = null;
    private MaintenanceThread maintenanceThread = null;
    private final ReentrantLock threadLock = new ReentrantLock();
    private volatile Map<String, TableEntry> secondaryLookupMap = null;
    private volatile Map<Long, TableImpl> idLookupMap = null;
    private volatile Map<String, Long> r2NameIdLookupMap = null;

    static String createDbName(String indexName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(indexName);
        sb.append(".");
        sb.append(tableName);
        return sb.toString();
    }

    static String getTableName(String dbName) {
        return dbName.split("\\.", 2)[1];
    }

    public TableManager(RepNode repNode, RepNodeService.Params params) {
        super(repNode, params);
        this.params = params;
        this.logger.log(Level.INFO, "Table manager created");
        this.stateTracker = new TableManagerStateTracker(this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.stateTracker.shutdown();
        this.threadLock.lock();
        try {
            this.stopUpdateThread();
            this.stopMaintenanceThread();
        }
        finally {
            this.threadLock.unlock();
        }
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetadata getTableMetadata() {
        if (this.tableMetadata == null) {
            TableManager tableManager = this;
            synchronized (tableManager) {
                if (this.tableMetadata == null) {
                    try {
                        this.tableMetadata = (TableMetadata)this.fetchMetadata();
                    }
                    catch (DatabaseNotReadyException dnre) {
                        return null;
                    }
                    if (this.tableMetadata == null) {
                        this.tableMetadata = new TableMetadata(true);
                    }
                }
            }
        }
        return this.tableMetadata;
    }

    public boolean addIndexComplete(String indexName, String tableName) {
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null) {
            return false;
        }
        SecondaryInfoMap secondaryInfoMap = this.getSecondaryInfoMap(repEnv);
        if (secondaryInfoMap == null) {
            return false;
        }
        String dbName = TableManager.createDbName(indexName, tableName);
        SecondaryInfoMap.SecondaryInfo info = secondaryInfoMap.getSecondaryInfo(dbName);
        this.logger.log(Level.FINE, "addIndexComplete({0}) returning {1}", new Object[]{dbName, info});
        return info == null ? false : !info.needsPopulating();
    }

    public boolean removeTableDataComplete(String tableName) {
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null) {
            return false;
        }
        SecondaryInfoMap secondaryInfoMap = this.getSecondaryInfoMap(repEnv);
        SecondaryInfoMap.DeletedTableInfo info = secondaryInfoMap.getDeletedTableInfo(tableName);
        if (info != null) {
            return info.isDone();
        }
        TableMetadata md = this.getTableMetadata();
        return md == null ? false : md.getTable(tableName) == null;
    }

    public TableImpl getTable(long tableId) {
        Map<Long, TableImpl> map = this.idLookupMap;
        if (map == null) {
            throw new RNUnavailableException("Table metadata is not yet initialized");
        }
        return map.get(tableId);
    }

    TableImpl getTable(String tableName) {
        TableMetadata md = this.getTableMetadata();
        return md == null ? null : md.getTable(tableName);
    }

    public TableImpl getR2CompatTable(String tableName) {
        Map<String, Long> map = this.r2NameIdLookupMap;
        if (map == null) {
            throw new RNUnavailableException("Table metadata is not yet initialized");
        }
        Long tableId = map.get(tableName);
        return tableId == null ? null : this.getTable(tableId);
    }

    RepNodeService.Params getParams() {
        return this.params;
    }

    private SecondaryInfoMap getSecondaryInfoMap(ReplicatedEnvironment repEnv) {
        try {
            return SecondaryInfoMap.fetch(repEnv);
        }
        catch (RuntimeException re) {
            DatabaseUtils.handleException(re, this.logger, "index populate info");
            return null;
        }
    }

    SecondaryDatabase getSecondaryDb(String dbName) {
        return this.secondaryDbMap.get(dbName);
    }

    public SecondaryDatabase getIndexDB(String indexName, String tableName) {
        return this.getSecondaryDb(TableManager.createDbName(indexName, tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeDbHandles() {
        this.logger.log(Level.INFO, "Closing secondary database handles");
        this.threadLock.lock();
        try {
            this.stopUpdateThread();
            this.stopMaintenanceThread();
            Iterator<SecondaryDatabase> itr = this.secondaryDbMap.values().iterator();
            while (itr.hasNext()) {
                SecondaryDatabase db = itr.next();
                if (db == null) continue;
                if (!this.closeSecondaryDb(db)) {
                    return;
                }
                itr.remove();
            }
        }
        finally {
            this.threadLock.unlock();
            super.closeDbHandles();
        }
    }

    private boolean closeSecondaryDb(SecondaryDatabase db) {
        Environment env = db.getEnvironment();
        if (env == null || !env.isValid()) {
            return false;
        }
        TxnUtil.close(this.logger, (Database)db, "secondary");
        return true;
    }

    public boolean isEmpty() {
        Map<String, TableEntry> map = this.secondaryLookupMap;
        if (map == null) {
            throw new RNUnavailableException("Table metadata is not yet initialized");
        }
        return map.isEmpty();
    }

    public Database getPrimary(DatabaseEntry primaryKey) {
        return this.repNode.getPartitionDB(primaryKey.getData());
    }

    public Collection<SecondaryDatabase> getSecondaries(DatabaseEntry primaryKey) {
        Map<String, TableEntry> map = this.secondaryLookupMap;
        if (map == null) {
            throw new RNUnavailableException("Table metadata is not yet initialized");
        }
        Key.BinaryKeyIterator keyIter = new Key.BinaryKeyIterator(primaryKey.getData());
        String rootId = keyIter.next();
        TableEntry entry = map.get(rootId);
        if (entry == null) {
            return Collections.EMPTY_SET;
        }
        Collection matchedIndexes = entry.matchIndexes(keyIter);
        if (matchedIndexes == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<SecondaryDatabase> secondaries = new ArrayList<SecondaryDatabase>(matchedIndexes.size());
        for (String dbName : matchedIndexes) {
            SecondaryDatabase db = this.secondaryDbMap.get(dbName);
            if (db == null) {
                throw new RNUnavailableException("Secondary db not yet opened " + dbName);
            }
            secondaries.add(db);
        }
        return secondaries;
    }

    public synchronized boolean updateMetadata(Metadata<?> newMetadata) {
        if (!(newMetadata instanceof TableMetadata)) {
            throw new IllegalStateException("Bad metadata?" + newMetadata);
        }
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null || !repEnv.getState().isMaster()) {
            return false;
        }
        TableMetadata md = this.getTableMetadata();
        if (md == null) {
            return false;
        }
        if (md.getSequenceNumber() >= newMetadata.getSequenceNumber()) {
            return true;
        }
        this.logger.log(Level.INFO, "Updating table metadata with {0}", newMetadata);
        return this.update((TableMetadata)newMetadata, repEnv);
    }

    public synchronized int updateMetadata(MetadataInfo metadataInfo) {
        TableMetadata md;
        block7: {
            ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
            if (repEnv == null) {
                return 0;
            }
            md = this.getTableMetadata();
            if (md == null) {
                return 0;
            }
            if (repEnv.getState().isMaster()) {
                TableMetadata newMetadata = md.getCopy();
                try {
                    if (!newMetadata.update(metadataInfo)) break block7;
                    this.logger.log(Level.INFO, "Updating table metadata with {0}", metadataInfo);
                    if (this.update(newMetadata, repEnv)) {
                        return newMetadata.getSequenceNumber();
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Error updating table metadata with " + metadataInfo, e);
                }
            } else {
                this.logger.log(Level.INFO, "Metadata update attempted at replica");
            }
        }
        this.logger.log(Level.INFO, "Metadata update failed, current seq number " + md.getSequenceNumber());
        return md.getSequenceNumber();
    }

    private boolean update(TableMetadata newMetadata, ReplicatedEnvironment repEnv) {
        assert (Thread.holdsLock(this));
        assert (repEnv != null);
        if (repEnv.getState().isMaster() && !this.persistMetadata(newMetadata)) {
            return true;
        }
        this.tableMetadata = newMetadata;
        this.updateDbHandles(repEnv, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateDbHandles(ReplicatedEnvironment repEnv, boolean reuseExistingHandles) {
        super.updateDbHandles(repEnv, reuseExistingHandles);
        TableMetadata tableMd = this.getTableMetadata();
        boolean succeeded = this.updateTableMaps(tableMd, repEnv);
        this.threadLock.lock();
        try {
            this.stopUpdateThread();
            if (!(reuseExistingHandles && succeeded && repEnv.getState().isMaster())) {
                this.stopMaintenanceThread();
            }
            if (!succeeded) {
                return;
            }
            this.updateThread = new UpdateThread(tableMd, repEnv, reuseExistingHandles);
            this.updateThread.start();
        }
        finally {
            this.threadLock.unlock();
        }
    }

    private synchronized boolean updateTableMaps(TableMetadata tableMd, ReplicatedEnvironment repEnv) {
        assert (repEnv != null);
        if (!repEnv.isValid() || tableMd == null) {
            this.secondaryLookupMap = null;
            this.idLookupMap = null;
            this.r2NameIdLookupMap = null;
            return false;
        }
        if (tableMd.isEmpty()) {
            this.secondaryLookupMap = Collections.emptyMap();
            this.idLookupMap = Collections.emptyMap();
            this.r2NameIdLookupMap = Collections.emptyMap();
            return true;
        }
        HashMap<String, TableEntry> slm = new HashMap<String, TableEntry>();
        HashMap<Long, TableImpl> ilm = new HashMap<Long, TableImpl>();
        HashMap<String, Long> r2nilm = new HashMap<String, Long>();
        for (Table table : tableMd.getTables().values()) {
            TableImpl tableImpl = (TableImpl)table;
            TableEntry entry = new TableEntry(tableImpl);
            if (entry.hasSecondaries()) {
                slm.put(tableImpl.getIdString(), entry);
            }
            this.addToMap(tableImpl, ilm, r2nilm);
        }
        this.secondaryLookupMap = slm;
        this.idLookupMap = ilm;
        this.r2NameIdLookupMap = r2nilm;
        return true;
    }

    private void addToMap(TableImpl tableImpl, Map<Long, TableImpl> map, Map<String, Long> r2Map) {
        map.put(tableImpl.getId(), tableImpl);
        if (tableImpl.isR2compatible()) {
            r2Map.put(tableImpl.getFullName(), tableImpl.getId());
        }
        for (Table child : tableImpl.getChildTables().values()) {
            this.addToMap((TableImpl)child, map, r2Map);
        }
    }

    public void startTracker() {
        this.stateTracker.start();
    }

    public void noteStateChange(StateChangeEvent stateChangeEvent) {
        this.stateTracker.noteStateChange(stateChangeEvent);
    }

    @Override
    protected Metadata.MetadataType getType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    protected synchronized void update(ReplicatedEnvironment repEnv) {
        this.tableMetadata = null;
        this.updateDbHandles(repEnv, true);
    }

    private void stopUpdateThread() {
        assert (this.threadLock.isHeldByCurrentThread());
        if (this.updateThread != null) {
            this.updateThread.waitForStop();
            this.updateThread = null;
        }
    }

    private void stopMaintenanceThread() {
        assert (this.threadLock.isHeldByCurrentThread());
        if (this.maintenanceThread != null) {
            this.maintenanceThread.waitForStop();
            this.maintenanceThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkMaintenanceThreads(ReplicatedEnvironment repEnv, Database infoDb) {
        assert (infoDb != null);
        if (!repEnv.getState().isMaster()) {
            return true;
        }
        this.logger.fine("Checking maintenance threads");
        if (!this.threadLock.tryLock()) {
            this.logger.fine("Failed to acquire maintenance thread lock");
            return false;
        }
        try {
            this.stopMaintenanceThread();
            SecondaryInfoMap secondaryInfoMap = SecondaryInfoMap.fetch(infoDb);
            if (secondaryInfoMap == null) {
                boolean bl = false;
                return bl;
            }
            if (secondaryInfoMap.secondaryNeedsPopulate()) {
                this.maintenanceThread = new MaintenanceThread.PopulateThread(this, this.repNode, repEnv, this.logger);
                this.maintenanceThread.start();
                boolean bl = true;
                return bl;
            }
            if (secondaryInfoMap.tableNeedDeleting()) {
                this.maintenanceThread = new MaintenanceThread.PrimaryCleanerThread(this, this.repNode, repEnv, this.logger);
                this.maintenanceThread.start();
                boolean bl = true;
                return bl;
            }
            if (secondaryInfoMap.secondaryNeedsCleaning()) {
                this.maintenanceThread = new MaintenanceThread.SecondaryCleanerThread(this, this.repNode, repEnv, this.logger);
                this.maintenanceThread.start();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.threadLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusyMaintenance() {
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null || !repEnv.getState().isMaster()) {
            return true;
        }
        Database infoDb = null;
        try {
            infoDb = SecondaryInfoMap.openDb(repEnv);
            SecondaryInfoMap secondaryInfoMap = SecondaryInfoMap.fetch(infoDb);
            if (secondaryInfoMap == null) {
                boolean bl = false;
                return bl;
            }
            if (secondaryInfoMap.secondaryNeedsPopulate() || secondaryInfoMap.tableNeedDeleting() || secondaryInfoMap.secondaryNeedsCleaning()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException re) {
            this.logger.log(Level.WARNING, "Unexpected exception", re);
        }
        finally {
            if (infoDb != null) {
                TxnUtil.close(this.logger, infoDb, "secondary info db");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maintenanceThreadExit(ReplicatedEnvironment repEnv, Database infoDb) {
        assert (this.maintenanceThread != null);
        if (!this.threadLock.tryLock()) {
            return;
        }
        try {
            if (!this.maintenanceThread.isStopped()) {
                return;
            }
            this.maintenanceThread = null;
            this.checkMaintenanceThreads(repEnv, infoDb);
        }
        finally {
            this.threadLock.unlock();
        }
    }

    public void notifyRemoval(PartitionId partitionId) {
        if (this.secondaryDbMap.isEmpty()) {
            return;
        }
        this.logger.log(Level.INFO, "{0} has been removed, removing obsolete records from secondaries", partitionId);
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null) {
            return;
        }
        SecondaryInfoMap.markForSecondaryCleaning(this, repEnv, this.logger);
    }

    public String toString() {
        return "TableManager[" + (this.tableMetadata == null ? "-" : Integer.valueOf(this.tableMetadata.getSequenceNumber())) + ", " + this.secondaryDbMap.size() + "]";
    }

    private class UpdateThread
    extends Thread {
        private final TableMetadata tableMd;
        private final ReplicatedEnvironment repEnv;
        private final boolean reuseExistingHandles;
        private Database infoDb;
        private volatile boolean stop;

        UpdateThread(TableMetadata tableMd, ReplicatedEnvironment repEnv, boolean reuseExistingHandles) {
            super("KV secondary handle updater");
            this.infoDb = null;
            this.stop = false;
            assert (repEnv != null);
            assert (tableMd != null);
            this.tableMd = tableMd;
            this.repEnv = repEnv;
            this.reuseExistingHandles = reuseExistingHandles;
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(TableManager.this.repNode.getExceptionHandler());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            TableManager.this.logger.log(Level.FINE, "Starting {0}", this);
            try {
                while (this.update()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        throw new IllegalStateException(ie);
                    }
                }
                if (this.infoDb == null) {
                    return;
                }
                while (!this.isStopped() && this.repEnv.getState().isMaster()) {
                    if (TableManager.this.checkMaintenanceThreads(this.repEnv, this.infoDb)) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        throw new IllegalStateException(ie);
                        return;
                    }
                }
            }
            catch (RuntimeException re) {
                if (!this.isStopped()) throw re;
                TableManager.this.logger.log(Level.INFO, "Table update thread exiting after, {0}", re);
                return;
            }
            finally {
                if (this.infoDb != null) {
                    TxnUtil.close(TableManager.this.logger, this.infoDb, "secondary info db");
                }
            }
        }

        private boolean update() {
            if (this.isStopped()) {
                return false;
            }
            TableManager.this.logger.log(Level.FINE, "Establishing secondary database handles, table seq#: {0}", this.tableMd.getSequenceNumber());
            if (this.infoDb == null) {
                try {
                    this.infoDb = SecondaryInfoMap.openDb(this.repEnv);
                }
                catch (Exception e) {
                    TableManager.this.logger.log(Level.INFO, "Failed to open info map DB", e);
                    return !this.isStopped();
                }
            }
            assert (this.infoDb != null);
            HashMap<String, IndexImpl> indexes = new HashMap<String, IndexImpl>();
            HashSet<TableImpl> deletedTables = new HashSet<TableImpl>();
            Map<String, Table> currentTables = this.tableMd.getTables();
            for (Table table : this.tableMd.getTables().values()) {
                this.scanTable((TableImpl)table, indexes, deletedTables);
            }
            TableManager.this.logger.log(Level.INFO, "Found {0} indexes and {1} tables marked for deletion in {2}", new Object[]{indexes.size(), deletedTables.size(), this.tableMd});
            if (this.repEnv.getState().isMaster()) {
                SecondaryInfoMap.check(currentTables, indexes, deletedTables, this.infoDb, TableManager.this.logger);
            }
            int errors = 0;
            Iterator itr = TableManager.this.secondaryDbMap.entrySet().iterator();
            while (itr.hasNext()) {
                block21: {
                    if (this.isStopped()) {
                        return false;
                    }
                    Map.Entry entry = itr.next();
                    String dbName = (String)entry.getKey();
                    if (indexes.containsKey(dbName)) continue;
                    SecondaryDatabase db = (SecondaryDatabase)entry.getValue();
                    if (db != null) {
                        try {
                            TableManager.this.closeSecondaryDb(db);
                            if (!this.repEnv.getState().isMaster()) break block21;
                            TableManager.this.logger.log(Level.INFO, "Secondary database {0} is not defined in table metadata seq# {1} and is being removed.", new Object[]{dbName, this.tableMd.getSequenceNumber()});
                            this.repEnv.removeDatabase(null, dbName);
                        }
                        catch (DatabaseNotFoundException ignore) {
                        }
                        catch (RuntimeException re) {
                            DatabaseUtils.handleException(re, TableManager.this.logger, dbName);
                            ++errors;
                            continue;
                        }
                    }
                }
                itr.remove();
            }
            for (Map.Entry entry : indexes.entrySet()) {
                if (this.isStopped()) {
                    TableManager.this.logger.log(Level.INFO, "Update terminated, established {0} secondary database handles", TableManager.this.secondaryDbMap.size());
                    return false;
                }
                String dbName = (String)entry.getKey();
                SecondaryDatabase db = (SecondaryDatabase)TableManager.this.secondaryDbMap.get(dbName);
                try {
                    if (db == null || !this.reuseExistingHandles) {
                        IndexImpl index = (IndexImpl)entry.getValue();
                        db = this.openSecondaryDb(dbName, index);
                        assert (db != null);
                        this.setIncrementalPopulation(dbName, db);
                        TableManager.this.secondaryDbMap.put(dbName, db);
                        continue;
                    }
                    this.setIncrementalPopulation(dbName, db);
                    this.updateIndexKeyCreator(db, (IndexImpl)entry.getValue());
                }
                catch (RuntimeException re) {
                    if (db != null) {
                        TableManager.this.secondaryDbMap.remove(dbName);
                        TxnUtil.close(TableManager.this.logger, (Database)db, "secondary db");
                    }
                    if (!DatabaseUtils.handleException(re, TableManager.this.logger, dbName)) continue;
                    ++errors;
                }
            }
            if (errors > 0) {
                TableManager.this.logger.log(Level.INFO, "Established {0} secondary database handles, will retry in {1}ms", new Object[]{TableManager.this.secondaryDbMap.size(), 1000});
                return !this.isStopped();
            }
            TableManager.this.logger.log(Level.INFO, "Established {0} secondary database handles", TableManager.this.secondaryDbMap.size());
            return false;
        }

        private void updateIndexKeyCreator(SecondaryDatabase db, IndexImpl index) {
            TableManager.this.logger.log(Level.FINE, "Updating index metadata for index {0} in table {1}", new Object[]{index.getName(), index.getTable().getFullName()});
            SecondaryConfig config = db.getConfig();
            IndexKeyCreator keyCreator = (IndexKeyCreator)(index.isMultiKey() ? config.getMultiKeyCreator() : config.getKeyCreator());
            assert (keyCreator != null);
            keyCreator.setIndex(index);
        }

        private void setIncrementalPopulation(String dbName, SecondaryDatabase db) {
            SecondaryInfoMap.SecondaryInfo info = SecondaryInfoMap.fetch(this.infoDb).getSecondaryInfo(dbName);
            if (info == null) {
                throw new IllegalStateException("Secondary info record for " + dbName + " is missing");
            }
            if (info.needsPopulating()) {
                db.startIncrementalPopulation();
            } else {
                db.endIncrementalPopulation();
            }
        }

        private void scanTable(TableImpl table, Map<String, IndexImpl> indexes, Set<TableImpl> deletedTables) {
            if (table.getStatus().isDeleting()) {
                if (!table.getChildTables().isEmpty()) {
                    throw new IllegalStateException("Table " + table + " is deleted but has children");
                }
                if (!table.getIndexes().isEmpty()) {
                    throw new IllegalStateException("Table " + table + " is deleted but has indexes");
                }
                deletedTables.add(table);
                return;
            }
            for (Table child : table.getChildTables().values()) {
                this.scanTable((TableImpl)child, indexes, deletedTables);
            }
            for (Index index : table.getIndexes().values()) {
                indexes.put(TableManager.createDbName(index.getName(), table.getFullName()), (IndexImpl)index);
            }
        }

        private SecondaryDatabase openSecondaryDb(String dbName, IndexImpl index) {
            SecondaryDatabase secondaryDatabase;
            TableManager.this.logger.log(Level.FINE, "Open secondary DB {0}", dbName);
            IndexKeyCreator keyCreator = new IndexKeyCreator(index);
            TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
            SecondaryConfig dbConfig = new SecondaryConfig();
            dbConfig.setExtractFromPrimaryKeyOnly(keyCreator.primaryKeyOnly()).setSecondaryAssociation((SecondaryAssociation)TableManager.this).setTransactional(true).setAllowCreate(true).setDuplicateComparator(Key.BytesComparator.class).setSortedDuplicates(true);
            if (keyCreator.isMultiKey()) {
                dbConfig.setMultiKeyCreator((SecondaryMultiKeyCreator)keyCreator);
            } else {
                dbConfig.setKeyCreator((SecondaryKeyCreator)keyCreator);
            }
            Transaction txn = null;
            try {
                txn = this.repEnv.beginTransaction(null, txnConfig);
                SecondaryDatabase db = this.repEnv.openSecondaryDatabase(txn, dbName, null, dbConfig);
                if (this.repEnv.getState().isMaster()) {
                    SecondaryInfoMap.add(dbName, this.infoDb, txn, TableManager.this.logger);
                }
                txn.commit();
                txn = null;
                secondaryDatabase = db;
            }
            catch (IllegalStateException e) {
                try {
                    if (this.repEnv.isValid()) {
                        EnvironmentFailureException.unexpectedException(DbInternal.getEnvironmentImpl((Environment)this.repEnv), (Exception)e);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
            }
            TxnUtil.abort(txn);
            return secondaryDatabase;
        }

        private boolean isStopped() {
            return this.stop || !this.repEnv.isValid();
        }

        void waitForStop() {
            assert (Thread.currentThread() != this);
            this.stop = true;
            try {
                this.join();
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
    }

    private static class TableEntry {
        private final int keySize;
        private final Set<String> secondaries = new HashSet<String>();
        private final Map<String, TableEntry> children = new HashMap<String, TableEntry>();

        TableEntry(TableImpl table) {
            this.keySize = table.getParent() == null ? table.getPrimaryKeySize() : table.getPrimaryKeySize() - ((TableImpl)table.getParent()).getPrimaryKeySize();
            for (Index index : table.getIndexes().values()) {
                this.secondaries.add(TableManager.createDbName(index.getName(), index.getTable().getFullName()));
            }
            for (Table child : table.getChildTables().values()) {
                TableEntry entry = new TableEntry((TableImpl)child);
                if (!entry.hasSecondaries()) continue;
                this.children.put(((TableImpl)child).getIdString(), entry);
            }
        }

        private boolean hasSecondaries() {
            return !this.secondaries.isEmpty() || !this.children.isEmpty();
        }

        private Collection<String> matchIndexes(Key.BinaryKeyIterator keyIter) {
            for (int i = 0; i < this.keySize; ++i) {
                if (keyIter.atEndOfKey()) {
                    return null;
                }
                keyIter.skip();
            }
            if (keyIter.atEndOfKey()) {
                return this.secondaries;
            }
            String childId = keyIter.next();
            TableEntry entry = this.children.get(childId);
            return entry == null ? null : entry.matchIndexes(keyIter);
        }
    }

    private class TableManagerStateTracker
    extends StateTracker {
        TableManagerStateTracker(Logger logger) {
            super(TableManagerStateTracker.class.getSimpleName(), TableManager.this.repNode, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doNotify(StateChangeEvent sce) {
            ReplicatedEnvironment repEnv = TableManager.this.repNode.getEnv(1L);
            if (repEnv == null) {
                return;
            }
            this.logger.log(Level.INFO, "Table manager change state to {0}", (Object)sce.getState());
            Database infoDb = null;
            TableManager.this.threadLock.lock();
            try {
                if (sce.getState().isMaster()) {
                    infoDb = SecondaryInfoMap.openDb(repEnv);
                    TableManager.this.checkMaintenanceThreads(repEnv, infoDb);
                } else {
                    TableManager.this.stopMaintenanceThread();
                }
            }
            catch (RuntimeException re) {
                this.logger.log(Level.SEVERE, "Table manager state change failed", re);
            }
            finally {
                if (infoDb != null) {
                    TxnUtil.close(this.logger, infoDb, "secondary info db");
                }
                TableManager.this.threadLock.unlock();
            }
        }
    }
}

