/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.table;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import java.util.List;
import java.util.Set;
import oracle.kv.impl.api.table.IndexImpl;

public class IndexKeyCreator
implements SecondaryKeyCreator,
SecondaryMultiKeyCreator {
    private volatile IndexImpl index;
    private final boolean keyOnly;
    private final boolean isMultiKey;

    IndexKeyCreator(IndexImpl index) {
        this.index = index;
        this.keyOnly = index.isKeyOnly();
        this.isMultiKey = index.isMultiKey();
    }

    boolean primaryKeyOnly() {
        return this.keyOnly;
    }

    boolean isMultiKey() {
        return this.isMultiKey;
    }

    void setIndex(IndexImpl newIndex) {
        this.index = newIndex;
    }

    public boolean createSecondaryKey(SecondaryDatabase secondaryDb, DatabaseEntry key, DatabaseEntry data, DatabaseEntry result) {
        byte[] res = this.index.extractIndexKey(key.getData(), data != null ? data.getData() : null, this.keyOnly);
        if (res != null) {
            result.setData(res);
            return true;
        }
        return false;
    }

    public void createSecondaryKeys(SecondaryDatabase secondaryDb, DatabaseEntry key, DatabaseEntry data, Set<DatabaseEntry> results) {
        List<byte[]> res = this.index.extractIndexKeys(key.getData(), data.getData(), this.keyOnly);
        if (res != null) {
            for (byte[] bytes : res) {
                results.add(new DatabaseEntry(bytes));
            }
        }
    }

    public String toString() {
        return "IndexKeyCreator[" + this.index.getName() + "]";
    }
}

