/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import oracle.kv.KVVersion;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.TxnUtil;

class PartitionMigrations
implements Iterable<MigrationRecord>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MIGRATION_DB_NAME = "MigrationDB";
    private static final String PARTITION_MIGRATIONS_KEY = "PartitionMigrations";
    private static final DatabaseEntry migrationsKey = new DatabaseEntry();
    private static final int CURRENT_SCHEMA_VERSION = 1;
    private static final TransactionConfig NO_WAIT_CONFIG;
    private final Map<PartitionId, MigrationRecord> records = new HashMap<PartitionId, MigrationRecord>();
    private long changeNumber = 0L;
    private int topoSequenceNum = 0;
    private long nextRecordId = 1L;
    private int version = 1;

    private PartitionMigrations() {
    }

    long getChangeNumber() {
        return this.changeNumber;
    }

    int getTopoSequenceNum() {
        return this.topoSequenceNum;
    }

    void setTopoSequenceNum(int seqNum) {
        assert (seqNum >= this.topoSequenceNum);
        this.topoSequenceNum = seqNum;
    }

    void add(MigrationRecord record) {
        this.records.put(record.partitionId, record);
    }

    MigrationRecord get(PartitionId partitionId) {
        return this.records.get(partitionId);
    }

    TargetRecord getTarget(PartitionId partitionId) {
        MigrationRecord record = this.get(partitionId);
        return record instanceof TargetRecord ? (TargetRecord)record : null;
    }

    SourceRecord getSource(PartitionId partitionId) {
        MigrationRecord record = this.get(partitionId);
        return record instanceof SourceRecord ? (SourceRecord)record : null;
    }

    @Override
    public Iterator<MigrationRecord> iterator() {
        return this.records.values().iterator();
    }

    MigrationRecord remove(PartitionId partitionId) {
        return this.records.remove(partitionId);
    }

    Iterator<MigrationRecord> completed() {
        return new Iterator<MigrationRecord>(){
            final Iterator<MigrationRecord> itr;
            MigrationRecord r;
            {
                this.itr = PartitionMigrations.this.records.values().iterator();
                this.r = null;
            }

            @Override
            public boolean hasNext() {
                while (this.itr.hasNext()) {
                    this.r = this.itr.next();
                    if (!this.r.isCompleted()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public MigrationRecord next() {
                if (this.r == null) {
                    throw new NoSuchElementException();
                }
                return this.r;
            }

            @Override
            public void remove() {
                if (this.r == null) {
                    throw new IllegalStateException();
                }
                this.itr.remove();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PartitionMigrations fetch(Database db) {
        Transaction txn = db.getEnvironment().beginTransaction(null, NO_WAIT_CONFIG);
        try {
            PartitionMigrations partitionMigrations = PartitionMigrations.fetch(db, txn, LockMode.READ_UNCOMMITTED);
            return partitionMigrations;
        }
        finally {
            if (txn.isValid()) {
                txn.commit();
            } else {
                TxnUtil.abort(txn);
            }
        }
    }

    static PartitionMigrations fetch(Database db, Transaction txn) {
        return PartitionMigrations.fetch(db, txn, LockMode.RMW);
    }

    private static PartitionMigrations fetch(Database db, Transaction txn, LockMode lockMode) {
        if (txn == null) {
            throw new IllegalStateException("transaction can not be null");
        }
        DatabaseEntry value = new DatabaseEntry();
        db.get(txn, migrationsKey, value, lockMode);
        PartitionMigrations migrations = SerializationUtil.getObject(value.getData(), PartitionMigrations.class);
        return migrations == null ? new PartitionMigrations() : migrations;
    }

    void persist(Database db, Transaction txn, boolean bumpChangeNum) {
        if (bumpChangeNum) {
            ++this.changeNumber;
        }
        db.put(txn, migrationsKey, new DatabaseEntry(SerializationUtil.getBytes(this)));
    }

    TargetRecord newTarget(PartitionId partitionId, RepGroupId sourceRGId, RepNodeId targetRNId) {
        return new TargetRecord(partitionId, sourceRGId, targetRNId, this.nextRecordId++);
    }

    SourceRecord newSource(PartitionMigrationStatus status, PartitionId partitionId, RepGroupId sourceRGId, RepNodeId targetRNId) {
        return new SourceRecord(status, partitionId, sourceRGId, targetRNId, this.nextRecordId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database openDb(Environment env, DatabaseConfig dbConfig) {
        Database database;
        TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        Transaction txn = null;
        Database db = null;
        try {
            txn = env.beginTransaction(null, txnConfig);
            db = env.openDatabase(txn, MIGRATION_DB_NAME, dbConfig);
            txn.commit();
            txn = null;
            Database ret = db;
            db = null;
            database = ret;
        }
        catch (Throwable throwable) {
            TxnUtil.abort(txn);
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException de) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        TxnUtil.abort(txn);
        if (db != null) {
            try {
                db.close();
            }
            catch (DatabaseException de) {
                // empty catch block
            }
        }
        return database;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.version > 1) {
            throw new IllegalStateException("The Partition Migration Service is at " + KVVersion.CURRENT_VERSION + ", schema version " + 1 + " but the stored schema is at version " + this.version + ". Please upgrade this node's NoSQL Database version.");
        }
        if (this.version != 1) {
            throw new IllegalStateException("Unexpected migration store schema version, expected 1 but the stored schema is at version " + this.version + ".");
        }
    }

    public String toString() {
        return "PartitionMigrations[" + this.changeNumber + ", " + this.topoSequenceNum + ", " + this.records.size() + "]";
    }

    static {
        StringBinding.stringToEntry((String)PARTITION_MIGRATIONS_KEY, (DatabaseEntry)migrationsKey);
        NO_WAIT_CONFIG = new TransactionConfig().setDurability(new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE)).setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
    }

    static abstract class MigrationRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final PartitionId partitionId;
        private final RepGroupId sourceRGId;
        private final RepNodeId targetRNId;
        private final long recordId;
        protected PartitionMigrationStatus status = null;

        protected MigrationRecord(PartitionMigrationStatus status, PartitionId partitionId, RepGroupId sourceRGId, RepNodeId targetRNId, long recordId) {
            this.status = status;
            this.partitionId = partitionId;
            this.sourceRGId = sourceRGId;
            this.targetRNId = targetRNId;
            this.recordId = recordId;
        }

        PartitionId getPartitionId() {
            return this.partitionId;
        }

        RepGroupId getSourceRGId() {
            return this.sourceRGId;
        }

        RepGroupId getTargetRGId() {
            return new RepGroupId(this.targetRNId.getGroupId());
        }

        RepNodeId getTargetRNId() {
            return this.targetRNId;
        }

        long getId() {
            assert (this.recordId != 0L);
            return this.recordId;
        }

        PartitionMigrationStatus getStatus() {
            return this.status;
        }

        abstract boolean isCompleted();
    }

    static class SourceRecord
    extends MigrationRecord {
        private static final long serialVersionUID = 1L;

        private SourceRecord(PartitionMigrationStatus status, PartitionId partitionId, RepGroupId sourceRGId, RepNodeId targetRNId, long recordId) {
            super(status, partitionId, sourceRGId, targetRNId, recordId);
            assert (status.forSource());
        }

        @Override
        boolean isCompleted() {
            return true;
        }

        public String toString() {
            return "SourceRecord[" + this.getPartitionId() + ", " + this.getSourceRGId() + ", " + this.getTargetRNId() + "]";
        }
    }

    static class TargetRecord
    extends MigrationRecord {
        private static final long serialVersionUID = 1L;

        private TargetRecord(PartitionId partitionId, RepGroupId sourceRGId, RepNodeId targetRNId, long recordId) {
            super(null, partitionId, sourceRGId, targetRNId, recordId);
        }

        RepNodeAdmin.PartitionMigrationState getState() {
            return this.status == null ? RepNodeAdmin.PartitionMigrationState.PENDING : this.status.getState();
        }

        void setStatus(PartitionMigrationStatus status) {
            assert (status.forTarget());
            this.status = status;
        }

        boolean isPending() {
            return this.getState().equals((Object)RepNodeAdmin.PartitionMigrationState.PENDING);
        }

        @Override
        boolean isCompleted() {
            return this.getState().equals((Object)RepNodeAdmin.PartitionMigrationState.SUCCEEDED);
        }

        public String toString() {
            return "TargetRecord[" + this.getPartitionId() + ", " + this.getSourceRGId() + ", " + this.getTargetRGId() + ", " + (Object)((Object)this.getState()) + "]";
        }
    }
}

