/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.masterBalance;

import com.sleepycat.je.rep.MasterReplicaTransitionException;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.masterBalance.MasterBalanceManagerDisabled;
import oracle.kv.impl.rep.masterBalance.MasterBalanceManagerInterface;
import oracle.kv.impl.rep.masterBalance.MasterBalanceStateTracker;
import oracle.kv.impl.topo.RepNodeId;

public class MasterBalanceManager
implements MasterBalanceManagerInterface {
    private final RepNode repNode;
    private final AtomicReference<MasterTransferThread> activeTransfer = new AtomicReference<Object>(null);
    private final MasterBalanceStateTracker stateTracker;
    private final Logger logger;

    MasterBalanceManager(RepNode repNode, Logger logger) {
        this.repNode = repNode;
        this.logger = logger;
        this.stateTracker = new MasterBalanceStateTracker(repNode, logger);
    }

    public static MasterBalanceManagerInterface create(RepNode repNode, Logger logger) {
        return repNode.getRepNodeParams().getMasterBalance() ? new MasterBalanceManager(repNode, logger) : new MasterBalanceManagerDisabled(logger);
    }

    @Override
    public MasterBalanceStateTracker getStateTracker() {
        return this.stateTracker;
    }

    @Override
    public void startTracker() {
        this.stateTracker.start();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void noteStateChange(StateChangeEvent stateChangeEvent) {
        this.stateTracker.noteStateChange(stateChangeEvent);
    }

    @Override
    public void shutdown() {
        this.stateTracker.shutdown();
    }

    @Override
    public boolean initiateMasterTransfer(RepNodeId replicaId, int timeout, TimeUnit timeUnit) {
        ReplicatedEnvironment env = this.repNode.getEnv(0L);
        if (env == null || !env.getState().isMaster()) {
            return false;
        }
        MasterTransferThread mtThread = new MasterTransferThread(env, replicaId, timeout, timeUnit);
        if (this.activeTransfer.compareAndSet(null, mtThread)) {
            mtThread.start();
            return true;
        }
        mtThread = this.activeTransfer.get();
        if (mtThread != null) {
            this.logger.info("Declined request: Master transfer initiated at: " + new Date(mtThread.startTimeMs).toString() + " with target replica:" + mtThread.replicaId + " is already in progress. ");
            return false;
        }
        return this.initiateMasterTransfer(replicaId, timeout, timeUnit);
    }

    private class MasterTransferThread
    extends Thread {
        private final long startTimeMs;
        private final ReplicatedEnvironment env;
        private final RepNodeId replicaId;
        private final int timeout;
        private final TimeUnit timeUnit;

        MasterTransferThread(ReplicatedEnvironment env, RepNodeId replicaId, int timeout, TimeUnit timeUnit) {
            super("Master Transfer Thread. Target:" + replicaId.toString());
            this.startTimeMs = System.currentTimeMillis();
            this.env = env;
            this.replicaId = replicaId;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Set<String> targetRN = Collections.singleton(this.replicaId.getFullName());
                this.env.transferMaster(targetRN, this.timeout, this.timeUnit);
            }
            catch (MasterTransferFailureException mtfe) {
                MasterBalanceManager.this.logger.log(Level.INFO, "Requested transfer to " + this.replicaId + " failed.", mtfe);
                return;
            }
            catch (IllegalStateException ise) {
                MasterBalanceManager.this.logger.log(Level.INFO, "Node is no longer the master", ise);
                return;
            }
            catch (MasterReplicaTransitionException e) {
                return;
            }
            catch (Exception e) {
                MasterBalanceManager.this.logger.log(Level.WARNING, "Unexpected master transfer failure", e);
            }
            finally {
                MasterBalanceManager.this.activeTransfer.set(null);
                MasterBalanceManager.this.logger.log(Level.INFO, "Master transfer thread exited");
            }
        }
    }
}

