/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.fault.WrappedClientException;
import oracle.kv.impl.rep.EnvironmentFailureRetryException;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.server.LoggerUtils;

public class RepNodeServiceFaultHandler
extends ProcessFaultHandler {
    private final RepNodeService repNodeService;
    private Throwable shutdownFault;

    public RepNodeServiceFaultHandler(RepNodeService repNodeService, Logger logger, ProcessExitCode defaultExitCode) {
        super(logger, defaultExitCode);
        this.repNodeService = repNodeService;
    }

    @Override
    protected void queueShutdownInternal(Throwable fault, ProcessExitCode exitCode) {
        assert (fault != null);
        this.shutdownFault = fault;
        if (TestStatus.isActive()) {
            new AsyncTestShutdownThread().start();
        } else {
            new AsyncShutdownThread(exitCode).start();
        }
    }

    @Override
    protected RuntimeException getThrowException(RuntimeException requestException) {
        if (requestException instanceof RNUnavailableException || requestException instanceof WrappedClientException || requestException instanceof FaultException) {
            return requestException;
        }
        if (requestException instanceof ClientAccessException) {
            return ((ClientAccessException)requestException).getCause();
        }
        if (requestException instanceof EnvironmentFailureRetryException) {
            return new RNUnavailableException(requestException.getMessage());
        }
        return new FaultException(requestException, true);
    }

    @Override
    public ProcessExitCode getExitCode(RuntimeException requestException, ProcessExitCode exitCode) {
        if (requestException instanceof RNUnavailableException || requestException instanceof WrappedClientException || requestException instanceof FaultException) {
            return null;
        }
        return exitCode;
    }

    public Throwable getShutdownFault() {
        return this.shutdownFault;
    }

    private class AsyncShutdownThread
    extends Thread {
        final ProcessExitCode exitCode;

        AsyncShutdownThread(ProcessExitCode exitCode) {
            this.exitCode = exitCode;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.yield();
            try {
                System.err.println("Process exiting due to fault");
                if (RepNodeServiceFaultHandler.this.shutdownFault != null) {
                    RepNodeServiceFaultHandler.this.shutdownFault.printStackTrace(System.err);
                }
                ConfigurableService.ServiceStatus status = ProcessExitCode.NO_RESTART.getValue() == this.exitCode.getValue() ? ConfigurableService.ServiceStatus.ERROR_NO_RESTART : ConfigurableService.ServiceStatus.ERROR_RESTARTING;
                RepNodeServiceFaultHandler.this.repNodeService.getStatusTracker().update(status);
                LoggerUtils.closeAllHandlers();
                System.err.flush();
            }
            finally {
                System.exit(this.exitCode.getValue());
            }
        }
    }

    private class AsyncTestShutdownThread
    extends Thread {
        AsyncTestShutdownThread() {
            assert (RepNodeServiceFaultHandler.this.repNodeService.getUsingThreads());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                RepNodeServiceFaultHandler.this.repNodeService.stop(true);
            }
            catch (Exception e) {
                System.err.println("Exception during exit: " + e);
            }
        }
    }
}

