/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.HostPortPair;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.RequestDispatcherImpl;
import oracle.kv.impl.api.RequestHandlerImpl;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.fault.SystemFaultException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterTracker;
import oracle.kv.impl.rep.MetadataUpdateThread;
import oracle.kv.impl.rep.OperationsStatsTracker;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeSecurity;
import oracle.kv.impl.rep.RepNodeServiceFaultHandler;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminImpl;
import oracle.kv.impl.rep.login.RepNodeLoginService;
import oracle.kv.impl.rep.monitor.MonitorAgentImpl;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.metadata.SecurityMDListener;
import oracle.kv.impl.security.metadata.SecurityMDUpdater;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.ServiceStatusTracker;
import oracle.kv.impl.util.UserDataControl;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.ServerSocketFactory;
import oracle.kv.impl.util.server.LoggerUtils;

public class RepNodeService
implements ConfigurableService {
    private static final long SHUTDOWN_TIMEOUT_MS = 10000L;
    private RepNodeId repNodeId;
    private Params params;
    private RequestHandlerImpl reqHandler = null;
    private RepNodeSecurity rnSecurity = null;
    private RepNodeAdminImpl admin = null;
    private MonitorAgentImpl monitorAgent = null;
    private RepNodeLoginService loginService = null;
    private RepNode repNode = null;
    private MetadataUpdateThread metadataUpdateThread = null;
    private ServiceStatusTracker statusTracker;
    private OperationsStatsTracker opStatsTracker;
    private final ParameterTracker parameterTracker;
    private final ParameterTracker globalParameterTracker;
    private final Object stopLock = new Object();
    private final RepNodeServiceFaultHandler faultHandler = new RepNodeServiceFaultHandler(this, this.logger, ProcessExitCode.RESTART);
    private final boolean usingThreads;
    public static final String DEFAULT_CMS_GC_ARGS = "-XX:+UseConcMarkSweepGC -XX:+UseParNewGC -XX:+DisableExplicitGC -XX:NewRatio=18 -XX:SurvivorRatio=4 -XX:MaxTenuringThreshold=10 -XX:CMSInitiatingOccupancyFraction=80 ";
    public static final String DEFAULT_G1_GC_ARGS = "-XX:+UseG1GC -XX:NewRatio=15 -XX:MaxTenuringThreshold=10 -XX:InitiatingHeapOccupancyPercent=80";
    public static final String DEFAULT_MISC_JAVA_ARGS = (!"Mac OS X".equals(System.getProperty("os.name")) ? "-XX:+UseLargePages " : "") + "-Dje.rep.skipHelperHostResolution=true";
    protected Logger logger;

    public RepNodeService() {
        this(false);
    }

    public RepNodeService(boolean usingThreads) {
        this.usingThreads = usingThreads;
        this.parameterTracker = new ParameterTracker();
        this.globalParameterTracker = new ParameterTracker();
    }

    public void initialize(SecurityParams securityParams, RepNodeParams repNodeParams, LoadParameters lp) {
        String policyFile;
        securityParams.initRMISocketPolicies();
        GlobalParams globalParams = new GlobalParams(lp.getMap("globalParams"));
        StorageNodeParams storageNodeParams = new StorageNodeParams(lp.getMap("storageNodeParams"));
        this.params = new Params(securityParams, globalParams, storageNodeParams, repNodeParams);
        this.repNodeId = repNodeParams.getRepNodeId();
        AgentRepository monitorBuffer = new AgentRepository(globalParams.getKVStoreName(), this.repNodeId);
        this.logger = LoggerUtils.getLogger(this.getClass(), this.params);
        this.faultHandler.setLogger(this.logger);
        ClientSocketFactory.setTimeoutLogger(this.logger);
        this.rnSecurity = new RepNodeSecurity(this, this.logger);
        RequestDispatcherImpl requestDispatcher = new RequestDispatcherImpl(globalParams.getKVStoreName(), this.params.getRepNodeParams(), this.rnSecurity.getLoginManager(), (Thread.UncaughtExceptionHandler)new ThreadExceptionHandler(), this.logger);
        this.rnSecurity.setDispatcher(requestDispatcher);
        this.statusTracker = new ServiceStatusTracker(this.logger, monitorBuffer);
        this.repNode = new RepNode(this.params, requestDispatcher, this);
        this.rnSecurity.setTopologyManager(requestDispatcher.getTopologyManager());
        this.reqHandler = new RequestHandlerImpl(requestDispatcher, this.faultHandler, this.rnSecurity.getAccessChecker());
        this.repNode.initialize(this.params, this.reqHandler.getListenerFactory());
        this.addParameterListener(this.repNode.getRepEnvManager());
        this.opStatsTracker = new OperationsStatsTracker(this, this.params.getRepNodeParams().getMap(), monitorBuffer);
        this.reqHandler.initialize(this.params, this.repNode, this.opStatsTracker);
        this.addParameterListener(this.opStatsTracker);
        this.admin = new RepNodeAdminImpl(this, this.repNode);
        this.loginService = new RepNodeLoginService(this);
        this.monitorAgent = new MonitorAgentImpl(this, monitorBuffer);
        this.metadataUpdateThread = new MetadataUpdateThread(requestDispatcher, this.repNode, this.logger);
        this.metadataUpdateThread.start();
        this.addParameterListener(UserDataControl.getParamListener());
        LoginUpdater loginUpdater = new LoginUpdater();
        loginUpdater.addServiceParamsUpdaters(this.rnSecurity);
        loginUpdater.addGlobalParamsUpdaters(this.rnSecurity);
        loginUpdater.addServiceParamsUpdaters(this.loginService);
        loginUpdater.addGlobalParamsUpdaters(this.loginService);
        this.addParameterListener(new LoginUpdater.ServiceParamsListener(loginUpdater));
        this.addGlobalParameterListener(new LoginUpdater.GlobalParamsListener(loginUpdater));
        SecurityMDUpdater secMDUpdater = new SecurityMDUpdater();
        secMDUpdater.addUserChangeUpdaters(this.rnSecurity);
        secMDUpdater.addRoleChangeUpdaters(this.rnSecurity);
        this.addSecurityMDListener(this.loginService);
        this.addSecurityMDListener(new SecurityMDUpdater.UserChangeListener(secMDUpdater));
        this.addSecurityMDListener(new SecurityMDUpdater.RoleChangeListener(secMDUpdater));
        File kvDir = FileNames.getKvDir(storageNodeParams.getRootDirPath(), globalParams.getKVStoreName());
        try {
            policyFile = FileNames.getSecurityPolicyFile(kvDir).getCanonicalPath();
        }
        catch (IOException e) {
            throw new SystemFaultException("IO Exception trying to access security policy file: " + FileNames.getSecurityPolicyFile(kvDir), e);
        }
        if (policyFile != null && new File(policyFile).exists()) {
            System.setProperty("java.security.policy", policyFile);
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        System.setProperty("java.rmi.server.hostname", storageNodeParams.getHostname());
        System.setProperty("java.rmi.server.disableHttp", "true");
        if (!this.usingThreads) {
            storageNodeParams.setRegistryCSF(securityParams);
        }
    }

    public synchronized void newParameters() {
        ParameterMap newMap;
        ParameterMap oldMap = this.params.getRepNodeParams().getMap();
        if (oldMap.equals(newMap = ConfigUtils.getRepNodeMap(this.params.getStorageNodeParams(), this.params.getGlobalParams(), this.repNodeId, this.logger))) {
            this.logger.info("newParameters are identical to old parameters");
            return;
        }
        this.logger.info("newParameters: refreshing parameters");
        this.params.setRepNodeParams(new RepNodeParams(newMap));
        this.parameterTracker.notifyListeners(oldMap, newMap);
    }

    public synchronized void newGlobalParameters() {
        ParameterMap newMap;
        ParameterMap oldMap = this.params.getGlobalParams().getMap();
        if (oldMap.equals(newMap = ConfigUtils.getGlobalMap(this.params.getStorageNodeParams(), this.params.getGlobalParams(), this.logger))) {
            this.logger.info("newGlobalParameters are identical to old global parameters");
            return;
        }
        this.logger.info("newGlobalParameters: refreshing global parameters");
        this.params.setGlobalParams(new GlobalParams(newMap));
        this.globalParameterTracker.notifyListeners(oldMap, newMap);
    }

    public void addParameterListener(ParameterListener listener) {
        this.parameterTracker.addListener(listener);
    }

    private void addGlobalParameterListener(ParameterListener listener) {
        this.globalParameterTracker.addListener(listener);
    }

    private void addSecurityMDListener(SecurityMDListener listener) {
        this.repNode.getSecurityMDManager().addUpdateListener(listener);
    }

    @Override
    public void start() {
        this.start(null);
    }

    public void start(Topology topology) {
        this.statusTracker.update(ConfigurableService.ServiceStatus.STARTING);
        try {
            this.logger.info("Starting RepNodeService");
            this.monitorAgent.startup();
            this.admin.startup();
            ReplicatedEnvironment repEnv = this.repNode.startup();
            this.topologyStartup(repEnv, topology);
            this.rnSecurity.startup();
            this.reqHandler.startup();
            this.loginService.startup();
            this.statusTracker.update(ConfigurableService.ServiceStatus.RUNNING);
            this.logger.info("Started RepNodeService");
        }
        catch (RemoteException re) {
            this.statusTracker.update(ConfigurableService.ServiceStatus.ERROR_NO_RESTART);
            throw new IllegalStateException("RepNodeService startup failed", re);
        }
    }

    private void topologyStartup(ReplicatedEnvironment repEnv, Topology testTopology) {
        if (testTopology != null) {
            this.logger.info("Test environment topology self-supplied.");
            HashSet<Metadata<? extends MetadataInfo>> metadataSet = new HashSet<Metadata<? extends MetadataInfo>>(1);
            metadataSet.add(testTopology);
            this.admin.configure(metadataSet, (AuthContext)null, (short)7);
            return;
        }
        if (this.repNode.getTopology() != null) {
            return;
        }
        this.logger.info("Topology needs to be pushed to this node.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean force) {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.statusTracker.getServiceStatus().isTerminalState()) {
                return;
            }
            this.statusTracker.update(ConfigurableService.ServiceStatus.STOPPING);
            try {
                this.loginService.stop();
                this.reqHandler.stop();
                this.opStatsTracker.pushStats();
                this.admin.stop();
                this.rnSecurity.stop();
                this.stopMetadataUpdateThread(false);
                this.repNode.stop(force);
                this.statusTracker.update(ConfigurableService.ServiceStatus.STOPPED);
                this.monitorAgent.stop();
                if (!this.usingThreads) {
                    LoggerUtils.closeHandlers(this.params != null ? this.params.getGlobalParams().getKVStoreName() : "UNKNOWN");
                }
            }
            catch (RemoteException re) {
                try {
                    this.statusTracker.update(ConfigurableService.ServiceStatus.ERROR_NO_RESTART);
                    throw new IllegalStateException("RepNodeService stop failed", re);
                }
                catch (Throwable throwable) {
                    if (!this.usingThreads) {
                        LoggerUtils.closeHandlers(this.params != null ? this.params.getGlobalParams().getKVStoreName() : "UNKNOWN");
                    }
                    throw throwable;
                }
            }
        }
    }

    public ServiceStatusTracker getStatusTracker() {
        return this.statusTracker;
    }

    public OperationsStatsTracker getOpStatsTracker() {
        return this.opStatsTracker;
    }

    public Params getParams() {
        return this.params;
    }

    public RepNodeId getRepNodeId() {
        return this.repNode.getRepNodeId();
    }

    public StorageNodeId getStorageNodeId() {
        return this.params.getStorageNodeParams().getStorageNodeId();
    }

    public RepNodeParams getRepNodeParams() {
        return this.params.getRepNodeParams();
    }

    public ProcessFaultHandler getFaultHandler() {
        return this.faultHandler;
    }

    public SecurityMetadata getSecurityMetadata() {
        return this.repNode.getSecurityMDManager().getSecurityMetadata();
    }

    public boolean getUsingThreads() {
        return this.usingThreads;
    }

    public void rebind(Remote remoteComponent, RegistryUtils.InterfaceType type, ClientSocketFactory clientSocketFactory, ServerSocketFactory serverSocketFactory) throws RemoteException {
        StorageNodeParams snp = this.params.getStorageNodeParams();
        RegistryUtils.rebind(snp.getHostname(), snp.getRegistryPort(), this.params.getGlobalParams().getKVStoreName(), this.getRepNodeId().getFullName(), type, remoteComponent, clientSocketFactory, serverSocketFactory);
    }

    public boolean unbind(Remote remoteComponent, RegistryUtils.InterfaceType type) throws RemoteException {
        StorageNodeParams snp = this.params.getStorageNodeParams();
        return RegistryUtils.unbind(snp.getHostname(), snp.getRegistryPort(), this.params.getGlobalParams().getKVStoreName(), this.getRepNodeId().getFullName(), type, remoteComponent);
    }

    RepNode getRepNode() {
        return this.repNode;
    }

    public RequestHandlerImpl getReqHandler() {
        return this.reqHandler;
    }

    public RepNodeAdmin getRepNodeAdmin() {
        return this.admin;
    }

    public RepNodeSecurity getRepNodeSecurity() {
        return this.rnSecurity;
    }

    public LoginManager getLoginManager() {
        return this.rnSecurity.getLoginManager();
    }

    public void updateMemberHAAddress(String groupName, String targetNodeName, String targetHelperHosts, String newNodeHostPort) {
        HashSet<InetSocketAddress> helperSockets = new HashSet<InetSocketAddress>();
        StringTokenizer tokenizer = new StringTokenizer(targetHelperHosts, ",");
        while (tokenizer.hasMoreTokens()) {
            String helper = tokenizer.nextToken();
            helperSockets.add(HostPortPair.getSocket((String)helper));
        }
        ReplicationGroupAdmin rga = new ReplicationGroupAdmin(groupName, helperSockets, this.repNode != null ? this.repNode.getRepNetConfig() : null);
        ReplicationGroup rg = rga.getGroup();
        ReplicationNode jeRN = rg.getMember(targetNodeName);
        if (jeRN == null) {
            throw new IllegalStateException(targetNodeName + " does not exist in replication group " + groupName);
        }
        String newHostName = HostPortPair.getHostname((String)newNodeHostPort);
        int newPort = HostPortPair.getPort((String)newNodeHostPort);
        if (jeRN.getHostName().equals(newHostName) && jeRN.getPort() == newPort) {
            return;
        }
        rga.updateAddress(targetNodeName, newHostName, newPort);
    }

    void stopMetadataUpdateThread(boolean wait) {
        if (this.metadataUpdateThread != null) {
            this.metadataUpdateThread.shutdown();
            if (wait) {
                try {
                    this.metadataUpdateThread.join(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class ThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ThreadExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (RepNodeService.this.logger != null) {
                RepNodeService.this.logger.log(Level.SEVERE, "uncaught exception in thread", e);
            } else {
                System.err.println("Uncaught exception:");
                e.printStackTrace(System.err);
            }
            RepNodeService.this.faultHandler.queueShutdown(e, ProcessExitCode.RESTART);
        }
    }

    public static class Params {
        private final SecurityParams securityParams;
        private volatile GlobalParams globalParams;
        private final StorageNodeParams storageNodeParams;
        private volatile RepNodeParams repNodeParams;

        public Params(SecurityParams securityParams, GlobalParams globalParams, StorageNodeParams storageNodeParams, RepNodeParams repNodeParams) {
            this.securityParams = securityParams;
            this.globalParams = globalParams;
            this.storageNodeParams = storageNodeParams;
            this.repNodeParams = repNodeParams;
        }

        public SecurityParams getSecurityParams() {
            return this.securityParams;
        }

        public GlobalParams getGlobalParams() {
            return this.globalParams;
        }

        public StorageNodeParams getStorageNodeParams() {
            return this.storageNodeParams;
        }

        public RepNodeParams getRepNodeParams() {
            return this.repNodeParams;
        }

        public void setRepNodeParams(RepNodeParams params) {
            this.repNodeParams = params;
        }

        public void setGlobalParams(GlobalParams params) {
            this.globalParams = params;
        }
    }
}

