/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.param;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.impl.RepParams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.kv.RequestLimitConfig;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.param.CacheModeParameter;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.util.ConfigUtils;

public class ParameterUtils {
    public static final String HELPER_HOST_SEPARATOR = ",";
    private final ParameterMap map;
    private static final String DEFAULT_CONFIG_PROPERTIES = "je.txn.durability=write_no_sync,write_no_sync,simple_majority;je.nodeMaxEntries=128;je.cleaner.threads=2;je.log.fileCacheSize=2000;je.cleaner.readSize=1048576;je.checkpointer.bytesInterval=500000000;je.env.runEvictor=true;je.log.writeQueueSize=2097152;je.log.numBuffers=16;je.log.fileMax=1073741824;je.cleaner.minUtilization=40;je.log.faultReadSize=4096;je.log.iteratorReadSize=1048576;je.lock.nLockTables=97;je.lock.timeout=10 s;je.rep.envUnknownStateTimeout=10 s;je.rep.txnRollbackLimit=10;je.rep.replicaAckTimeout=5 s;je.rep.consistencyPolicy=NoConsistencyRequiredPolicy;je.rep.replayMaxOpenDbHandles=100;je.rep.feederTimeout=10 s;je.rep.replicaTimeout=10 s;je.rep.preHeartbeatTimeoutMs=5000000000;je.rep.vlsn.distance=1000000;je.rep.vlsn.logCacheSize=128;je.evictor.criticalPercentage=20;";
    private static final String EXTRA_ADMIN_CONFIG_PROPERTIES = "je.rep.bindInaddrAny=true;";

    public ParameterUtils(ParameterMap map) {
        this.map = map;
    }

    public EnvironmentConfig getEnvConfig() {
        EnvironmentConfig ec = new EnvironmentConfig(this.createProperties(true, false));
        ec.setAllowCreate(true);
        ec.setTransactional(true);
        if (this.map.exists("cacheSize")) {
            ec.setCacheSize(this.map.get("cacheSize").asLong());
        }
        return ec;
    }

    public ReplicationConfig getRNRepEnvConfig() {
        return this.getRepEnvConfig(null, false, false);
    }

    public ReplicationConfig getAdminRepEnvConfig() {
        return this.getRepEnvConfig(null, false, true);
    }

    public static void validateParams(ParameterMap map) {
        try {
            ParameterUtils pu = new ParameterUtils(map);
            pu.getEnvConfig();
            pu.getRepEnvConfig(null, true, false);
        }
        catch (Exception e) {
            throw new IllegalCommandException("Incorrect parameters: " + e.getMessage(), e);
        }
    }

    private ReplicationConfig getRepEnvConfig(Properties securityProps) {
        return this.getRepEnvConfig(securityProps, false, false);
    }

    private ReplicationConfig getRepEnvConfig(Properties securityProps, boolean validating, boolean forAdmin) {
        Properties allProps = this.createProperties(false, forAdmin);
        this.mergeProps(allProps, securityProps);
        ReplicationConfig rc = new ReplicationConfig(allProps);
        rc.setConfigParam("je.rep.preserveRecordVersion", "true");
        if (this.map.exists("helperHosts")) {
            rc.setHelperHosts(this.map.get("helperHosts").asString());
        }
        if (this.map.exists("nodeHostPort")) {
            String nhp = this.map.get("nodeHostPort").asString();
            if (validating) {
                RepParams.HELPER_HOSTS.validateValue(nhp);
            } else {
                rc.setNodeHostPort(nhp);
            }
        }
        return rc;
    }

    private void removeRep(Properties props) {
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.indexOf("je.rep.") == -1) continue;
            it.remove();
        }
    }

    private void mergeProps(Properties baseProps, Properties mergeProps) {
        if (mergeProps == null) {
            return;
        }
        for (Object propKey : mergeProps.keySet()) {
            String propSKey = (String)propKey;
            String propVal = mergeProps.getProperty(propSKey);
            baseProps.setProperty(propSKey, propVal);
        }
    }

    public Properties createProperties(boolean removeReplication, boolean forAdmin) {
        String configProperties;
        Properties props = new Properties();
        String propertyString = DEFAULT_CONFIG_PROPERTIES;
        if (forAdmin) {
            propertyString = propertyString + EXTRA_ADMIN_CONFIG_PROPERTIES;
        }
        if ((configProperties = this.map.get("configProperties").asString()) != null) {
            propertyString = propertyString + ";" + configProperties;
        }
        try {
            props.load(ConfigUtils.getPropertiesStream(propertyString));
            if (removeReplication) {
                this.removeRep(props);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return props;
    }

    public static CacheMode getCacheMode(ParameterMap map) {
        CacheModeParameter cmp = (CacheModeParameter)map.get("cacheMode");
        if (cmp != null) {
            return cmp.asCacheMode();
        }
        return null;
    }

    public static long getRequestQuiesceTime(ParameterMap map) {
        return ParameterUtils.getDurationMillis(map, "requestQuiesceTime");
    }

    public static RequestLimitConfig getRequestLimitConfig(ParameterMap map) {
        int maxActiveRequests = map.get("rnMaxActiveRequests").asInt();
        int requestThresholdPercent = map.get("rnRequestThresholdPercent").asInt();
        int nodeLimitPercent = map.get("rnNodeLimitPercent").asInt();
        return new RequestLimitConfig(maxActiveRequests, requestThresholdPercent, nodeLimitPercent);
    }

    public static long getThreadDumpIntervalMillis(ParameterMap map) {
        return ParameterUtils.getDurationMillis(map, "threadDumpInterval");
    }

    public static int getMaxTrackedLatencyMillis(ParameterMap map) {
        return (int)ParameterUtils.getDurationMillis(map, "maxTrackedLatency");
    }

    public static long getDurationMillis(ParameterMap map, String parameter) {
        DurationParameter dp = (DurationParameter)map.getOrDefault(parameter);
        return dp.toMillis();
    }

    public static List<String> helpersAsList(String helperHosts) {
        String[] split;
        ArrayList<String> helpers = new ArrayList<String>();
        if (helperHosts == null || helperHosts.length() == 0) {
            return helpers;
        }
        for (String element : split = helperHosts.split(HELPER_HOST_SEPARATOR)) {
            helpers.add(element.trim());
        }
        return helpers;
    }
}

