/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor;

import java.util.LinkedList;
import java.util.List;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.Pruned;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.server.LoggerUtils;

public class AgentRepository {
    private final int maxSize;
    private LinkedList<Measurement> current = new LinkedList();
    private int statusChanges;
    private Pruned pruned;
    private static final int DEFAULT_SIZE = 10000;

    public AgentRepository(String kvName, ResourceId resourceId) {
        this(kvName, resourceId, 10000);
    }

    public AgentRepository(String kvName, ResourceId resourceId, int maxSize) {
        if (resourceId != null) {
            LoggerUtils.registerMonitorAgentBuffer(kvName, resourceId, this);
        }
        this.maxSize = maxSize;
        this.pruned = new Pruned();
        this.statusChanges = 0;
    }

    AgentRepository(int maxSize) {
        this(null, null, maxSize);
    }

    public synchronized void add(Measurement p) {
        this.current.addLast(p);
        if (p instanceof ServiceStatusChange) {
            ++this.statusChanges;
        }
        if (this.current.size() > this.maxSize) {
            Measurement target = this.current.getFirst();
            if (target instanceof ServiceStatusChange) {
                --this.statusChanges;
            }
            this.pruned.record(target);
            this.current.removeFirst();
        }
    }

    public synchronized Snapshot getAndReset() {
        LinkedList<Measurement> retrieved = this.current;
        this.current = new LinkedList();
        if (this.pruned.exists()) {
            retrieved.addFirst(this.pruned);
            this.pruned = new Pruned();
        }
        Snapshot snapshot = new Snapshot(this.statusChanges, retrieved);
        this.statusChanges = 0;
        return snapshot;
    }

    public int size() {
        return this.current.size();
    }

    public class Snapshot {
        public final List<Measurement> measurements;
        public int serviceStatusChanges;

        Snapshot(int serviceStatusChanges, List<Measurement> measurements) {
            this.serviceStatusChanges = serviceStatusChanges;
            this.measurements = measurements;
        }
    }
}

