/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.mgmt.jmx;

import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import oracle.kv.impl.mgmt.jmx.JmxAgent;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.mgmt.jmx.StorageNodeMXBean;

public class StorageNode
extends NotificationBroadcasterSupport
implements StorageNodeMXBean {
    private final JmxAgent agent;
    private final MBeanServer server;
    private ObjectName oName;
    ConfigurableService.ServiceStatus status;
    long notifySequence = 1L;
    private static final String NOTIFY_SN_STATUS_CHANGE = "oracle.kv.storagenode.status";

    public StorageNode(JmxAgent agent, MBeanServer server) {
        this.agent = agent;
        this.server = server;
        this.status = ConfigurableService.ServiceStatus.UNREACHABLE;
        this.register();
    }

    private void register() {
        StringBuffer buf = new StringBuffer("Oracle NoSQL Database");
        buf.append(":type=StorageNode");
        try {
            this.oName = new ObjectName(buf.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception creating JMX ObjectName " + buf.toString(), e);
        }
        try {
            this.server.registerMBean(this, this.oName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception registring MBean " + this.oName.toString(), e);
        }
    }

    public void unregister() {
        if (this.oName != null) {
            try {
                this.server.unregisterMBean(this.oName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception while unregistring MBean " + this.oName.toString(), e);
            }
        }
    }

    public synchronized void setServiceStatus(ConfigurableService.ServiceStatus newStatus) {
        if (this.status.equals((Object)newStatus)) {
            return;
        }
        Notification n = new Notification(NOTIFY_SN_STATUS_CHANGE, this.oName, this.notifySequence++, System.currentTimeMillis(), "The service status for the StorageNode has  changed to " + newStatus.toString() + ".");
        n.setUserData(newStatus.toString());
        this.sendNotification(n);
        this.status = newStatus;
    }

    public synchronized void sendProxyNotification(Notification n) {
        this.sendNotification(n);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{NOTIFY_SN_STATUS_CHANGE}, Notification.class.getName(), "Announce a change in this StorageNode's service status."), new MBeanNotificationInfo(new String[]{"oracle.kv.repnode.status"}, Notification.class.getName(), "Announce a change in a RepNode's service status."), new MBeanNotificationInfo(new String[]{"oracle.kv.singleop.throughputfloor"}, Notification.class.getName(), "Single-operation throughput floor violation notification."), new MBeanNotificationInfo(new String[]{"oracle.kv.singleop.latencyceiling"}, Notification.class.getName(), "Single-operation latency ceiling violation notification."), new MBeanNotificationInfo(new String[]{"oracle.kv.multiop.throughputfloor"}, Notification.class.getName(), "Multi-operation throughput floor violation notification."), new MBeanNotificationInfo(new String[]{"oracle.kv.multiop.latencyceiling"}, Notification.class.getName(), "Multi-operation latency ceiling violation notification."), new MBeanNotificationInfo(new String[]{"oracle.kv.admin.status"}, Notification.class.getName(), "Announce a change in the Admin's service status")};
    }

    @Override
    public String getServiceStatus() {
        return this.status.toString();
    }

    @Override
    public int getAdminHttpPort() {
        return this.agent.getAdminHttpPort();
    }

    @Override
    public boolean isHostingAdmin() {
        return this.agent.isHostingAdmin();
    }

    @Override
    public String getRootDirPath() {
        return this.agent.getRootDir();
    }

    @Override
    public String getStoreName() {
        return this.agent.getStoreName();
    }

    @Override
    public String getHostname() {
        return this.agent.getHostname();
    }

    @Override
    public int getRegistryPort() {
        return this.agent.getRegistryPort();
    }

    @Override
    public String getHAHostname() {
        return this.agent.getHAHostname();
    }

    @Override
    public int getCapacity() {
        return this.agent.getCapacity();
    }

    @Override
    public int getLogFileLimit() {
        return this.agent.getLogFileLimit();
    }

    @Override
    public int getLogFileCount() {
        return this.agent.getLogFileCount();
    }

    @Override
    public String getHaPortRange() {
        return this.agent.getSnHaPortRange();
    }

    @Override
    public int getSnId() {
        return this.agent.getSnId();
    }

    @Override
    public int getMemoryMB() {
        return this.agent.getMemoryMB();
    }

    @Override
    public int getNumCPUs() {
        return this.agent.getNumCpus();
    }

    @Override
    public String getMountPoints() {
        return this.agent.getMountPointsString();
    }
}

