/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.mgmt.jmx;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.utilint.Latency;
import java.util.Date;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.measurement.ConciseStats;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.measurement.RepEnvStats;
import oracle.kv.impl.measurement.ReplicationState;
import oracle.kv.impl.mgmt.jmx.StorageNode;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.mgmt.jmx.RepNodeMXBean;

public class RepNode
extends NotificationBroadcasterSupport
implements RepNodeMXBean {
    private final RepNodeId rnId;
    private final MBeanServer server;
    private final StorageNode sn;
    private ConfigurableService.ServiceStatus status;
    private LatencyInfo singleInterval;
    private LatencyInfo singleCumulative;
    private LatencyInfo multiInterval;
    private LatencyInfo multiCumulative;
    private RepEnvStats repEnvStats;
    private RepNodeParams parameters;
    private ReplicatedEnvironment.State replicationState;
    private ObjectName oName;
    long notifySequence = 1L;
    static final String NOTIFY_RN_STATUS_CHANGE = "oracle.kv.repnode.status";
    static final String NOTIFY_SINGLE_TFLOOR = "oracle.kv.singleop.throughputfloor";
    static final String NOTIFY_SINGLE_LCEILING = "oracle.kv.singleop.latencyceiling";
    static final String NOTIFY_MULTI_TFLOOR = "oracle.kv.multiop.throughputfloor";
    static final String NOTIFY_MULTI_LCEILING = "oracle.kv.multiop.latencyceiling";
    static final String NOTIFY_COMMIT_LAG_THRESHOLD = "oracle.kv.repnode.commitlagthreshold";

    public RepNode(RepNodeParams rnp, MBeanServer server, StorageNode sn) {
        this.server = server;
        this.rnId = rnp.getRepNodeId();
        this.sn = sn;
        this.status = ConfigurableService.ServiceStatus.UNREACHABLE;
        this.resetMetrics();
        this.setParameters(rnp);
        this.register();
    }

    private void resetMetrics() {
        LatencyInfo li;
        this.singleInterval = li = new LatencyInfo(PerfStatType.PUT_IF_ABSENT_INT, System.currentTimeMillis(), System.currentTimeMillis(), new Latency(0));
        this.singleCumulative = li;
        this.multiInterval = li;
        this.multiCumulative = li;
        StatGroup replayStats = new StatGroup("Replay", "The Replay unit applies the incoming replication stream at a Replica. These stats show the load the Replica incurs when processing updates.");
        ReplicatedEnvironmentStats jeRepEnvStats = new ReplicatedEnvironmentStats();
        jeRepEnvStats.setStatGroup(replayStats);
        this.repEnvStats = new RepEnvStats(0L, 0L, jeRepEnvStats);
        this.replicationState = ReplicatedEnvironment.State.UNKNOWN;
    }

    private void register() {
        StringBuffer buf = new StringBuffer("Oracle NoSQL Database");
        buf.append(":type=RepNode");
        buf.append(",id=");
        buf.append(this.getRepNodeId());
        try {
            this.oName = new ObjectName(buf.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception creating JMX ObjectName " + buf.toString(), e);
        }
        try {
            this.server.registerMBean(this, this.oName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception registring MBean " + this.oName.toString(), e);
        }
    }

    public void unregister() {
        if (this.oName != null) {
            try {
                this.server.unregisterMBean(this.oName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception while unregistring MBean " + this.oName.toString(), e);
            }
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{NOTIFY_RN_STATUS_CHANGE}, Notification.class.getName(), "Announce a change in this RepNode's service status"), new MBeanNotificationInfo(new String[]{NOTIFY_SINGLE_TFLOOR}, Notification.class.getName(), "Single-operation throughput floor violation notification."), new MBeanNotificationInfo(new String[]{NOTIFY_SINGLE_LCEILING}, Notification.class.getName(), "Single-operation latency ceiling violation notification."), new MBeanNotificationInfo(new String[]{NOTIFY_MULTI_TFLOOR}, Notification.class.getName(), "Multi-operation throughput floor violation notification."), new MBeanNotificationInfo(new String[]{NOTIFY_MULTI_LCEILING}, Notification.class.getName(), "Multi-operation latency ceiling violation notification."), new MBeanNotificationInfo(new String[]{NOTIFY_COMMIT_LAG_THRESHOLD}, Notification.class.getName(), "Commit lag threshold violation notification.")};
    }

    public void setParameters(RepNodeParams rnp) {
        this.parameters = rnp;
    }

    public synchronized void setPerfStats(StatsPacket packet) {
        this.singleInterval = packet.get(PerfStatType.USER_SINGLE_OP_INT);
        this.singleCumulative = packet.get(PerfStatType.USER_SINGLE_OP_CUM);
        this.multiInterval = packet.get(PerfStatType.USER_MULTI_OP_INT);
        this.multiCumulative = packet.get(PerfStatType.USER_MULTI_OP_CUM);
        this.repEnvStats = packet.getRepEnvStats();
        for (ConciseStats cs : packet.getOtherStats()) {
            if (!(cs instanceof ReplicationState)) continue;
            this.replicationState = ((ReplicationState)cs).getState();
        }
        int ceiling = this.parameters.getLatencyCeiling();
        int floor = this.parameters.getThroughputFloor();
        long lagThreshold = this.parameters.getCommitLagThreshold();
        Notification notification = null;
        if (this.singleInterval.getLatency().getTotalOps() != 0) {
            if (PerfEvent.latencyCeilingExceeded(ceiling, this.singleInterval)) {
                notification = new Notification(NOTIFY_SINGLE_LCEILING, this.oName, this.notifySequence++, System.currentTimeMillis(), "The latency ceiling limit for single operations of " + ceiling + "ms was violated.");
                notification.setUserData(new Float(this.getIntervalLatAvg()));
                this.sendNotification(notification);
                this.sn.sendProxyNotification(notification);
            }
            if (PerfEvent.throughputFloorExceeded(floor, this.singleInterval)) {
                notification = new Notification(NOTIFY_SINGLE_TFLOOR, this.oName, this.notifySequence++, System.currentTimeMillis(), "The throughput floor limit for single operations of " + floor + " ops/sec was violated.");
                notification.setUserData(new Long(this.getIntervalThroughput()));
                this.sendNotification(notification);
                this.sn.sendProxyNotification(notification);
            }
        }
        if (this.multiInterval.getLatency().getTotalOps() != 0) {
            if (PerfEvent.latencyCeilingExceeded(ceiling, this.multiInterval)) {
                notification = new Notification(NOTIFY_MULTI_LCEILING, this.oName, this.notifySequence++, System.currentTimeMillis(), "The latency ceiling limit for multi operations of " + ceiling + "ms was violated.");
                notification.setUserData(new Float(this.getMultiIntervalLatAvg()));
                this.sendNotification(notification);
                this.sn.sendProxyNotification(notification);
            }
            if (PerfEvent.throughputFloorExceeded(floor, this.multiInterval)) {
                notification = new Notification(NOTIFY_MULTI_TFLOOR, this.oName, this.notifySequence++, System.currentTimeMillis(), "The throughput floor limit for multi operations of " + floor + " ops/sec was violated.");
                notification.setUserData(new Long(this.getMultiIntervalThroughput()));
                this.sendNotification(notification);
                this.sn.sendProxyNotification(notification);
            }
        }
        if (PerfEvent.commitLagThresholdExceeded(this.repEnvStats, lagThreshold)) {
            notification = new Notification(NOTIFY_COMMIT_LAG_THRESHOLD, this.oName, this.notifySequence++, System.currentTimeMillis(), "Exceeded commit lag threshold [" + lagThreshold + " ms]");
            notification.setUserData(new Long(this.getCommitLag()));
            this.sendNotification(notification);
            this.sn.sendProxyNotification(notification);
        }
    }

    public synchronized void setServiceStatus(ConfigurableService.ServiceStatus newStatus) {
        if (this.status.equals((Object)newStatus)) {
            return;
        }
        Notification n = new Notification(NOTIFY_RN_STATUS_CHANGE, this.oName, this.notifySequence++, System.currentTimeMillis(), "The service status for RepNode " + this.getRepNodeId() + " changed to " + newStatus.toString() + ".");
        n.setUserData(newStatus.toString());
        this.sendNotification(n);
        this.sn.sendProxyNotification(n);
        this.status = newStatus;
        this.resetMetrics();
    }

    @Override
    public String getRepNodeId() {
        return this.rnId.getFullName();
    }

    @Override
    public String getServiceStatus() {
        return this.status.toString();
    }

    @Override
    public float getIntervalLatAvg() {
        return this.singleInterval.getLatency().getAvg();
    }

    @Override
    public int getIntervalLatMax() {
        return this.singleInterval.getLatency().getMax();
    }

    @Override
    public int getIntervalLatMin() {
        return this.singleInterval.getLatency().getMin();
    }

    @Override
    public int getIntervalPct95() {
        return this.singleInterval.getLatency().get95thPercent();
    }

    @Override
    public int getIntervalPct99() {
        return this.singleInterval.getLatency().get99thPercent();
    }

    @Override
    public int getIntervalTotalOps() {
        return this.singleInterval.getLatency().getTotalOps();
    }

    @Override
    public Date getIntervalEnd() {
        return new Date(this.singleInterval.getEnd());
    }

    @Override
    public Date getIntervalStart() {
        return new Date(this.singleInterval.getStart());
    }

    @Override
    public long getIntervalThroughput() {
        return this.singleInterval.getThroughputPerSec();
    }

    @Override
    public float getCumulativeLatAvg() {
        return this.singleCumulative.getLatency().getAvg();
    }

    @Override
    public int getCumulativeLatMax() {
        return this.singleCumulative.getLatency().getMax();
    }

    @Override
    public int getCumulativeLatMin() {
        return this.singleCumulative.getLatency().getMin();
    }

    @Override
    public int getCumulativePct95() {
        return this.singleCumulative.getLatency().get95thPercent();
    }

    @Override
    public int getCumulativePct99() {
        return this.singleCumulative.getLatency().get99thPercent();
    }

    @Override
    public int getCumulativeTotalOps() {
        return this.singleCumulative.getLatency().getTotalOps();
    }

    @Override
    public Date getCumulativeEnd() {
        return new Date(this.singleCumulative.getEnd());
    }

    @Override
    public Date getCumulativeStart() {
        return new Date(this.singleCumulative.getStart());
    }

    @Override
    public long getCumulativeThroughput() {
        return this.singleCumulative.getThroughputPerSec();
    }

    @Override
    public float getMultiIntervalLatAvg() {
        return this.multiInterval.getLatency().getAvg();
    }

    @Override
    public int getMultiIntervalLatMax() {
        return this.multiInterval.getLatency().getMax();
    }

    @Override
    public int getMultiIntervalLatMin() {
        return this.multiInterval.getLatency().getMin();
    }

    @Override
    public int getMultiIntervalPct95() {
        return this.multiInterval.getLatency().get95thPercent();
    }

    @Override
    public int getMultiIntervalPct99() {
        return this.multiInterval.getLatency().get99thPercent();
    }

    @Override
    public int getMultiIntervalTotalOps() {
        return this.multiInterval.getLatency().getTotalOps();
    }

    @Override
    public int getMultiIntervalTotalRequests() {
        return this.multiInterval.getLatency().getTotalRequests();
    }

    @Override
    public Date getMultiIntervalEnd() {
        return new Date(this.multiInterval.getEnd());
    }

    @Override
    public Date getMultiIntervalStart() {
        return new Date(this.multiInterval.getStart());
    }

    @Override
    public long getMultiIntervalThroughput() {
        return this.multiInterval.getThroughputPerSec();
    }

    @Override
    public float getMultiCumulativeLatAvg() {
        return this.multiCumulative.getLatency().getAvg();
    }

    @Override
    public int getMultiCumulativeLatMax() {
        return this.multiCumulative.getLatency().getMax();
    }

    @Override
    public int getMultiCumulativeLatMin() {
        return this.multiCumulative.getLatency().getMin();
    }

    @Override
    public int getMultiCumulativePct95() {
        return this.multiCumulative.getLatency().get95thPercent();
    }

    @Override
    public int getMultiCumulativePct99() {
        return this.multiCumulative.getLatency().get99thPercent();
    }

    @Override
    public int getMultiCumulativeTotalOps() {
        return this.multiCumulative.getLatency().getTotalOps();
    }

    @Override
    public int getMultiCumulativeTotalRequests() {
        return this.multiCumulative.getLatency().getTotalRequests();
    }

    @Override
    public Date getMultiCumulativeEnd() {
        return new Date(this.multiCumulative.getEnd());
    }

    @Override
    public Date getMultiCumulativeStart() {
        return new Date(this.multiCumulative.getStart());
    }

    @Override
    public long getMultiCumulativeThroughput() {
        return this.multiCumulative.getThroughputPerSec();
    }

    @Override
    public long getCommitLag() {
        ReplicatedEnvironmentStats jeRepStats;
        long avgLag = 0L;
        if (this.repEnvStats != null && (jeRepStats = this.repEnvStats.getStats()) != null) {
            long totalLag = jeRepStats.getReplayTotalCommitLagMs();
            long nCommits = jeRepStats.getNReplayCommits();
            if (totalLag > 0L && nCommits > 0L) {
                avgLag = totalLag / nCommits;
            }
        }
        return avgLag;
    }

    @Override
    public String getConfigProperties() {
        return this.parameters.getConfigProperties();
    }

    @Override
    public String getJavaMiscParams() {
        return this.parameters.getJavaMiscParams();
    }

    @Override
    public String getLoggingConfigProps() {
        return this.parameters.getLoggingConfigProps();
    }

    @Override
    public boolean getCollectEnvStats() {
        return this.parameters.getCollectEnvStats();
    }

    @Override
    public int getCacheSize() {
        return (int)(this.parameters.getJECacheSize() / 0x100000L);
    }

    @Override
    public int getMaxTrackedLatency() {
        return this.parameters.getMaxTrackedLatency();
    }

    @Override
    public int getStatsInterval() {
        return this.parameters.getStatsInterval() / 1000;
    }

    @Override
    public int getHeapMB() {
        return (int)this.parameters.getMaxHeapMB();
    }

    @Override
    public String getMountPoint() {
        return this.parameters.getMountPointString();
    }

    @Override
    public int getLatencyCeiling() {
        return this.parameters.getLatencyCeiling();
    }

    @Override
    public int getThroughputFloor() {
        return this.parameters.getThroughputFloor();
    }

    @Override
    public long getCommitLagThreshold() {
        return this.parameters.getCommitLagThreshold();
    }

    @Override
    public String getReplicationState() {
        return this.replicationState.toString();
    }
}

