/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.mgmt.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.mgmt.AgentInternal;
import oracle.kv.impl.mgmt.jmx.Admin;
import oracle.kv.impl.mgmt.jmx.RepNode;
import oracle.kv.impl.mgmt.jmx.StorageNode;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.sna.ServiceManager;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.ServiceStatusTracker;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.ssl.SSLServerSocketFactory;

public class JmxAgent
extends AgentInternal {
    static final String DOMAIN = "Oracle NoSQL Database";
    public static final String JMX_SSF_NAME = "jmxrmi";
    static final String JMX_CSF_NAME = "jmxrmi";
    private MBeanServer server;
    private JMXConnectorServer connector;
    private StorageNode snMBean;
    private Map<RepNodeId, RepNode> rnMap = new HashMap<RepNodeId, RepNode>();
    private Admin admin;
    private static RMISocketPolicy jmxRMIPolicy;

    public JmxAgent(StorageNodeAgent sna, int pollingPort, String trapHostName, int trapPort, ServiceStatusTracker tracker) {
        super(sna);
        this.server = MBeanServerFactory.createMBeanServer();
        JMXServiceURL url = this.makeUrl();
        try {
            HashMap<String, Object> env = new HashMap<String, Object>();
            RMISocketPolicy.SocketFactoryPair jmxSFP = this.getJMXSFP();
            if (jmxSFP != null) {
                if (jmxSFP.getServerFactory() != null && jmxSFP.getClientFactory() != null && jmxSFP.getServerFactory().getClass() == SSLServerSocketFactory.class) {
                    env.put("jmx.remote.rmi.client.socket.factory", new SslRMIClientSocketFactory());
                }
                if (jmxSFP.getServerFactory() != null) {
                    env.put("jmx.remote.rmi.server.socket.factory", jmxSFP.getServerFactory());
                    if (jmxSFP.getServerFactory().getClass() == SSLServerSocketFactory.class && jmxSFP.getClientFactory() != null) {
                        env.put("com.sun.jndi.rmi.factory.socket", jmxSFP.getClientFactory());
                    }
                }
            }
            this.connector = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.server);
            this.connector.start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error creating JMX connector.", e);
        }
        this.addPlatformMBeans();
        this.snMBean = new StorageNode(this, this.server);
        this.setSnaStatusTracker(tracker);
    }

    public static void setRMISocketPolicy(RMISocketPolicy jmxRMIPolicy) {
        JmxAgent.jmxRMIPolicy = jmxRMIPolicy;
    }

    private RMISocketPolicy.SocketFactoryPair getJMXSFP() {
        if (jmxRMIPolicy == null) {
            return null;
        }
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName("jmxrmi").setCsfName("jmxrmi");
        return jmxRMIPolicy.getBindPair(args);
    }

    @Override
    public boolean checkParametersEqual(int pollp, String traph, int trapp) {
        return true;
    }

    private void addPlatformMBeans() {
        MBeanServer platformServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> beans = platformServer.queryMBeans(null, null);
        for (ObjectInstance oi : beans) {
            try {
                Class<?> c = JmxAgent.getMBeanInterfaceClass(Class.forName(oi.getClassName()));
                if (c == null) {
                    this.sna.getLogger().warning("Unexpected non-compliant platform MBean impl " + oi.getClassName() + " found.  Forgoing proxy creation.");
                    continue;
                }
                if (c.getName().equals("javax.management.MBeanServerDelegateMBean")) continue;
                Object o = ManagementFactory.newPlatformMXBeanProxy(platformServer, oi.getObjectName().toString(), c);
                this.server.registerMBean(o, oi.getObjectName());
            }
            catch (Exception e) {
                this.sna.getLogger().log(Level.WARNING, "Unexpected error creating platform mbean proxy for " + oi.getClassName(), e);
            }
        }
    }

    private static Class<?> getMBeanInterfaceClass(Class<?> c) {
        while (c != null) {
            Class<?>[] interfaces;
            String name = c.getName();
            if (name.endsWith("MBean") || name.endsWith("MXBean")) {
                return c;
            }
            for (Class<?> i : interfaces = c.getInterfaces()) {
                Class<?> j = JmxAgent.getMBeanInterfaceClass(i);
                if (j == null) continue;
                return j;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private JMXServiceURL makeUrl() {
        StringBuffer sb;
        if (!this.restrictPortRange()) {
            sb = new StringBuffer("service:jmx:rmi:///jndi/rmi://");
        } else {
            sb = new StringBuffer("service:jmx:rmi://");
            sb.append(this.getHostname());
            sb.append(":");
            sb.append(this.getFreePort());
            sb.append("/jndi/rmi://");
        }
        sb.append(this.getHostname());
        sb.append(":");
        sb.append(this.getRegistryPort());
        sb.append("/jmxrmi");
        try {
            return new JMXServiceURL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unexpected error constructing JMX service URL (" + sb.toString(), e);
        }
    }

    @Override
    public void addRepNode(RepNodeParams rnp, ServiceManager mgr) throws Exception {
        RepNodeId rnId = rnp.getRepNodeId();
        RepNode rn = new RepNode(rnp, this.server, this.snMBean);
        this.rnMap.put(rnId, rn);
        this.addServiceManagerListener(rnId, mgr);
    }

    @Override
    public void removeRepNode(RepNodeId rnid) {
        this.unexportStatusReceiver(rnid);
        RepNode rn = this.rnMap.get(rnid);
        if (rn != null) {
            rn.unregister();
        }
        this.rnMap.remove(rnid);
    }

    @Override
    public void addAdmin(AdminParams ap, ServiceManager mgr) throws Exception {
        this.admin = new Admin(ap, this.server, this.snMBean);
        this.addAdminServiceManagerListener(mgr);
    }

    @Override
    public void removeAdmin() {
        this.unexportAdminStatusReceiver();
        if (this.admin != null) {
            this.admin.unregister();
        }
        this.admin = null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.snMBean.unregister();
        for (RepNode rn : this.rnMap.values()) {
            rn.unregister();
        }
        this.rnMap.clear();
        if (this.admin != null) {
            this.admin.unregister();
            this.admin = null;
        }
        try {
            this.connector.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MBeanServerFactory.releaseMBeanServer(this.server);
    }

    @Override
    public void updateSNStatus(ServiceStatusChange p, ServiceStatusChange n) {
        this.snMBean.setServiceStatus(n.getStatus());
    }

    @Override
    protected void updateRepNodeStatus(RepNodeId which, ServiceStatusChange newStatus) {
        RepNode rn = this.rnMap.get(which);
        if (rn == null) {
            this.sna.getLogger().warning("Updating service status, RepNode MBean not found for " + which.getFullName());
            return;
        }
        rn.setServiceStatus(newStatus.getStatus());
    }

    @Override
    protected void updateRepNodePerfStats(RepNodeId which, StatsPacket packet) {
        RepNode rn = this.rnMap.get(which);
        if (rn == null) {
            this.sna.getLogger().warning("Updating perf stats, RepNode MBean not found for " + which.getFullName());
            return;
        }
        rn.setPerfStats(packet);
    }

    @Override
    protected void updateRepNodeParameters(RepNodeId which, ParameterMap map) {
        RepNode rn = this.rnMap.get(which);
        if (rn == null) {
            this.sna.getLogger().warning("Updating parameters, RepNode MBean not found for " + which.getFullName());
            return;
        }
        RepNodeParams rnp = new RepNodeParams(map);
        rn.setParameters(rnp);
    }

    @Override
    public void updateAdminParameters(ParameterMap newMap) {
        AdminParams ap = new AdminParams(newMap);
        this.admin.setParameters(ap);
    }

    @Override
    public void updateAdminStatus(ServiceStatusChange newStatus, boolean isMaster) {
        this.admin.setServiceStatus(newStatus.getStatus(), isMaster);
    }
}

