/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.mgmt.jmx;

import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.mgmt.jmx.StorageNode;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.mgmt.jmx.AdminMXBean;

public class Admin
extends NotificationBroadcasterSupport
implements AdminMXBean {
    private AdminId aid;
    private final MBeanServer server;
    private final StorageNode sn;
    private ConfigurableService.ServiceStatus status;
    private AdminParams parameters;
    private boolean isMaster;
    private ObjectName oName;
    long notifySequence = 1L;
    static final String NOTIFY_ADMIN_STATUS_CHANGE = "oracle.kv.admin.status";

    public Admin(AdminParams ap, MBeanServer server, StorageNode sn) {
        this.server = server;
        this.aid = ap == null ? new AdminId(0) : ap.getAdminId();
        this.sn = sn;
        this.status = ConfigurableService.ServiceStatus.UNREACHABLE;
        this.isMaster = false;
        this.setParameters(ap);
        this.register();
    }

    private void register() {
        StringBuffer buf = new StringBuffer("Oracle NoSQL Database");
        buf.append(":type=Admin");
        try {
            this.oName = new ObjectName(buf.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception creating JMX ObjectName " + buf.toString(), e);
        }
        try {
            this.server.registerMBean(this, this.oName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception registring MBean " + this.oName.toString(), e);
        }
    }

    public void unregister() {
        if (this.oName != null) {
            try {
                this.server.unregisterMBean(this.oName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception while unregistring MBean " + this.oName.toString(), e);
            }
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{NOTIFY_ADMIN_STATUS_CHANGE}, Notification.class.getName(), "Announce a change in this Admin's service status")};
    }

    public void setParameters(AdminParams ap) {
        this.parameters = ap;
        if (ap == null || ap.getAdminId().equals(this.aid)) {
            return;
        }
        this.aid = ap.getAdminId();
    }

    public synchronized void setServiceStatus(ConfigurableService.ServiceStatus newStatus, boolean master) {
        if (this.status.equals((Object)newStatus) && master == this.isMaster) {
            return;
        }
        Notification n = new Notification(NOTIFY_ADMIN_STATUS_CHANGE, this.oName, this.notifySequence++, System.currentTimeMillis(), "The service status for Admin " + this.getAdminId() + " changed to " + newStatus.toString() + (master ? " master" : ""));
        n.setUserData(newStatus.toString());
        this.sendNotification(n);
        this.sn.sendProxyNotification(n);
        this.status = newStatus;
        this.isMaster = master;
    }

    @Override
    public int getAdminId() {
        return this.aid.getAdminInstanceId();
    }

    @Override
    public String getServiceStatus() {
        return this.status.toString();
    }

    @Override
    public int getHttpPort() {
        return this.parameters == null ? 0 : this.parameters.getHttpPort();
    }

    @Override
    public int getLogFileLimit() {
        return this.parameters == null ? 0 : this.parameters.getLogFileLimit();
    }

    @Override
    public int getLogFileCount() {
        return this.parameters == null ? 0 : this.parameters.getLogFileCount();
    }

    @Override
    public long getPollPeriodMillis() {
        return this.parameters == null ? 0L : this.parameters.getPollPeriodMillis();
    }

    @Override
    public long getEventExpiryAge() {
        return this.parameters == null ? 0L : this.parameters.getEventExpiryAge();
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }
}

