/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.mgmt;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.mgmt.MgmtAgent;
import oracle.kv.impl.mgmt.MgmtUtil;
import oracle.kv.impl.mgmt.NoOpAgent;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.util.ServiceStatusTracker;

public class MgmtAgentFactory {
    public static MgmtAgent getAgent(StorageNodeAgent sna, StorageNodeParams snp, ServiceStatusTracker tracker) {
        int trapPort;
        String trapHost;
        int pollingPort;
        String mgmtClass;
        Logger logger = sna.getLogger();
        assert (logger != null);
        BootstrapParams bp = sna.getBootstrapParams();
        assert (bp != null);
        if (snp != null) {
            mgmtClass = snp.getMgmtClass();
            pollingPort = snp.getMgmtPollingPort();
            trapHost = snp.getMgmtTrapHost();
            trapPort = snp.getMgmtTrapPort();
        } else {
            mgmtClass = bp.getMgmtClass();
            pollingPort = bp.getMgmtPollingPort();
            trapHost = bp.getMgmtTrapHost();
            trapPort = bp.getMgmtTrapPort();
        }
        assert (mgmtClass != null);
        if (!MgmtUtil.verifyImplClassName(mgmtClass)) {
            throw new IllegalStateException("The class name " + mgmtClass + ", present in the config file, is not allowed.");
        }
        MgmtAgent currentImpl = sna.getMgmtAgent();
        if (currentImpl != null) {
            if (currentImpl.getClass().getName().equals(mgmtClass) && currentImpl.checkParametersEqual(pollingPort, trapHost, trapPort)) {
                currentImpl.setSnaStatusTracker(tracker);
                return currentImpl;
            }
            currentImpl.shutdown();
        }
        try {
            Class<?> c = Class.forName(mgmtClass);
            Constructor<?> ctor = c.getConstructor(StorageNodeAgent.class, Integer.TYPE, String.class, Integer.TYPE, ServiceStatusTracker.class);
            logger.info("Using mgmt class " + mgmtClass);
            return (MgmtAgent)ctor.newInstance(sna, pollingPort, trapHost, trapPort, tracker);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Can't instantiate MgmtAgent class " + mgmtClass, e);
            logger.info("Falling back to mgmt agent NoOpAgent.");
            return new NoOpAgent(sna, pollingPort, trapHost, trapPort, tracker);
        }
    }
}

