/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic.execution;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.kv.impl.diagnostic.LogFileInfo;

public abstract class LogExtractor {
    private String LOG_FOLDER_NAME = "log";
    private String LOG_FILE_NAME_PATTERN = "[0-9]+\\_[0-9]+\\.log$";
    protected String INFO_SEPEARATOR = ";";
    private LogFileInfo.LogFileType logFileType;

    protected abstract void extract(Map<String, List<LogFileInfo>> var1) throws Exception;

    public LogExtractor(LogFileInfo.LogFileType logFileType) {
        this.logFileType = logFileType;
    }

    public void execute(String rootDirectory) throws Exception {
        File logDirectory = this.getLogDirectory(rootDirectory);
        Map<String, List<LogFileInfo>> logFileInfoMap = this.iterateLogFile(logDirectory);
        this.extract(logFileInfoMap);
    }

    private File getLogDirectory(String directory) {
        File[] files;
        File f = new File(directory);
        if (!f.exists()) {
            return null;
        }
        for (File file : files = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return new File(file.getAbsoluteFile(), name).isDirectory();
            }
        })) {
            File logFolder;
            if (file.getName().equals(this.LOG_FOLDER_NAME)) {
                return file;
            }
            if (!file.isDirectory() || (logFolder = this.getLogDirectory(file.getAbsolutePath())) == null) continue;
            return logFolder;
        }
        return null;
    }

    private Map<String, List<LogFileInfo>> iterateLogFile(File logDirectory) {
        HashMap<String, List<LogFileInfo>> logFileMap = new HashMap<String, List<LogFileInfo>>();
        if (logDirectory != null) {
            File[] logFiles;
            for (File f : logFiles = logDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    Pattern p = Pattern.compile((Object)((Object)LogExtractor.this.logFileType) + LogExtractor.this.LOG_FILE_NAME_PATTERN);
                    Matcher matcher = p.matcher(name);
                    return matcher.find();
                }
            })) {
                LogFileInfo logFileInfo = new LogFileInfo(f, this.logFileType);
                ArrayList<LogFileInfo> logFileInfoList = (ArrayList<LogFileInfo>)logFileMap.get(logFileInfo.getNodeName());
                if (logFileInfoList == null) {
                    logFileInfoList = new ArrayList<LogFileInfo>();
                    logFileMap.put(logFileInfo.getNodeName(), logFileInfoList);
                }
                logFileInfoList.add(logFileInfo);
            }
        }
        return logFileMap;
    }
}

