/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class ParametersValidator {
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String BROADCAST_IP = "0.0.0.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean bindPort(InetSocketAddress socketAddress) {
        boolean isFree = true;
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket();
            ss.setReuseAddress(true);
            ss.bind(socketAddress);
            ds = new DatagramSocket(socketAddress);
            ds.setReuseAddress(true);
        }
        catch (IOException e) {
            isFree = false;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    isFree = false;
                }
            }
        }
        return isFree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean bindPort(int port) {
        boolean isFree = true;
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
        }
        catch (IOException e) {
            isFree = false;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    isFree = false;
                }
            }
        }
        return isFree;
    }

    public static String checkPort(String parameterName, int port) {
        try {
            if (ParametersValidator.bindPort(port) && ParametersValidator.bindPort(new InetSocketAddress(InetAddress.getLocalHost().getHostName(), port)) && ParametersValidator.bindPort(new InetSocketAddress(BROADCAST_IP, port)) && ParametersValidator.bindPort(new InetSocketAddress(LOCAL_IP, port))) {
                return null;
            }
            return "Specified " + parameterName + " " + port + " is already in use";
        }
        catch (UnknownHostException unknownHostException) {
            return "Specified " + parameterName + " " + port + " is already in use";
        }
    }

    public static String checkDirectory(String parameterName, String directoryName) {
        File file = new File(directoryName);
        if (file.exists() && file.isDirectory()) {
            return null;
        }
        return "Specified " + parameterName + " " + directoryName + " does not exist";
    }

    public static String checkFile(String parameterName, String directoryName, String fileName) {
        File file = new File(directoryName, fileName);
        if (file.exists() && file.isFile()) {
            return null;
        }
        return "Specified " + parameterName + " " + fileName + " does not exist in " + directoryName;
    }

    public static String checkFile(String parameterName, String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return null;
        }
        return "Specified " + parameterName + " " + filePath + " does not exist";
    }

    public static String checkHostname(String parameterName, String hostname) {
        boolean isReachable = true;
        try {
            InetAddress.getByName(hostname);
        }
        catch (UnknownHostException ex) {
            isReachable = false;
        }
        if (isReachable) {
            return null;
        }
        return "Specified " + parameterName + " " + hostname + " not reachable";
    }

    public static String checkLocalHostname() {
        boolean isResolvable = true;
        try {
            InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            isResolvable = false;
        }
        if (isResolvable) {
            return null;
        }
        return "The local host name could not be resolved into an address";
    }

    public static String checkRangePorts(String parameterName, String rangePorts) {
        StringTokenizer tokenizer = new StringTokenizer(rangePorts, ",");
        int firstHAPort = Integer.parseInt(tokenizer.nextToken());
        int secondHAPort = Integer.parseInt(tokenizer.nextToken());
        for (int i = firstHAPort; i <= secondHAPort; ++i) {
            String retMsg = ParametersValidator.checkPort(parameterName, i);
            if (retMsg == null) continue;
            return retMsg;
        }
        return null;
    }

    public static String checkPositiveInteger(String parameterName, int positiveInteger) {
        if (positiveInteger < 0) {
            return positiveInteger + " is invalid; " + parameterName + " must be >= 0";
        }
        return null;
    }

    public static String checkRangePortsNumber(String parameterName, String rangePorts, int expectedNumberOfPort) {
        StringTokenizer tokenizer = new StringTokenizer(rangePorts, ",");
        int firstHAPort = Integer.parseInt(tokenizer.nextToken());
        int secondHAPort = Integer.parseInt(tokenizer.nextToken());
        if (secondHAPort - firstHAPort + 1 < expectedNumberOfPort) {
            return "Specified " + parameterName + " " + rangePorts + " size is less than the number of nodes " + expectedNumberOfPort;
        }
        return null;
    }

    public static String checkCPUNumber(String parameterName, int cpuNums) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        if (cpuNums > bean.getAvailableProcessors()) {
            return cpuNums + " is invalid; " + parameterName + " must be <= " + bean.getAvailableProcessors() + "(the number of available processors)";
        }
        return null;
    }

    public static String checkMemorySize(String parameterName, int memSize, int capacity) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        Class<?> beanClass = bean.getClass();
        long mem = 0L;
        int availableMem = 0;
        try {
            int cap;
            int intBits;
            int maxInt = Integer.MAX_VALUE;
            Method m = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            m.setAccessible(true);
            mem = (Long)m.invoke((Object)bean, new Object[0]);
            String bits = System.getProperty("sun.arch.data.model");
            if (bits != null && (intBits = Integer.parseInt(bits)) == 32 && mem / (long)(cap = capacity) > Integer.MAX_VALUE) {
                mem = Integer.MAX_VALUE * cap;
            }
        }
        catch (Exception e) {
            mem = 0L;
        }
        availableMem = (int)(mem >> 20);
        if (memSize > availableMem) {
            return memSize + " is invalid; " + parameterName + " must be <= " + availableMem + "(the total available memory)";
        }
        return null;
    }
}

