/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.io.File;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import oracle.kv.impl.diagnostic.LogInfo;

public class LogSectionFileInfo {
    private String fileName;
    private String filePath;
    private Deque<LogInfo> beginLogInfoList = new LinkedList<LogInfo>();

    public LogSectionFileInfo(File file, List<String> timeStampList) {
        this.filePath = file.getAbsolutePath();
        this.fileName = file.getName();
        for (String timeStamp : timeStampList) {
            this.add(timeStamp);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public LogInfo getFirst() {
        if (this.beginLogInfoList.isEmpty()) {
            return null;
        }
        return this.beginLogInfoList.getFirst();
    }

    public LogInfo pop() {
        if (this.beginLogInfoList.isEmpty()) {
            return null;
        }
        return this.beginLogInfoList.pop();
    }

    private void add(String logInfo) {
        this.beginLogInfoList.add(new LogInfo(logInfo));
    }

    public boolean isEmpty() {
        return this.beginLogInfoList.isEmpty();
    }
}

