/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

public class LogInfo {
    private String BLANKSPACE_SEPARATOR = " ";
    private String logItem;
    private String timestampString;
    private Date logTimestamp;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");

    public LogInfo(String logItem) {
        this.logItem = logItem;
        try {
            this.parse();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void parse() throws ParseException {
        String[] dateStr = this.logItem.split(this.BLANKSPACE_SEPARATOR);
        if (dateStr.length >= 3) {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone(dateStr[2]));
            this.logTimestamp = this.dateFormat.parse(dateStr[0] + this.BLANKSPACE_SEPARATOR + dateStr[1]);
            this.timestampString = dateStr[0] + this.BLANKSPACE_SEPARATOR + dateStr[1] + this.BLANKSPACE_SEPARATOR + dateStr[2];
        }
    }

    public Date getTimestamp() {
        return this.logTimestamp;
    }

    public String getTimestampString() {
        return this.timestampString;
    }

    public String toString() {
        return this.logItem;
    }

    public boolean equals(LogInfo logInfo) {
        return this.logItem.equals(logInfo.logItem);
    }

    public static class LogInfoComparator
    implements Comparator<LogInfo> {
        @Override
        public int compare(LogInfo o1, LogInfo o2) {
            if (o1.getTimestamp().after(o2.getTimestamp())) {
                return 1;
            }
            if (o1.getTimestamp().before(o2.getTimestamp())) {
                return -1;
            }
            return 0;
        }
    }
}

