/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.io.File;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFileInfo {
    private String LOG_FILENAME_FORMAT = "([0-9]+)\\_([0-9]+)\\.log$";
    private String RN_LOG_FILENAME_FORMAT = "rg([0-9]+)\\-rn([0-9]+)\\_([0-9]+)\\.log$";
    private int fileSequenceID;
    private File file;
    private int nodeID;
    private LogFileType type;
    private int groupID;

    public LogFileInfo(File file, LogFileType type) {
        this.file = file;
        this.type = type;
        this.fileSequenceID = -1;
        this.nodeID = -1;
        this.groupID = -1;
        this.parse();
    }

    private void parse() {
        Pattern p;
        Matcher matcher;
        if (this.type == LogFileType.RN) {
            Pattern p2 = Pattern.compile(this.RN_LOG_FILENAME_FORMAT);
            Matcher matcher2 = p2.matcher(this.file.getName());
            if (matcher2.find()) {
                this.groupID = Integer.parseInt(matcher2.group(1));
                this.nodeID = Integer.parseInt(matcher2.group(2));
                this.fileSequenceID = Integer.parseInt(matcher2.group(3));
            }
        } else if (this.type != LogFileType.ALL && (matcher = (p = Pattern.compile((Object)((Object)this.type) + this.LOG_FILENAME_FORMAT)).matcher(this.file.getName())).find()) {
            this.nodeID = Integer.parseInt(matcher.group(1));
            this.fileSequenceID = Integer.parseInt(matcher.group(2));
        }
    }

    public int getFileSequenceID() {
        return this.fileSequenceID;
    }

    public String getFilePath() {
        return this.file.getAbsolutePath();
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public String getNodeName() {
        if (this.type == LogFileType.RN) {
            return "rg" + this.groupID + "-" + this.type.toString() + this.nodeID;
        }
        if (this.type == LogFileType.ALL) {
            return "all";
        }
        return this.type.toString() + this.nodeID;
    }

    public static class LogFileInfoComparator
    implements Comparator<LogFileInfo> {
        @Override
        public int compare(LogFileInfo o1, LogFileInfo o2) {
            if (o1.getFileSequenceID() < o2.getFileSequenceID()) {
                return 1;
            }
            if (o1.getFileSequenceID() > o2.getFileSequenceID()) {
                return -1;
            }
            return 0;
        }
    }

    public static enum LogFileType {
        ADMIN("admin"),
        SN("sn"),
        RN("rn"),
        ALL("");

        private String prefixName;

        private LogFileType(String prefixName) {
            this.prefixName = prefixName;
        }

        public String toString() {
            return this.prefixName;
        }
    }
}

