/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.diagnostic.DiagnosticVerifier;

public class JavaVersionVerifier
extends DiagnosticVerifier {
    private final Map<String, JavaVersion> supportedJavaVersionMap = new HashMap<String, JavaVersion>();
    private String installedJavaVendor;
    private JavaVersion installedJavaVersion;
    private String overrideFlag;

    public JavaVersionVerifier() {
        this(false, null);
    }

    public JavaVersionVerifier(boolean returnOnError, String overrideFlag) {
        super(returnOnError);
        this.supportedJavaVersionMap.put("Oracle Corporation", new JavaVersion("1.7.0_51"));
        this.supportedJavaVersionMap.put("IBM Corporation", new JavaVersion("1.7.0"));
        this.installedJavaVendor = System.getProperty("java.vendor");
        this.installedJavaVersion = new JavaVersion(System.getProperty("java.version"));
        this.overrideFlag = overrideFlag;
    }

    @Override
    public boolean doWork() {
        JavaVersion supportedJavaVersion = this.supportedJavaVersionMap.get(this.installedJavaVendor);
        if (supportedJavaVersion == null) {
            this.printMessage(this.installedJavaVendor + " JDK is not supported. " + this.displaySupportedSet());
            return false;
        }
        if (this.installedJavaVersion.compareTo(supportedJavaVersion) < 0) {
            this.printMessage(this.installedJavaVendor + " JDK " + this.installedJavaVersion + " is not supported. " + this.displaySupportedSet());
            if (this.returnOnError) {
                return false;
            }
        }
        return true;
    }

    private String displaySupportedSet() {
        StringBuilder sb = new StringBuilder();
        sb.append("Please use a Java version equal to or newer than the following recommended versions: ");
        boolean first = true;
        for (Map.Entry<String, JavaVersion> e : this.supportedJavaVersionMap.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(e.getKey()).append(" Java ").append(e.getValue());
            if (!first) continue;
            first = false;
        }
        if (this.overrideFlag != null) {
            sb.append(". To override this requirement, use ").append(this.overrideFlag).append(".");
        }
        return sb.toString();
    }

    public void setJKDVersionInfo(String javaVendor, String javaVersion) {
        this.installedJavaVendor = javaVendor;
        this.installedJavaVersion = new JavaVersion(javaVersion);
    }

    public String toString() {
        if (this.installedJavaVendor == null || this.installedJavaVersion == null) {
            return null;
        }
        return "Vendor: " + this.installedJavaVendor + ", version: " + this.installedJavaVersion;
    }

    private class JavaVersion {
        private String javaVersion = null;
        private String VERSION_SEPARATOR = "[^a-zA-Z0-9]+";

        public JavaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
        }

        public int compareTo(JavaVersion comparedVersion) {
            if (this.javaVersion == null && comparedVersion.javaVersion != null) {
                return -1;
            }
            if (this.javaVersion != null && comparedVersion.javaVersion == null) {
                return 1;
            }
            if (this.javaVersion == null && comparedVersion.javaVersion == null) {
                return 0;
            }
            String[] versionArray = this.javaVersion.split(this.VERSION_SEPARATOR);
            String[] comparedVersionArray = comparedVersion.javaVersion.split(this.VERSION_SEPARATOR);
            int comparedLength = Math.min(versionArray.length, comparedVersionArray.length);
            for (int i = 0; i < comparedLength; ++i) {
                int compareNumberVersion;
                int numberVersion;
                if (i == versionArray.length) {
                    return i == comparedVersionArray.length ? 0 : -1;
                }
                if (i == comparedVersionArray.length) {
                    return 1;
                }
                try {
                    numberVersion = Integer.parseInt(versionArray[i]);
                }
                catch (Exception e) {
                    numberVersion = Integer.MAX_VALUE;
                }
                try {
                    compareNumberVersion = Integer.parseInt(comparedVersionArray[i]);
                }
                catch (Exception e) {
                    compareNumberVersion = Integer.MAX_VALUE;
                }
                if (numberVersion > compareNumberVersion) {
                    return 1;
                }
                if (numberVersion < compareNumberVersion) {
                    return -1;
                }
                int compareResult = versionArray[i].compareTo(comparedVersionArray[i]);
                if (compareResult == 0) continue;
                return compareResult;
            }
            return 0;
        }

        public String toString() {
            return this.javaVersion;
        }
    }
}

