/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.diagnostic.SNAInfo;

public class DiagnosticConfigFile {
    private String CONFIG_FILE_NAME = "sn-target-list";
    private String configDir;

    public DiagnosticConfigFile(String configDir) {
        this.configDir = configDir;
    }

    public void add(SNAInfo snaInfo) throws Exception {
        List<SNAInfo> list = this.getAllSNAInfo();
        list.add(snaInfo);
        this.rewrite(list);
    }

    public void addOneSNAInfo(SNAInfo snaInfo) throws Exception {
        File file = new File(this.configDir, this.CONFIG_FILE_NAME);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                throw new Exception("Problem creating " + file + ": " + ex.getMessage());
            }
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, true));
            bw.write(snaInfo.toString());
            bw.newLine();
        }
        catch (Exception ex) {
            throw new Exception("Problem writing file " + file + ": " + ex.getMessage());
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ex) {
                throw new Exception("Problem closing file " + file + ": " + ex.toString());
            }
        }
    }

    public void clear() throws Exception {
        OutputStreamWriter fw = null;
        File file = null;
        try {
            file = new File(this.configDir, this.CONFIG_FILE_NAME);
            if (!file.exists()) {
                return;
            }
            fw = new FileWriter(file);
            fw.close();
        }
        catch (IOException ex) {
            throw new Exception("Problem with file " + file + ": " + ex.getMessage());
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                throw new Exception("Problem closing file " + file + ": " + ex.toString());
            }
        }
    }

    private boolean isDelete(SNAInfo snaInfo, SNAInfo patternSNAInfo) {
        boolean shouldBeDeleted = false;
        if (patternSNAInfo.getStoreName() != null && !patternSNAInfo.getStoreName().isEmpty()) {
            if (!snaInfo.getStoreName().equals(patternSNAInfo.getStoreName())) {
                return false;
            }
            shouldBeDeleted = true;
        }
        if (patternSNAInfo.getStorageNodeName() != null && !patternSNAInfo.getStorageNodeName().isEmpty()) {
            if (!snaInfo.getStorageNodeName().equals(patternSNAInfo.getStorageNodeName())) {
                return false;
            }
            shouldBeDeleted = true;
        }
        if (patternSNAInfo.getHost() != null && !patternSNAInfo.getHost().isEmpty()) {
            if (!snaInfo.getHost().equals(patternSNAInfo.getHost())) {
                return false;
            }
            shouldBeDeleted = true;
        }
        if (patternSNAInfo.getUser() != null && !patternSNAInfo.getUser().isEmpty()) {
            if (!snaInfo.getUser().equals(patternSNAInfo.getUser())) {
                return false;
            }
            shouldBeDeleted = true;
        }
        if (patternSNAInfo.getRootdir() != null && !patternSNAInfo.getRootdir().isEmpty()) {
            if (!snaInfo.getRootdir().equals(patternSNAInfo.getRootdir())) {
                return false;
            }
            shouldBeDeleted = true;
        }
        return shouldBeDeleted;
    }

    public int delete(SNAInfo patternSNAInfo) throws Exception {
        int numberOfDeleted = 0;
        ArrayList<SNAInfo> keepSNAInfoList = new ArrayList<SNAInfo>();
        File file = new File(this.configDir, this.CONFIG_FILE_NAME);
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot find SN target file " + file + ". Please use the diagnostics setup " + "command to create a target list.");
        }
        List<SNAInfo> allSNAInfoList = this.getAllSNAInfo();
        for (SNAInfo snaInfo : allSNAInfoList) {
            if (!this.isDelete(snaInfo, patternSNAInfo)) {
                keepSNAInfoList.add(snaInfo);
                continue;
            }
            ++numberOfDeleted;
        }
        if (numberOfDeleted == 0) {
            return numberOfDeleted;
        }
        this.rewrite(keepSNAInfoList);
        return numberOfDeleted;
    }

    public List<SNAInfo> getAllSNAInfo() throws Exception {
        ArrayList<SNAInfo> snaList = new ArrayList<SNAInfo>();
        BufferedReader br = null;
        File file = new File(this.configDir, this.CONFIG_FILE_NAME);
        try {
            String line;
            try {
                br = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                ArrayList<SNAInfo> arrayList = snaList;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception ex) {
                    throw new Exception("Problem closing file " + file + ": " + ex.toString());
                }
                return arrayList;
            }
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                SNAInfo snaInfo = new SNAInfo(line);
                snaList.add(snaInfo);
            }
            ArrayList<SNAInfo> arrayList = snaList;
            return arrayList;
        }
        catch (Exception ex) {
            throw new Exception("Invalid configuration file " + file + ": " + ex.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception ex) {
                throw new Exception("Problem closing file " + file + ": " + ex.toString());
            }
        }
    }

    public void rewrite(List<SNAInfo> snaInfoList) throws Exception {
        this.clear();
        for (SNAInfo snaInfo : snaInfoList) {
            this.addOneSNAInfo(snaInfo);
        }
    }

    public String getFilePath() {
        File file = new File(this.configDir, this.CONFIG_FILE_NAME);
        return file.getAbsolutePath();
    }

    public void verify() throws Exception {
        File file = new File(this.configDir, this.CONFIG_FILE_NAME);
        HashMap<SNAInfo, Integer> frequencyMap = new HashMap<SNAInfo, Integer>();
        HashMap duplicatedMap = new HashMap();
        boolean isDuplicated = false;
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot find file " + file);
        }
        List<SNAInfo> snaInfoList = this.getAllSNAInfo();
        if (snaInfoList.size() == 0) {
            throw new Exception("\n" + file + " should not be empty. Please specify\n" + "-host, -port or use diagnostics -setup " + "to specify SN targets and populate the file");
        }
        for (SNAInfo checkedSNAInfo : snaInfoList) {
            List<SNAInfo> list;
            Integer frequency = (Integer)frequencyMap.get(checkedSNAInfo);
            if (frequency == null) {
                frequencyMap.put(checkedSNAInfo, 1);
                list = new ArrayList<SNAInfo>();
                list.add(checkedSNAInfo);
                duplicatedMap.put(checkedSNAInfo, list);
                continue;
            }
            frequencyMap.put(checkedSNAInfo, frequency + 1);
            list = (List)duplicatedMap.get(checkedSNAInfo);
            list.add(checkedSNAInfo);
        }
        String duplicatedLines = "";
        for (Map.Entry entry : frequencyMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            isDuplicated = true;
            SNAInfo key = (SNAInfo)entry.getKey();
            List list = (List)duplicatedMap.get(key);
            duplicatedLines = duplicatedLines + "\n";
            for (SNAInfo snaInfo : list) {
                duplicatedLines = duplicatedLines + snaInfo.getSNAInfo() + "\n";
            }
        }
        if (isDuplicated) {
            throw new Exception("Duplicated lines in configuration file: " + duplicatedLines);
        }
    }
}

