/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.diagnostic.Checker;
import oracle.kv.impl.diagnostic.DiagnosticVerifier;
import oracle.kv.impl.diagnostic.ParametersValidator;
import oracle.kv.impl.diagnostic.PortConflictValidator;

public class BootConfigVerifier
extends DiagnosticVerifier {
    private int THREADS_NUM = 4;
    private BootstrapParams parameters;

    public BootConfigVerifier(BootstrapParams parameters, boolean returnOnError) {
        super(returnOnError);
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        ThreadPoolExecutor checkersExecutor = new ThreadPoolExecutor(this.THREADS_NUM, this.THREADS_NUM, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ArrayList<Future<String>> checkResults = new ArrayList<Future<String>>();
        PortChecker portChecker = new PortChecker(this.parameters, this.returnOnError);
        checkResults.add(checkersExecutor.submit(portChecker));
        DirectoryChecker directoryChecker = new DirectoryChecker(this.parameters, this.returnOnError);
        checkResults.add(checkersExecutor.submit(directoryChecker));
        HostChecker hostChecker = new HostChecker(this.parameters, this.returnOnError);
        checkResults.add(checkersExecutor.submit(hostChecker));
        SystemInfoChecker systemInfoChecker = new SystemInfoChecker(this.parameters, this.returnOnError);
        checkResults.add(checkersExecutor.submit(systemInfoChecker));
        try {
            for (Future future : checkResults) {
                try {
                    String retMsg = (String)future.get();
                    if (retMsg == null || retMsg.isEmpty()) continue;
                    this.printMessage(retMsg);
                    if (!this.returnOnError) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (InterruptedException ex) {
                    this.printMessage(ex.getMessage());
                    if (!this.returnOnError) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (ExecutionException ex) {
                    this.printMessage(ex.getMessage());
                    if (!this.returnOnError) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            checkersExecutor.shutdown();
        }
        return true;
    }

    private class SystemInfoChecker
    extends Checker {
        private int cpu_nums;
        private int memory_mb;
        private int capacity;

        public SystemInfoChecker(BootstrapParams parameters, boolean returnImmediate) {
            super(returnImmediate);
            this.cpu_nums = 0;
            this.memory_mb = 0;
            this.capacity = 0;
            this.cpu_nums = parameters.getNumCPUs();
            this.memory_mb = parameters.getMemoryMB();
            this.capacity = parameters.getCapacity();
        }

        @Override
        public String check() throws Exception {
            String retMsg = ParametersValidator.checkPositiveInteger("numCPUs", this.cpu_nums);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkCPUNumber("numCPUs", this.cpu_nums);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkPositiveInteger("memoryMB", this.memory_mb);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkMemorySize("memoryMB", this.memory_mb, this.capacity);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            return this.getMessage();
        }
    }

    private class HostChecker
    extends Checker {
        private String host;
        private String HAHostname;
        private String trapHost;

        public HostChecker(BootstrapParams parameters, boolean returnImmediate) {
            super(returnImmediate);
            this.host = null;
            this.HAHostname = null;
            this.trapHost = null;
            this.host = parameters.getHostname();
            this.HAHostname = parameters.getHAHostname();
            this.trapHost = parameters.getMgmtTrapHost();
        }

        @Override
        public String check() throws Exception {
            String retMsg = ParametersValidator.checkHostname("hostname", this.host);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            if (this.HAHostname != null && !this.HAHostname.isEmpty()) {
                retMsg = ParametersValidator.checkHostname("haHostname", this.HAHostname);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
            }
            if (this.trapHost != null && this.trapHost.isEmpty()) {
                retMsg = ParametersValidator.checkHostname("mgmtTrapHost", this.trapHost);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
            }
            retMsg = ParametersValidator.checkLocalHostname();
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            return this.getMessage();
        }
    }

    private class DirectoryChecker
    extends Checker {
        private String rootDir;
        private List<String> mountPoints;

        public DirectoryChecker(BootstrapParams parameters, boolean returnImmediate) {
            super(returnImmediate);
            this.rootDir = null;
            this.rootDir = parameters.getRootdir();
            this.mountPoints = parameters.getMountPoints();
        }

        @Override
        public String check() throws Exception {
            String retMsg = ParametersValidator.checkDirectory("rootDir", this.rootDir);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            if (this.mountPoints != null && this.mountPoints.size() > 0) {
                for (String mountPoint : this.mountPoints) {
                    retMsg = ParametersValidator.checkDirectory("rnMountPoint", mountPoint);
                    this.aggregateMessage(retMsg);
                    if (!this.shouldStopCheck(retMsg)) continue;
                    return this.getMessage();
                }
            }
            return this.getMessage();
        }
    }

    private class PortChecker
    extends Checker {
        private final int registryPort;
        private final String HAPortRange;
        private final int adminPort;
        private final String servicePortRange;
        private final int trapPort;
        private final int pollPort;
        private final int capacity;
        private final boolean isRunAdmin;

        public PortChecker(BootstrapParams parameters, boolean returnImmediate) {
            super(returnImmediate);
            this.registryPort = parameters.getRegistryPort();
            this.HAPortRange = parameters.getHAPortRange();
            this.adminPort = parameters.getAdminHttpPort();
            this.servicePortRange = parameters.getServicePortRange();
            this.trapPort = parameters.getMgmtTrapPort();
            this.pollPort = parameters.getMgmtPollingPort();
            this.capacity = parameters.getCapacity();
            this.isRunAdmin = parameters.getForceBootstrapAdmin();
        }

        @Override
        public String check() throws Exception {
            PortConflictValidator validator = new PortConflictValidator();
            String retMsg = ParametersValidator.checkPort("registryPort", this.registryPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = validator.check("registryPort", this.registryPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkRangePorts("haPortRange", this.HAPortRange);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = validator.check("haPortRange", this.HAPortRange);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkPositiveInteger("capacity", this.capacity);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            if (this.adminPort != 0) {
                retMsg = ParametersValidator.checkPort("adminHttpPort", this.adminPort);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
                retMsg = validator.check("adminHttpPort", this.adminPort);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
                retMsg = ParametersValidator.checkRangePortsNumber("haPortRange", this.HAPortRange, this.capacity + 1);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
            } else if (this.isRunAdmin) {
                retMsg = ParametersValidator.checkRangePortsNumber("haPortRange", this.HAPortRange, this.capacity + 1);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
            } else {
                retMsg = ParametersValidator.checkRangePortsNumber("haPortRange", this.HAPortRange, this.capacity);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
            }
            if (this.servicePortRange != null && !this.servicePortRange.isEmpty()) {
                retMsg = ParametersValidator.checkRangePorts("servicePortRange", this.servicePortRange);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
                retMsg = validator.check("servicePortRange", this.servicePortRange);
                this.aggregateMessage(retMsg);
                if (this.shouldStopCheck(retMsg)) {
                    return this.getMessage();
                }
            }
            retMsg = ParametersValidator.checkPositiveInteger("mgmtTrapPort", this.trapPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkPort("mgmtTrapPort", this.trapPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = validator.check("mgmtTrapPort", this.trapPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkPositiveInteger("mgmtPollPort", this.pollPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = ParametersValidator.checkPort("mgmtPollPort", this.pollPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            retMsg = validator.check("mgmtPollPort", this.pollPort);
            this.aggregateMessage(retMsg);
            if (this.shouldStopCheck(retMsg)) {
                return this.getMessage();
            }
            return this.getMessage();
        }
    }
}

