/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordBuilder;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.FieldDef;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableJsonUtils
extends JsonUtils {
    static final String DESC = "comment";
    static final String NULLABLE = "nullable";
    static final String MIN = "min";
    static final String MAX = "max";
    static final String MIN_INCL = "min_inclusive";
    static final String MAX_INCL = "max_inclusive";
    static final String COLLECTION = "collection";
    static final String ENUM_NAME = "enum_name";
    static final String NAME = "name";
    static final String TYPE = "type";
    static final String DEFAULT = "default";
    static final String ENUM_VALS = "symbols";
    static final String FIELDS = "fields";
    static final String NULL = "null";
    static final String RECORD = "record";
    static final String ENUM = "enum";
    static final String ARRAY = "array";
    static final String MAP = "map";
    static final String INT = "int";
    static final String LONG = "long";
    static final String STRING = "string";
    static final String BOOLEAN = "boolean";
    static final String DOUBLE = "double";
    static final String FLOAT = "float";
    static final String BYTES = "bytes";
    static final String FIXED = "fixed";
    static final String FIXED_SIZE = "size";
    private static final DecoderFactory decoderFactory = DecoderFactory.get();
    private static final EncoderFactory encoderFactory = EncoderFactory.get();

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    static JsonFactory getJsonFactory() {
        return mapper.getJsonFactory();
    }

    static DecoderFactory getDecoderFactory() {
        return decoderFactory;
    }

    static EncoderFactory getEncoderFactory() {
        return encoderFactory;
    }

    public static String encodeBase64(byte[] buf) {
        return mapper.convertValue((Object)buf, String.class);
    }

    public static byte[] decodeBase64(String str) {
        return mapper.convertValue((Object)str, byte[].class);
    }

    static FieldDefImpl fromJson(ObjectNode node) {
        String nameString = TableJsonUtils.getStringFromNode(node, NAME, false);
        String descString = TableJsonUtils.getStringFromNode(node, DESC, false);
        String minString = TableJsonUtils.getStringFromNode(node, MIN, false);
        String maxString = TableJsonUtils.getStringFromNode(node, MAX, false);
        String sizeString = TableJsonUtils.getStringFromNode(node, FIXED_SIZE, false);
        String typeString = TableJsonUtils.getStringFromNode(node, TYPE, true);
        FieldDef.Type type = FieldDef.Type.valueOf(typeString);
        switch (type) {
            case INTEGER: {
                return new IntegerDefImpl(descString, minString != null ? Integer.valueOf(minString) : null, maxString != null ? Integer.valueOf(maxString) : null);
            }
            case LONG: {
                return new LongDefImpl(descString, minString != null ? Long.valueOf(minString) : null, maxString != null ? Long.valueOf(maxString) : null);
            }
            case DOUBLE: {
                return new DoubleDefImpl(descString, minString != null ? Double.valueOf(minString) : null, maxString != null ? Double.valueOf(maxString) : null);
            }
            case FLOAT: {
                return new FloatDefImpl(descString, minString != null ? Float.valueOf(minString) : null, maxString != null ? Float.valueOf(maxString) : null);
            }
            case STRING: {
                Boolean minInclusive = TableJsonUtils.getBoolean(node, MIN_INCL);
                Boolean maxInclusive = TableJsonUtils.getBoolean(node, MAX_INCL);
                return new StringDefImpl(descString, minString, maxString, minInclusive, maxInclusive);
            }
            case BINARY: {
                return new BinaryDefImpl(descString);
            }
            case FIXED_BINARY: {
                int size = sizeString == null ? 0 : Integer.valueOf(sizeString);
                return new FixedBinaryDefImpl(nameString, size, descString);
            }
            case BOOLEAN: {
                return new BooleanDefImpl(descString);
            }
            case ARRAY: 
            case MAP: {
                JsonNode jnode = node.get(COLLECTION);
                if (jnode == null) {
                    throw new IllegalArgumentException("Map and Array require a collection object");
                }
                FieldDefImpl elementDef = TableJsonUtils.fromJson((ObjectNode)jnode);
                if (type == FieldDef.Type.ARRAY) {
                    return new ArrayDefImpl(elementDef, descString);
                }
                return new MapDefImpl(elementDef, descString);
            }
            case RECORD: {
                JsonNode fieldsNode = node.get(FIELDS);
                if (fieldsNode == null) {
                    throw new IllegalArgumentException("Record is missing fields object");
                }
                RecordBuilder builder = TableBuilder.createRecordBuilder(nameString, descString);
                ArrayNode arrayNode = (ArrayNode)fieldsNode;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode o = (ObjectNode)arrayNode.get(i);
                    String fieldName = TableJsonUtils.getStringFromNode(o, NAME, true);
                    builder.fromJson(fieldName, o);
                }
                try {
                    return (FieldDefImpl)((Object)builder.build());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to build record from JSON, field name: " + nameString);
                }
            }
            case ENUM: {
                JsonNode valuesNode = node.get(ENUM_VALS);
                if (valuesNode == null) {
                    throw new IllegalArgumentException("Enumeration is missing values");
                }
                ArrayNode arrayNode = (ArrayNode)valuesNode;
                String enumName = TableJsonUtils.getStringFromNode(node, ENUM_NAME, true);
                String[] values = new String[arrayNode.size()];
                for (int i = 0; i < arrayNode.size(); ++i) {
                    values[i] = arrayNode.get(i).asText();
                }
                return new EnumDefImpl(enumName, values, descString);
            }
        }
        throw new IllegalArgumentException("Cannot construct FieldDef type from JSON: " + (Object)((Object)type));
    }

    static void indexFromJsonNode(ObjectNode node, TableImpl table) {
        ArrayNode fields = (ArrayNode)node.get(FIELDS);
        ArrayList<String> fieldStrings = new ArrayList<String>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            fieldStrings.add(fields.get(i).asText());
        }
        String name = TableJsonUtils.getStringFromNode(node, NAME, true);
        String desc = TableJsonUtils.getStringFromNode(node, DESC, false);
        table.addIndex(new IndexImpl(name, table, fieldStrings, desc));
    }

    protected static TableImpl fromJsonString(String jsonString, TableImpl parent) {
        JsonNode rootNode = null;
        try {
            rootNode = TableJsonUtils.getObjectMapper().readTree(jsonString);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException parsing Json: " + ioe);
        }
        TableBuilder tb = TableBuilder.createTableBuilder(rootNode.get(NAME).asText(), rootNode.get(DESC).asText(), parent, true);
        tb.primaryKey(TableJsonUtils.makeListFromArray(rootNode, "primaryKey"));
        if (parent == null) {
            tb.shardKey(TableJsonUtils.makeListFromArray(rootNode, "shardKey"));
        }
        if (rootNode.get("r2compat") != null) {
            tb.setR2compat(true);
        }
        ArrayNode arrayNode = (ArrayNode)rootNode.get(FIELDS);
        for (int i = 0; i < arrayNode.size(); ++i) {
            ObjectNode node = (ObjectNode)arrayNode.get(i);
            String fieldName = TableJsonUtils.getStringFromNode(node, NAME, true);
            if (parent != null && parent.isKeyComponent(fieldName)) continue;
            tb.fromJson(fieldName, node);
        }
        TableImpl newTable = tb.buildTable();
        if (rootNode.get("indexes") != null) {
            arrayNode = (ArrayNode)rootNode.get("indexes");
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode node = (ObjectNode)arrayNode.get(i);
                TableJsonUtils.indexFromJsonNode(node, newTable);
            }
        }
        return newTable;
    }

    private static List<String> makeListFromArray(JsonNode node, String fieldName) {
        ArrayNode arrayNode = (ArrayNode)node.get(fieldName);
        ArrayList<String> keyList = new ArrayList<String>(arrayNode.size());
        for (int i = 0; i < arrayNode.size(); ++i) {
            keyList.add(i, arrayNode.get(i).asText());
        }
        return keyList;
    }

    private static String getStringFromNode(ObjectNode node, String name, boolean required) {
        JsonNode jnode = node.get(name);
        if (jnode != null) {
            return jnode.asText();
        }
        if (required) {
            throw new IllegalArgumentException("Missing required node in JSON table representation: " + name);
        }
        return null;
    }
}

