/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;

public class IndexKeyImpl
extends RecordValueImpl
implements IndexKey {
    private static final long serialVersionUID = 1L;
    final IndexImpl index;

    IndexKeyImpl(IndexImpl index) {
        super(new RecordDefImpl(index.getTableImpl().getName(), index.getTableImpl().getFieldMap()));
        this.index = index;
    }

    private IndexKeyImpl(IndexKeyImpl other) {
        super(other);
        this.index = other.index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public IndexKeyImpl clone() {
        return new IndexKeyImpl(this);
    }

    @Override
    FieldDefImpl validateNameAndType(String name, FieldDef.Type type) {
        if (!this.index.containsField(name)) {
            throw new IllegalArgumentException("Field is not part of Index: " + name);
        }
        FieldDef ft = this.getDefinition(name);
        if (ft == null) {
            throw new IllegalArgumentException("No such field in record: " + name);
        }
        if (ft.getType() != type && (ft.getType() != FieldDef.Type.MAP || type != FieldDef.Type.STRING)) {
            throw new IllegalArgumentException("Incorrect type for field " + name + ", type is " + (Object)((Object)type) + ", expected " + (Object)((Object)ft.getType()));
        }
        return (FieldDefImpl)ft;
    }

    @Override
    public IndexKey asIndexKey() {
        return this;
    }

    @Override
    public boolean isIndexKey() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            return other instanceof IndexKeyImpl;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    int getNumFields() {
        return this.index.getFieldsInternal().size();
    }

    @Override
    FieldDef getField(String fieldName) {
        FieldDef def = this.getDefinition().getField(fieldName);
        if (def != null && this.index.containsField(fieldName)) {
            return def;
        }
        return null;
    }

    @Override
    FieldMapEntry getFieldMapEntry(String fieldName) {
        FieldMapEntry fme = this.getDefinition().getFieldMapEntry(fieldName, false);
        if (fme != null && this.index.containsField(fieldName)) {
            return fme;
        }
        return null;
    }

    @Override
    public List<String> getFields() {
        return this.index.getFields();
    }

    @Override
    protected List<String> getFieldsInternal() {
        List<IndexImpl.IndexField> indexFields = this.index.getIndexFields();
        ArrayList<String> list = new ArrayList<String>(indexFields.size());
        for (IndexImpl.IndexField indexField : indexFields) {
            list.add(indexField.getComponents().get(0));
        }
        return list;
    }

    @Override
    public IndexKey putNull(String name) {
        throw new IllegalArgumentException("IndexKey may not contain null values");
    }

    @Override
    public RecordValueImpl putRecord(String fieldName) {
        RecordValueImpl record = super.putRecord(fieldName);
        record.setIndex(this.index);
        return record;
    }

    @Override
    public MapValueImpl putMap(String fieldName) {
        MapValueImpl map = super.putMap(fieldName);
        map.setIndex(this.index);
        return map;
    }

    @Override
    public ArrayValueImpl putArray(String fieldName) {
        ArrayValueImpl array = super.putArray(fieldName);
        array.setIndex(this.index);
        return array;
    }

    public int getKeySize() {
        return this.index.serializeIndexKey(this).length;
    }

    TableImpl getTable() {
        return this.index.getTableImpl();
    }

    FieldValue putComplex(String fieldName, FieldDef.Type type, FieldValue value) {
        return this.putComplex(this.index.createIndexField(fieldName), type, (Object)value);
    }

    public FieldValue putComplexField(String fieldName, FieldValue value) {
        return this.putComplex(fieldName, value.getType(), value);
    }

    public FieldDefImpl findFieldDefinition(String fieldName) {
        FieldDefImpl def = this.index.findIndexField(this.index.createIndexField(fieldName));
        if (def == null) {
            throw new IllegalArgumentException("Field does not exist in the index: " + fieldName);
        }
        return def;
    }

    @Override
    void validate() {
        int numFound = 0;
        int i = 0;
        for (IndexImpl.IndexField field : this.index.getIndexFields()) {
            FieldValueImpl val = this.getComplex(field);
            if (val != null) {
                if (i != numFound) {
                    throw new IllegalArgumentException("IndexKey is missing fields more significant than field: " + field);
                }
                if (val.isNull()) {
                    throw new IllegalArgumentException("Field value is null, which is invalid for IndexKey: " + field);
                }
                if (val.isArray() && val.asArray().size() != 1) {
                    throw new IllegalArgumentException("Arrays used in index keys must contain a single element: " + this);
                }
                ++numFound;
            }
            ++i;
        }
        if (numFound != this.numValues()) {
            throw new IllegalArgumentException("IndexKey contains a field that is not part of the Index");
        }
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof IndexKeyImpl) {
            IndexKeyImpl otherImpl = (IndexKeyImpl)other;
            if (!this.getDefinition().equals(otherImpl.getDefinition())) {
                throw new IllegalArgumentException("Cannot compare IndexKeys with different definitions");
            }
            return this.compare(otherImpl);
        }
        throw new ClassCastException("Object is not an RecordValue");
    }

    private int compare(IndexKeyImpl other) {
        FieldMap fieldMap = this.getDefinition().getFieldMap();
        for (String fieldName : this.index.getFieldsInternal()) {
            FieldValueImpl val = this.getComplex(new TableImpl.TableField(fieldMap, fieldName));
            FieldValueImpl otherVal = other.getComplex(new TableImpl.TableField(fieldMap, fieldName));
            if (val != null) {
                if (otherVal == null) {
                    return 1;
                }
                int comp = val.compareTo(otherVal);
                if (comp == 0) continue;
                return comp;
            }
            if (otherVal == null) continue;
            return -1;
        }
        return 0;
    }

    public IndexImpl getIndexImpl() {
        return this.index;
    }

    boolean isComplete() {
        return this.size() == this.getNumFields();
    }

    public boolean incrementIndexKey() {
        IndexImpl.IndexField ifield;
        FieldValue[] values = new FieldValue[this.index.numFields()];
        int fieldIndex = 0;
        List<IndexImpl.IndexField> indexFields = this.index.getIndexFields();
        for (IndexImpl.IndexField field : indexFields) {
            values[fieldIndex] = this.getComplex(field);
            if (values[fieldIndex] == null || values[fieldIndex].isNull()) break;
            ++fieldIndex;
        }
        assert (fieldIndex > 0);
        FieldValueImpl fvi = ((FieldValueImpl)values[--fieldIndex]).getNextValue();
        while (fvi == null) {
            fvi = ((FieldValueImpl)values[fieldIndex]).getMinimumValue();
            ifield = indexFields.get(fieldIndex);
            if (ifield.isMapKey()) {
                this.clearMap(ifield);
            }
            this.putComplex(indexFields.get(fieldIndex), fvi.getType(), (Object)fvi);
            if (--fieldIndex >= 0) {
                fvi = ((FieldValueImpl)values[fieldIndex]).getNextValue();
                continue;
            }
            return false;
        }
        assert (fvi != null && fieldIndex >= 0);
        ifield = indexFields.get(fieldIndex);
        if (ifield.isMapKey()) {
            this.clearMap(ifield);
        }
        this.putComplex(indexFields.get(fieldIndex), fvi.getType(), (Object)fvi);
        return true;
    }

    private void clearMap(IndexImpl.IndexField indexField) {
        FieldValueImpl fv = this.getComplex(indexField.getMultiKeyField());
        if (fv == null || !fv.isMap()) {
            throw new IllegalStateException("Did not find a map in IndexKey in path: " + indexField);
        }
        ((MapValueImpl)fv).clearMap();
    }
}

