/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordValue;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;

@Persistent(version=1)
class ArrayValueImpl
extends ComplexValueImpl
implements ArrayValue {
    private static final long serialVersionUID = 1L;
    private final ArrayList<FieldValue> array;

    ArrayValueImpl(ArrayDef field) {
        super(field);
        this.array = new ArrayList();
    }

    private ArrayValueImpl() {
        super(null);
        this.array = null;
    }

    @Override
    public ArrayDef getDefinition() {
        return (ArrayDef)super.getDefinition();
    }

    @Override
    public FieldValue get(int index) {
        return this.array.get(index);
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public List<FieldValue> toList() {
        return Collections.unmodifiableList(this.array);
    }

    @Override
    public ArrayValue add(FieldValue value) {
        this.validate(value.getType());
        this.array.add(value);
        return this;
    }

    @Override
    public ArrayValue add(int index, FieldValue value) {
        this.validate(value.getType());
        this.array.add(index, value);
        return this;
    }

    @Override
    public ArrayValue set(int index, FieldValue value) {
        this.validate(value.getType());
        this.array.add(index, value);
        return this;
    }

    @Override
    public ArrayValue add(int value) {
        this.validate(FieldDef.Type.INTEGER);
        this.add(this.getElement().createInteger(value));
        return this;
    }

    @Override
    public ArrayValue add(int[] values) {
        this.validate(FieldDef.Type.INTEGER);
        FieldDef def = this.getElement();
        for (int i : values) {
            this.add(def.createInteger(i));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, int value) {
        this.validate(FieldDef.Type.INTEGER);
        this.add(index, this.getElement().createInteger(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, int value) {
        this.validate(FieldDef.Type.INTEGER);
        this.set(index, this.getElement().createInteger(value));
        return this;
    }

    @Override
    public ArrayValue add(long value) {
        this.validate(FieldDef.Type.LONG);
        this.add(this.getElement().createLong(value));
        return this;
    }

    @Override
    public ArrayValue add(long[] values) {
        this.validate(FieldDef.Type.LONG);
        FieldDef def = this.getElement();
        for (long l : values) {
            this.add(def.createLong(l));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, long value) {
        this.validate(FieldDef.Type.LONG);
        this.add(index, this.getElement().createLong(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, long value) {
        this.validate(FieldDef.Type.LONG);
        this.set(index, this.getElement().createLong(value));
        return this;
    }

    @Override
    public ArrayValue add(String value) {
        this.validate(FieldDef.Type.STRING);
        this.add(this.getElement().createString(value));
        return this;
    }

    @Override
    public ArrayValue add(String[] values) {
        this.validate(FieldDef.Type.STRING);
        FieldDef def = this.getElement();
        for (String s : values) {
            this.add(def.createString(s));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, String value) {
        this.validate(FieldDef.Type.STRING);
        this.add(index, this.getElement().createString(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, String value) {
        this.validate(FieldDef.Type.STRING);
        this.set(index, this.getElement().createString(value));
        return this;
    }

    @Override
    public ArrayValue add(double value) {
        this.validate(FieldDef.Type.DOUBLE);
        this.add(this.getElement().createDouble(value));
        return this;
    }

    @Override
    public ArrayValue add(double[] values) {
        this.validate(FieldDef.Type.DOUBLE);
        FieldDef def = this.getElement();
        for (double d : values) {
            this.add(def.createDouble(d));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, double value) {
        this.validate(FieldDef.Type.DOUBLE);
        this.add(index, this.getElement().createDouble(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, double value) {
        this.validate(FieldDef.Type.DOUBLE);
        this.set(index, this.getElement().createDouble(value));
        return this;
    }

    @Override
    public ArrayValue add(float value) {
        this.validate(FieldDef.Type.FLOAT);
        this.add(this.getElement().createFloat(value));
        return this;
    }

    @Override
    public ArrayValue add(float[] values) {
        this.validate(FieldDef.Type.FLOAT);
        FieldDef def = this.getElement();
        for (float d : values) {
            this.add(def.createFloat(d));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, float value) {
        this.validate(FieldDef.Type.FLOAT);
        this.add(index, this.getElement().createFloat(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, float value) {
        this.validate(FieldDef.Type.FLOAT);
        this.set(index, this.getElement().createFloat(value));
        return this;
    }

    @Override
    public ArrayValue add(boolean value) {
        this.validate(FieldDef.Type.BOOLEAN);
        this.add(this.getElement().createBoolean(value));
        return this;
    }

    @Override
    public ArrayValue add(boolean[] values) {
        this.validate(FieldDef.Type.BOOLEAN);
        FieldDef def = this.getElement();
        for (boolean b : values) {
            this.add(def.createBoolean(b));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, boolean value) {
        this.validate(FieldDef.Type.BOOLEAN);
        this.add(index, this.getElement().createBoolean(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, boolean value) {
        this.validate(FieldDef.Type.BOOLEAN);
        this.set(index, this.getElement().createBoolean(value));
        return this;
    }

    @Override
    public ArrayValue add(byte[] value) {
        this.validate(FieldDef.Type.BINARY);
        this.add(this.getElement().createBinary(value));
        return this;
    }

    @Override
    public ArrayValue add(byte[][] values) {
        this.validate(FieldDef.Type.BINARY);
        FieldDef def = this.getElement();
        for (byte[] b : values) {
            this.add(def.createBinary(b));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, byte[] value) {
        this.validate(FieldDef.Type.BINARY);
        this.add(index, this.getElement().createBinary(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, byte[] value) {
        this.validate(FieldDef.Type.BINARY);
        this.set(index, this.getElement().createBinary(value));
        return this;
    }

    @Override
    public ArrayValue addFixed(byte[] value) {
        this.validate(FieldDef.Type.FIXED_BINARY);
        this.add(this.getElement().createFixedBinary(value));
        return this;
    }

    @Override
    public ArrayValue addFixed(byte[][] values) {
        this.validate(FieldDef.Type.FIXED_BINARY);
        FieldDef def = this.getElement();
        for (byte[] b : values) {
            this.add(def.createFixedBinary(b));
        }
        return this;
    }

    @Override
    public ArrayValue addFixed(int index, byte[] value) {
        this.validate(FieldDef.Type.FIXED_BINARY);
        this.add(index, this.getElement().createFixedBinary(value));
        return this;
    }

    @Override
    public ArrayValue setFixed(int index, byte[] value) {
        this.validate(FieldDef.Type.FIXED_BINARY);
        this.set(index, this.getElement().createFixedBinary(value));
        return this;
    }

    @Override
    public ArrayValue addEnum(String value) {
        this.validate(FieldDef.Type.ENUM);
        this.add(this.getElement().createEnum(value));
        return this;
    }

    @Override
    public ArrayValue addEnum(String[] values) {
        this.validate(FieldDef.Type.ENUM);
        FieldDef def = this.getElement();
        for (String s : values) {
            this.add(def.createEnum(s));
        }
        return this;
    }

    @Override
    public ArrayValue addEnum(int index, String value) {
        this.validate(FieldDef.Type.ENUM);
        this.add(index, this.getElement().createEnum(value));
        return this;
    }

    @Override
    public ArrayValue setEnum(int index, String value) {
        this.validate(FieldDef.Type.ENUM);
        this.set(index, this.getElement().createEnum(value));
        return this;
    }

    ArrayValue addEnum(int value) {
        this.validate(FieldDef.Type.ENUM);
        this.add(((EnumDefImpl)this.getElement()).createEnum(value));
        return this;
    }

    @Override
    public RecordValue setRecord(int index) {
        this.validate(FieldDef.Type.RECORD);
        RecordValue val = this.getElement().createRecord();
        this.array.set(index, val);
        return val;
    }

    @Override
    public RecordValueImpl addRecord() {
        this.validate(FieldDef.Type.RECORD);
        RecordValue val = this.getElement().createRecord();
        this.array.add(val);
        return (RecordValueImpl)val;
    }

    @Override
    public RecordValue addRecord(int index) {
        this.validate(FieldDef.Type.RECORD);
        RecordValue val = this.getElement().createRecord();
        this.array.add(index, val);
        return val;
    }

    @Override
    public MapValue setMap(int index) {
        this.validate(FieldDef.Type.MAP);
        MapValue val = this.getElement().createMap();
        this.array.set(index, val);
        return val;
    }

    @Override
    public MapValueImpl addMap() {
        this.validate(FieldDef.Type.MAP);
        MapValue val = this.getElement().createMap();
        this.array.add(val);
        return (MapValueImpl)val;
    }

    @Override
    public MapValue addMap(int index) {
        this.validate(FieldDef.Type.MAP);
        MapValue val = this.getElement().createMap();
        this.array.add(index, val);
        return val;
    }

    @Override
    public ArrayValue setArray(int index) {
        this.validate(FieldDef.Type.ARRAY);
        ArrayValue val = this.getElement().createArray();
        this.array.set(index, val);
        return val;
    }

    @Override
    public ArrayValueImpl addArray() {
        this.validate(FieldDef.Type.ARRAY);
        ArrayValue val = this.getElement().createArray();
        this.array.add(val);
        return (ArrayValueImpl)val;
    }

    @Override
    public ArrayValue addArray(int index) {
        this.validate(FieldDef.Type.ARRAY);
        ArrayValue val = this.getElement().createArray();
        this.array.add(index, val);
        return val;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayValue asArray() {
        return this;
    }

    @Override
    public FieldValueImpl getNextValue() {
        if (this.size() != 1) {
            throw new IllegalArgumentException("Array values used in ranges must contain only one element");
        }
        ArrayValueImpl newArray = new ArrayValueImpl(this.getDefinition());
        FieldValueImpl fvi = ((FieldValueImpl)this.get(0)).getNextValue();
        newArray.add(fvi);
        return newArray;
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        if (this.size() != 1) {
            throw new IllegalArgumentException("Array values used in ranges must contain only one element");
        }
        ArrayValueImpl newArray = new ArrayValueImpl(this.getDefinition());
        FieldValueImpl fvi = ((FieldValueImpl)this.get(0)).getMinimumValue();
        newArray.add(fvi);
        return newArray;
    }

    public boolean equals(Object other) {
        if (other instanceof ArrayValueImpl) {
            ArrayValueImpl otherValue = (ArrayValueImpl)other;
            if (this == otherValue) {
                return true;
            }
            if (this.size() == otherValue.size() && this.getElement().equals(otherValue.getElement()) && this.getDefinition().equals(otherValue.getDefinition())) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).equals(otherValue.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = this.size();
        for (FieldValue val : this.array) {
            code += val.hashCode();
        }
        return code;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof ArrayValueImpl) {
            ArrayValueImpl otherImpl = (ArrayValueImpl)other;
            if (!this.getDefinition().equals(otherImpl.getDefinition())) {
                throw new IllegalArgumentException("Cannot compare ArrayValues with different definitions");
            }
            for (int i = 0; i < this.size(); ++i) {
                FieldValueImpl val = (FieldValueImpl)this.get(i);
                if (otherImpl.size() < i + 1) {
                    return 1;
                }
                FieldValueImpl otherVal = (FieldValueImpl)otherImpl.get(i);
                if (val != null) {
                    if (otherVal == null) {
                        return 1;
                    }
                    int comp = val.compareTo(otherVal);
                    if (comp == 0) continue;
                    return comp;
                }
                if (otherVal == null) continue;
                return -1;
            }
            return 0;
        }
        throw new ClassCastException("Object is not an ArrayValue");
    }

    @Override
    public ArrayValueImpl clone() {
        ArrayValueImpl newArray = new ArrayValueImpl(this.getDefinition());
        for (FieldValue val : this.array) {
            newArray.add(val.clone());
        }
        return newArray;
    }

    @Override
    public JsonNode toJsonNode() {
        ArrayNode node = JsonNodeFactory.instance.arrayNode();
        for (FieldValue value : this.array) {
            node.add(((FieldValueImpl)value).toJsonNode());
        }
        return node;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append('[');
        for (int i = 0; i < this.array.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            FieldValueImpl value = (FieldValueImpl)this.array.get(i);
            value.toStringBuilder(sb);
        }
        sb.append(']');
    }

    @Override
    Object toAvroValue(Schema schema) {
        Schema valueSchema = ArrayValueImpl.getElementSchema(schema);
        ArrayList<Object> values = new ArrayList<Object>(this.size());
        for (FieldValue value : this.array) {
            values.add(((FieldValueImpl)value).toAvroValue(valueSchema));
        }
        return values;
    }

    static ArrayValueImpl fromAvroValue(FieldDef def, Object o, Schema schema) {
        Collection coll = (Collection)o;
        ArrayValueImpl array = new ArrayValueImpl((ArrayDef)def);
        for (Object value : coll) {
            array.add(FieldValueImpl.fromAvroValue(((ArrayDef)def).getElement(), value, ArrayValueImpl.getElementSchema(schema)));
        }
        return array;
    }

    @Override
    void addJsonFields(JsonParser jp, boolean isIndexKey, String fieldName, boolean exact) {
        try {
            FieldDef element = this.getElement();
            JsonToken t = jp.getCurrentToken();
            if (t == null) {
                return;
            }
            assert (t == JsonToken.START_ARRAY);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                if (jp.getCurrentToken() == JsonToken.VALUE_NULL) {
                    throw new IllegalArgumentException("Invalid null value in JSON input for array");
                }
                switch (element.getType()) {
                    case INTEGER: {
                        this.add(jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        this.add(jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        this.add(jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        this.add(jp.getFloatValue());
                        break;
                    }
                    case STRING: {
                        this.add(jp.getText());
                        break;
                    }
                    case BINARY: {
                        this.add(jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        this.addFixed(jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        this.add(jp.getBooleanValue());
                        break;
                    }
                    case ARRAY: {
                        ArrayValueImpl array1 = this.addArray();
                        array1.addJsonFields(jp, isIndexKey, null, exact);
                        break;
                    }
                    case MAP: {
                        MapValueImpl map = this.addMap();
                        map.addJsonFields(jp, isIndexKey, null, exact);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl record = this.addRecord();
                        record.addJsonFields(jp, isIndexKey, null, exact);
                        break;
                    }
                    case ENUM: {
                        this.addEnum(jp.getText());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
    }

    private static Schema getElementSchema(Schema schema) {
        return ArrayValueImpl.getUnionSchema(schema, Schema.Type.ARRAY).getElementType();
    }

    private FieldDef getElement() {
        return this.getDefinition().getElement();
    }

    private void validate(FieldDef.Type type) {
        if (!this.getElement().isType(type)) {
            throw new IllegalArgumentException("Incorrect type for array");
        }
    }

    @Override
    int numValues() {
        if (this.array.isEmpty()) {
            return 1;
        }
        int num = 0;
        for (FieldValue v : this.array) {
            num += ((FieldValueImpl)v).numValues();
        }
        return num;
    }

    @Override
    FieldValueImpl findFieldValue(ListIterator<String> fieldPath, int arrayIndex) {
        FieldValueImpl fv;
        if (arrayIndex == -1 && this.size() != 1) {
            throw new IllegalArgumentException("Array values used in index keys must contain a single element");
        }
        if (arrayIndex == -1) {
            arrayIndex = 0;
        }
        if ((fv = (FieldValueImpl)this.get(arrayIndex)) == null) {
            return null;
        }
        return fv.findFieldValue(fieldPath, arrayIndex);
    }

    @Override
    FieldValueImpl putComplex(ListIterator<String> fieldPath, FieldDef.Type type, Object value) {
        ComplexValueImpl val = null;
        if (this.array.isEmpty()) {
            val = ArrayValueImpl.createComplexValue(this.getElement());
            this.add(val);
        } else if (this.size() == 1 && this.get(0) instanceof ComplexValueImpl) {
            val = (ComplexValueImpl)this.get(0);
        } else {
            throw new IllegalArgumentException("Invalid attempt to put a complex element in an array.  Size must be 1 and the element must be complex.  Array contents: " + this);
        }
        val.putComplex(fieldPath, type, value);
        return this;
    }

    @Override
    protected void validateIndexField(String fieldName) {
        throw new IllegalStateException("validateIndexField called on an array, field name is " + fieldName);
    }
}

