/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.topo.PartitionId;

public class PutIfVersion
extends Put {
    private final Version matchVersion;

    public PutIfVersion(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, Version matchVersion) {
        this(keyBytes, value, prevValChoice, matchVersion, 0L);
    }

    public PutIfVersion(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, Version matchVersion, long tableId) {
        super(InternalOperation.OpCode.PUT_IF_VERSION, keyBytes, value, prevValChoice, tableId);
        this.matchVersion = matchVersion;
    }

    PutIfVersion(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.PUT_IF_VERSION, in, serialVersion);
        this.matchVersion = new Version(in, serialVersion);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.matchVersion.writeFastExternal(out, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        this.verifyDataAccess(operationHandler, this.getTableId());
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.getReturnValueVersionChoice());
        Version newVersion = operationHandler.putIfVersion(txn, partitionId, this.getKeyBytes(), this.getValueBytes(), this.matchVersion, prevVal);
        return new Result.PutResult(this.getOpCode(), prevVal.getValueVersion(), newVersion);
    }

    @Override
    public String toString() {
        return super.toString() + " MatchVersion: " + this.matchVersion;
    }
}

