/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.ChunkEncapsulatingInputStream;
import oracle.kv.impl.api.lob.ChunkKeysIterator;
import oracle.kv.impl.api.lob.DeleteOperation;
import oracle.kv.impl.api.lob.Operation;

public abstract class WriteOperation
extends Operation {
    protected static final Durability CHUNK_DURABILITY = new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE);
    protected final Durability lobDurability;
    protected final InputStream lobStream;
    private static long testVerificationByteCount = -1L;

    WriteOperation(KVStoreImpl kvsImpl, Key appLobKey, InputStream lobStream, Durability durability, long chunkTimeout, TimeUnit timeoutUnit) {
        super(kvsImpl, appLobKey, chunkTimeout, timeoutUnit);
        if (lobStream instanceof BufferedInputStream) {
            this.lobStream = lobStream;
        } else if (lobStream != null) {
            this.lobStream = new BufferedInputStream(lobStream);
        } else {
            if (!(this instanceof DeleteOperation)) {
                throw new IllegalArgumentException("expected non-null lobStream argument");
            }
            this.lobStream = null;
        }
        this.lobDurability = durability == null ? kvsImpl.getDefaultDurability() : durability;
    }

    protected Version updateMetadata(Version version) {
        ReturnValueVersion prevValueVersion;
        Value propsArray = this.lobProps.serialize();
        Version storedVersion = this.kvsImpl.putIfVersion(this.internalLOBKey, propsArray, version, prevValueVersion = new ReturnValueVersion(ReturnValueVersion.Choice.VERSION), this.lobDurability, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (storedVersion == null) {
            if (prevValueVersion.getVersion() == null) {
                throw new ConcurrentModificationException("LOB was deleted: " + this.internalLOBKey);
            }
            throw new ConcurrentModificationException("LOB was updated concurrently");
        }
        return storedVersion;
    }

    private void putChunk(Key chunkKey, byte[] chunk, int actualSize, boolean replace, Durability chunkDurability) {
        if (actualSize != this.chunkSize) {
            byte[] smallerChunk = new byte[actualSize];
            System.arraycopy(chunk, 0, smallerChunk, 0, actualSize);
            chunk = smallerChunk;
        }
        Value chunkValue = Value.createValue(chunk);
        if (replace) {
            Version version = this.kvsImpl.putIfPresent(chunkKey, chunkValue, null, chunkDurability, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
            if (version == null) {
                throw new ConcurrentModificationException("Expected  to find chunk " + chunkKey + " but it was missing. ");
            }
        } else {
            Version version = this.kvsImpl.putIfAbsent(chunkKey, chunkValue, null, chunkDurability, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
            if (version == null) {
                throw new ConcurrentModificationException("Chunk " + chunkKey + " was already associated with the key: " + chunkKey.toString());
            }
        }
    }

    protected Version putChunks(long startByte, byte[] chunkPrefix, Version metadataVersion) throws IOException {
        if (chunkPrefix == null != (startByte % (long)this.chunkSize == 0L)) {
            throw new IllegalStateException("start byte:" + startByte + " chunk size:" + this.chunkSize + " inconsistent with prefix chunk:" + chunkPrefix);
        }
        if (this.lobSize < 0L || this.numChunks < 0L) {
            throw new IllegalStateException("lobSize:" + this.lobSize + " numChunks:" + this.numChunks);
        }
        byte[] chunk = new byte[this.chunkSize];
        boolean initialReplacePut = false;
        int currentSize = 0;
        if (chunkPrefix != null) {
            currentSize = chunkPrefix.length;
            this.lobSize -= (long)currentSize;
            --this.numChunks;
            System.arraycopy(chunkPrefix, 0, chunk, 0, currentSize);
            initialReplacePut = true;
        }
        ChunkKeysIterator chunkKeys = this.getChunkKeysByteRangeIterator(startByte, Long.MAX_VALUE);
        block0: while (true) {
            int readBytes = -1;
            while (currentSize < this.chunkSize) {
                readBytes = this.lobStream.read(chunk, currentSize, this.chunkSize - currentSize);
                if (readBytes == -1) {
                    if (currentSize <= 0) break block0;
                    break;
                }
                currentSize += readBytes;
            }
            Key chunkKey = chunkKeys.next();
            Durability chunkDurability = readBytes == -1 || chunkKeys.getChunkId() == (long)this.chunksPerPartition ? this.lobDurability : CHUNK_DURABILITY;
            this.putChunk(chunkKey, chunk, currentSize, initialReplacePut, chunkDurability);
            ++this.numChunks;
            if (chunkKeys.getChunkId() == 1L) {
                metadataVersion = this.checkpointSuperChunkId(chunkKeys.getSuperChunkId(), metadataVersion);
            }
            this.lobSize += (long)currentSize;
            currentSize = 0;
            initialReplacePut = false;
        }
        return metadataVersion;
    }

    private Version checkpointSuperChunkId(long superChunkId, Version metadataVersion) {
        if (this.lobProps.getNumChunks() != null || this.lobProps.getLOBSize() != null) {
            throw new IllegalStateException("Inconsistent lob props for metadata checkpoint:" + this.lobProps.toString());
        }
        this.lobProps.setLastSuperChunkId(superChunkId);
        return this.updateMetadata(metadataVersion);
    }

    protected ValueVersion setupForResume(Version metadataVersion) throws IOException {
        this.numChunks = this.computeNumChunks();
        if (this.numChunks == 0L) {
            this.lobSize = 0L;
            return null;
        }
        ValueVersion lastChunkVV = this.getLastChunk();
        int lastChunkLength = lastChunkVV == null ? 0 : lastChunkVV.getValue().getValue().length;
        this.lobSize = (this.numChunks - 1L) * (long)this.chunkSize + (long)lastChunkLength;
        this.verifyTrailingBytes(metadataVersion);
        return lastChunkVV;
    }

    private long computeNumChunks() {
        long lastSCId;
        long lastCId;
        Long storedLastSCId = this.lobProps.getLastSuperChunkId();
        if (storedLastSCId == null) {
            storedLastSCId = 1L;
        }
        if ((lastCId = this.findLastChunkInSuperChunk(lastSCId = storedLastSCId + 1L)) == -1L && (lastCId = this.findLastChunkInSuperChunk(--lastSCId)) == -1L) {
            if (lastSCId == 1L) {
                return 0L;
            }
            String msg = "Expected at least one chunk for " + lastSCId + " Delete the LOB and retry.";
            throw new IllegalStateException(msg);
        }
        return (lastSCId - 1L) * (long)this.chunksPerPartition + lastCId;
    }

    private long findLastChunkInSuperChunk(long superChunkId) {
        Key lastSCKey = this.chunkKeyFactory.createSuperChunkKey(this.internalLOBKey, superChunkId);
        long chunkId = -1L;
        Iterator<Key> i = this.kvsImpl.multiGetKeysIterator(Direction.FORWARD, this.chunksPerPartition, lastSCKey, new KeyRange("", false, null, false), Depth.CHILDREN_ONLY);
        while (i.hasNext()) {
            chunkId = Math.max(chunkId, (long)this.chunkKeyFactory.getChunkId(i.next()));
        }
        return chunkId;
    }

    protected ValueVersion getLastChunk() {
        if (this.numChunks < 0L) {
            throw new IllegalStateException("Chunk count is unknown:" + this.numChunks);
        }
        if (this.numChunks == 0L) {
            return null;
        }
        long superChunkId = (this.numChunks - 1L) / (long)this.chunksPerPartition + 1L;
        long chunkId = (this.numChunks - 1L) % (long)this.chunksPerPartition + 1L;
        Key lastChunkKey = this.chunkKeyFactory.create(this.internalLOBKey, superChunkId, chunkId);
        return this.kvsImpl.get(lastChunkKey, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTrailingBytes(Version metadataVersion) throws IOException {
        long verificationByteCount = this.getVerificationByteCount();
        long chunkStreamPos = this.lobSize - verificationByteCount;
        long lobStreamPos = this.positionLobStream(chunkStreamPos);
        if (verificationByteCount == 0L) {
            return;
        }
        ChunkEncapsulatingInputStream verStream = new ChunkEncapsulatingInputStream(this, this.lobSize, metadataVersion);
        try {
            int chunkStreamByte;
            long skipBytes = verStream.skip(chunkStreamPos);
            if (skipBytes != chunkStreamPos) {
                throw new IllegalStateException("Requested skip bytes: " + chunkStreamPos + " actual skip bytes:" + skipBytes);
            }
            while ((chunkStreamByte = verStream.read()) != -1) {
                ++lobStreamPos;
                ++chunkStreamPos;
                int lobStreamByte = this.lobStream.read();
                if (lobStreamByte == -1) {
                    String msg = "Premature EOF on LOB stream at byte: " + lobStreamPos + " chunk stream at:" + verStream;
                    throw new IllegalArgumentException(msg);
                }
                if (chunkStreamByte == lobStreamByte) continue;
                String msg = "LOB stream inconsistent with stored LOB contents.  Byte mismatch. Stream byte position: " + lobStreamPos + " LOB byte position:" + chunkStreamPos + " app stream byte: " + lobStreamByte + " lob byte: " + chunkStreamByte + " lob stream: " + verStream;
                throw new IllegalArgumentException(msg);
            }
        }
        finally {
            verStream.close();
        }
    }

    protected long positionLobStream(long chunkStreamPos) throws IOException {
        long bytesSkipped = WriteOperation.skipInput(this.lobStream, chunkStreamPos);
        if (chunkStreamPos != bytesSkipped) {
            throw new IllegalArgumentException("The LOB input stream did not skip the requested number of bytes. Bytes skipped:" + bytesSkipped + " Requested:" + chunkStreamPos);
        }
        return chunkStreamPos;
    }

    protected long getVerificationByteCount() {
        long verificationByteCount = testVerificationByteCount >= 0L ? testVerificationByteCount : this.kvsImpl.getDefaultLOBVerificationBytes();
        return Math.min(this.lobSize, verificationByteCount);
    }

    public static void setTestVerificationByteCount(long testVerificationByteCount) {
        WriteOperation.testVerificationByteCount = testVerificationByteCount;
    }

    public static void revertTestVerificationByteCount() {
        testVerificationByteCount = -1L;
    }
}

