/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.je.utilint.VLSN;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.impl.api.StatusChanges;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;

public class Response
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private RepNodeId repNodeId;
    private VLSN vlsn;
    private Result result;
    private TopologyInfo topoInfo;
    private StatusChanges statusChanges;
    private short serialVersion;

    public Response(RepNodeId repNodeId, VLSN vlsn, Result result, TopologyInfo topoInfo, StatusChanges statusChanges, short serialVersion) {
        this.repNodeId = repNodeId;
        this.vlsn = vlsn;
        this.result = result;
        this.topoInfo = topoInfo;
        this.statusChanges = statusChanges;
        this.serialVersion = serialVersion;
    }

    public Response() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serialVersion = in.readShort();
        this.repNodeId = (RepNodeId)ResourceId.readFastExternal(in, this.serialVersion);
        this.vlsn = new VLSN(in.readLong());
        this.result = Result.readFastExternal(in, this.serialVersion);
        this.statusChanges = (StatusChanges)in.readObject();
        this.topoInfo = (TopologyInfo)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.serialVersion);
        this.repNodeId.writeFastExternal(out, this.serialVersion);
        out.writeLong(this.vlsn.getSequence());
        this.result.writeFastExternal(out, this.serialVersion);
        out.writeObject(this.statusChanges);
        out.writeObject(this.topoInfo);
    }

    void setSerialVersion(short serialVersion) {
        this.serialVersion = serialVersion;
    }

    public short getSerialVersion() {
        return this.serialVersion;
    }

    public Result getResult() {
        return this.result;
    }

    public TopologyInfo getTopoInfo() {
        return this.topoInfo;
    }

    public StatusChanges getStatusChanges() {
        return this.statusChanges;
    }

    public VLSN getVLSN() {
        return this.vlsn;
    }

    public RepNodeId getRespondingRN() {
        return this.repNodeId;
    }

    public void setStatusChanges(StatusChanges statusChanges) {
        this.statusChanges = statusChanges;
    }

    public void setTopoInfo(TopologyInfo topoInfo) {
        this.topoInfo = topoInfo;
    }
}

