/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.kv.impl.admin.webapp.shared.Describable;
import oracle.kv.impl.admin.webapp.shared.FieldDesc;
import oracle.kv.impl.admin.webapp.shared.PlanDTO;

public class PlanDTO
implements IsSerializable,
Describable {
    public static final int PLAN_HISTORY_SIZE = 20;
    int id;
    String name;
    State state;
    Date createTime;
    List<PlanRun> history = null;

    public PlanDTO(String name) {
        this.name = name;
        this.id = -1;
        this.state = null;
        this.createTime = null;
    }

    public PlanDTO(int id, String name, State state, Date createTime) {
        this(name);
        this.id = id;
        this.state = state;
        this.createTime = createTime;
        this.history = new ArrayList();
    }

    public PlanDTO() {
    }

    public String getTitle() {
        return "Plan " + Integer.toString(this.id);
    }

    public List<FieldDesc> getDescriptions(boolean showHidden) {
        ArrayList<FieldDesc> fields = new ArrayList<FieldDesc>();
        if (this.id != -1) {
            fields.add(new FieldDesc("id", this.id));
        }
        if (this.name != null) {
            fields.add(new FieldDesc("name", this.name));
        }
        if (this.state != null) {
            fields.add(new FieldDesc("state", this.state.toString()));
        }
        if (this.createTime != null) {
            fields.add(new FieldDesc("createTime", this.createTime));
        }
        if (this.history != null && this.history.size() > 0) {
            FieldDesc title = new FieldDesc("Execution History");
            title.designateAsSectionTitle();
            fields.add(title);
            for (PlanRun pr : this.history) {
                fields.addAll(pr.getDescriptions(showHidden));
            }
        }
        return fields;
    }

    public void applyDescriptions(List<FieldDesc> fields) {
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void addHistoryItem(PlanRun h) {
        this.history.add(h);
    }
}

