/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.kv.impl.admin.webapp.shared.Describable;
import oracle.kv.impl.admin.webapp.shared.FieldDesc;
import oracle.kv.impl.admin.webapp.shared.PerfEventDTO;

public class PerfEventDTO
implements IsSerializable,
Describable {
    private int groupId;
    private int nodeNum;
    private LatencyMeasurement interval;
    private LatencyMeasurement cumulative;
    private boolean needsAlert;

    public PerfEventDTO() {
    }

    public PerfEventDTO(int groupId, int nodeNum, LatencyMeasurement interval, LatencyMeasurement cumulative, boolean needsAlert) {
        this.groupId = groupId;
        this.nodeNum = nodeNum;
        this.interval = interval;
        this.cumulative = cumulative;
        this.needsAlert = needsAlert;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    public LatencyMeasurement getInterval() {
        return this.interval;
    }

    public LatencyMeasurement getCumulative() {
        return this.cumulative;
    }

    public boolean needsAlert() {
        return this.needsAlert;
    }

    public long getChangeTime() {
        return this.interval.getEndMillis();
    }

    public String[] briefIntervalSummary() {
        float avg = this.interval.getAvg();
        int avgInt = (int)avg;
        int avgFrac = (int)((avg - (float)avgInt) * 100.0f);
        String avgStr = Integer.toString(avgInt) + "." + Integer.toString(avgFrac);
        int pct95 = this.interval.getPercent95();
        return new String[]{avgStr + " ms", pct95 <= 0 ? "-" : pct95 + " ms", this.interval.getThroughputPerSec() + " ops/sec"};
    }

    public List<FieldDesc> getDescriptions(boolean showHidden) {
        ArrayList<FieldDesc> fields = new ArrayList<FieldDesc>();
        fields.add(new FieldDesc("needsAlert", this.needsAlert));
        fields.add(new FieldDesc("observationTime", new Date(this.interval.getEndMillis()).toString()));
        FieldDesc sectionTitle = new FieldDesc("Interval Latency Measurement");
        sectionTitle.designateAsSectionTitle();
        fields.add(sectionTitle);
        fields.addAll(this.interval.getDescriptions(showHidden));
        sectionTitle = new FieldDesc("Cumulative Latency Measurement");
        sectionTitle.designateAsSectionTitle();
        fields.add(sectionTitle);
        fields.addAll(this.cumulative.getDescriptions(showHidden));
        return fields;
    }

    public String getTitle() {
        return "Performance detail for Repnode " + this.groupId + "," + this.nodeNum;
    }

    public void applyDescriptions(List<FieldDesc> fields) {
    }
}

