/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.UnexpectedException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.utilint.Latency;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.criticalevent.CriticalEvent;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.param.StorageNodePool;
import oracle.kv.impl.admin.plan.ChangeAdminParamsPlan;
import oracle.kv.impl.admin.plan.ChangeAllParamsPlan;
import oracle.kv.impl.admin.plan.ChangeParamsPlan;
import oracle.kv.impl.admin.plan.ChangeSNParamsPlan;
import oracle.kv.impl.admin.plan.DeployAdminPlan;
import oracle.kv.impl.admin.plan.DeployDatacenterPlan;
import oracle.kv.impl.admin.plan.DeploySNPlan;
import oracle.kv.impl.admin.plan.DeployStorePlan;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.ExecutionState;
import oracle.kv.impl.admin.plan.MigrateSNPlan;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.PlanStateChange;
import oracle.kv.impl.admin.plan.RemoveSNPlan;
import oracle.kv.impl.admin.plan.StartAllRepNodesPlan;
import oracle.kv.impl.admin.plan.StartRepNodesPlan;
import oracle.kv.impl.admin.plan.StopAllRepNodesPlan;
import oracle.kv.impl.admin.plan.StopRepNodesPlan;
import oracle.kv.impl.admin.plan.task.DeployAdmin;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.webapp.server.AdminUIExceptionHelper;
import oracle.kv.impl.admin.webapp.server.AdminUIServiceImpl;
import oracle.kv.impl.admin.webapp.shared.AdminUIException;
import oracle.kv.impl.admin.webapp.shared.AdminUIService;
import oracle.kv.impl.admin.webapp.shared.NotMasterException;
import oracle.kv.impl.admin.webapp.shared.PerfEventDTO;
import oracle.kv.impl.admin.webapp.shared.PlanDTO;
import oracle.kv.impl.admin.webapp.shared.StatusEventDTO;
import oracle.kv.impl.admin.webapp.shared.TopologyDTO;
import oracle.kv.impl.admin.webapp.shared.UpdateInfo;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterMap;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepGroupMap;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.StorageNodeMap;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdminUIServiceImpl
extends RemoteServiceServlet
implements AdminUIService {
    private static final long serialVersionUID = 1L;
    private final String eol = System.getProperty("line.separator");
    CommandServiceAPI aservice;
    List<AllEventListener> listeners;
    private static final int LONG_TIMEOUT_MS = 60000;
    private static final int POLLING_INTERVAL_MS = 10000;
    private static final String STARTTIME_ATTR_NAME = "oracle.kv.startTime";
    private static final String TRACKER_HANDLER_ATTR_NAME = "oracle.kv.trackerListener";
    private static final String CONTINUATION_ATTR_NAME = "continuation";
    private static final String LASTACTIVITY_ATTR_NAME = "lastActivity";
    private static final int CLIENT_TIMEOUT_MS = 60000;
    private static final String PAYLOAD = "oracle.kv.impl.admin.payload";

    public void init() {
        this.aservice = (CommandServiceAPI)this.getServletContext().getAttribute("AdminService");
        this.listeners = new LinkedList();
    }

    public void destroy() {
        for (AllEventListener listener : this.listeners) {
            listener.unregisterAll();
        }
    }

    private Logger getLogger() {
        return (Logger)this.getServletContext().getAttribute("AdminLogger");
    }

    public String isConfigured() throws AdminUIException, NotMasterException {
        String store = null;
        try {
            store = this.aservice.getStoreName();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (store != null) {
            try {
                this.checkMasterState();
            }
            catch (Exception e) {
                AdminUIExceptionHelper.rethrow((String)"in isConfigured", (Exception)e);
            }
        }
        return store;
    }

    public String configure(String kvsName, String dcName, int repFactor) throws AdminUIException, NotMasterException {
        try {
            this.requireNotConfigured();
            this.aservice.configure(kvsName);
            this.aservice.createAndExecuteConfigurationPlan(kvsName, dcName, repFactor);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"in configure", (Exception)e);
        }
        return kvsName;
    }

    public TopologyDTO getTopology() throws AdminUIException, NotMasterException {
        TopologyDTO dto = new TopologyDTO();
        try {
            ServiceChange se;
            this.requireConfigured();
            Topology t = this.aservice.getTopology();
            Parameters p = this.aservice.getParameters();
            Map<ResourceId, ServiceChange> statusMap = this.aservice.getStatusMap();
            Map<ResourceId, PerfEvent> perfMap = this.aservice.getPerfMap();
            DatacenterMap dcMap = t.getDatacenterMap();
            for (Datacenter dc : dcMap.getAll()) {
                DatacenterId dcid = (DatacenterId)dc.getResourceId();
                DatacenterType dct = dc.getDatacenterType();
                dto.addDatacenter(dcid.getDatacenterId(), dc.getName(), dc.getRepFactor(), dct.toString());
            }
            StorageNodeMap snMap = t.getStorageNodeMap();
            for (StorageNode sn : snMap.getAll()) {
                StorageNodeId snid = (StorageNodeId)sn.getResourceId();
                StorageNodeParams snp = p.get(snid);
                TopologyDTO.StorageNode tsn = dto.addStorageNode(this.makeStorageNodeMap(snp, sn.getDatacenterId().getDatacenterId()));
                se = statusMap.get(snid);
                if (se == null) continue;
                tsn.setStatusEvent((StatusEventDTO)new StatusEventDTO.StorageNodeStatusEvent(snid.getStorageNodeId(), se.getChangeTime(), AdminUIServiceImpl.translateServiceStatus((ConfigurableService.ServiceStatus)se.getStatus())));
            }
            RepGroupMap rgMap = t.getRepGroupMap();
            for (RepGroup rg : rgMap.getAll()) {
                dto.addRepGroup(((RepGroupId)rg.getResourceId()).getGroupId());
                for (RepNode rn : rg.getRepNodes()) {
                    PerfEvent pe;
                    RepNodeId rnid = (RepNodeId)rn.getResourceId();
                    RepNodeParams rnp = p.get(rnid);
                    TopologyDTO.RepNode trn = dto.addRepNode(rnid.getGroupId(), rnid.getNodeNum(), this.makeRepNodeMap(rnp));
                    ServiceChange se2 = statusMap.get(rnid);
                    if (se2 != null) {
                        trn.setStatusEvent((StatusEventDTO)new StatusEventDTO.RepNodeStatusEvent(rnid.getGroupId(), rnid.getNodeNum(), se2.getChangeTime(), AdminUIServiceImpl.translateServiceStatus((ConfigurableService.ServiceStatus)se2.getStatus())));
                    }
                    if ((pe = perfMap.get(rnid)) == null) continue;
                    LatencyInfo interval = pe.getSingleInt();
                    Latency iLat = interval.getLatency();
                    LatencyInfo cumulative = pe.getSingleCum();
                    Latency cLat = cumulative.getLatency();
                    trn.setPerfEvent(new PerfEventDTO(rnid.getGroupId(), rnid.getNodeNum(), new PerfEventDTO.LatencyMeasurement(interval.getStart(), interval.getEnd(), iLat.getMin(), iLat.getMax(), iLat.getAvg(), iLat.getTotalOps(), iLat.getTotalRequests(), iLat.get95thPercent(), iLat.get99thPercent()), new PerfEventDTO.LatencyMeasurement(cumulative.getStart(), cumulative.getEnd(), cLat.getMin(), cLat.getMax(), cLat.getAvg(), cLat.getTotalOps(), cLat.getTotalRequests(), cLat.get95thPercent(), cLat.get99thPercent()), pe.needsAlert()));
                }
            }
            for (AdminId aid : p.getAdminIds()) {
                AdminParams ap = p.get(aid);
                TopologyDTO.Admin ta = dto.addAdmin(this.makeAdminMap(ap, aid.getAdminInstanceId()));
                se = statusMap.get(aid);
                if (se == null) continue;
                ta.setStatusEvent((StatusEventDTO)new StatusEventDTO.AdminStatusEvent(aid.getAdminInstanceId(), se.getChangeTime(), AdminUIServiceImpl.translateServiceStatus((ConfigurableService.ServiceStatus)se.getStatus())));
            }
            dto.setPolicy(this.makePolicyMap(p));
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"in getTopology", (Exception)e);
        }
        return dto;
    }

    private TopologyDTO.ParameterMap makePolicyMap(Parameters p) {
        TopologyDTO.ParameterMap tmap = new TopologyDTO.ParameterMap();
        Set<Map.Entry<String, Parameter>> params = p.getPolicies().entrySet();
        for (Map.Entry<String, Parameter> entry : params) {
            ParameterState state = ParameterState.lookup(entry.getKey());
            if (state == null) {
                this.getLogger().warning("ParameterMap lookup failed for key " + entry.getKey());
                continue;
            }
            if (!state.getPolicyState()) continue;
            tmap.put(entry.getKey(), entry.getValue().asString());
        }
        return tmap;
    }

    private ParameterMap makeParameterMap(String name, String type, TopologyDTO.ParameterMap map) {
        ParameterMap retMap = new ParameterMap(name, type);
        Set params = map.entrySet();
        for (Map.Entry entry : params) {
            retMap.setParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return retMap;
    }

    private TopologyDTO.ParameterMap makeAdminMap(AdminParams ap, int id) {
        TopologyDTO.ParameterMap tmap = this.makeMap(ap.getMap(), ParameterState.Info.ADMIN);
        tmap.put("adminId", Integer.toString(id));
        return tmap;
    }

    private TopologyDTO.ParameterMap makeRepNodeMap(RepNodeParams rnp) {
        TopologyDTO.ParameterMap tmap = this.makeMap(rnp.getMap(), ParameterState.Info.REPNODE);
        return tmap;
    }

    private TopologyDTO.ParameterMap makeStorageNodeMap(StorageNodeParams snp, int dcid) {
        TopologyDTO.ParameterMap tmap = this.makeMap(snp.getMap(), ParameterState.Info.SNA);
        tmap.put("datacenterId", Integer.toString(dcid));
        return tmap;
    }

    private TopologyDTO.ParameterMap makeMap(ParameterMap map, ParameterState.Info info) {
        TopologyDTO.ParameterMap tmap = new TopologyDTO.ParameterMap();
        Set<Map.Entry<String, Parameter>> params = map.entrySet();
        for (Map.Entry<String, Parameter> entry : params) {
            ParameterState state = ParameterState.lookup(entry.getKey());
            if (state == null) {
                this.getLogger().warning("ParameterMap lookup failed for key " + entry.getKey());
                continue;
            }
            if (!state.appliesTo(info)) continue;
            tmap.put(entry.getKey(), entry.getValue().asString());
        }
        return tmap;
    }

    public List<PlanDTO> getRecentPlans(int howMany) throws AdminUIException, NotMasterException {
        return this.assembleRecentPlanHistory(howMany);
    }

    public List<PlanDTO> approvePlan(int planId) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.approvePlan(planId);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"approvePlan", (Exception)e);
        }
        return this.assembleRecentPlanHistory(20);
    }

    public List<PlanDTO> executePlan(int planId) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.executePlan(planId, false);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"executePlan", (Exception)e);
        }
        return this.assembleRecentPlanHistory(20);
    }

    public List<PlanDTO> cancelPlan(int planId) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.cancelPlan(planId);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"cancelPlan", (Exception)e);
        }
        return this.assembleRecentPlanHistory(20);
    }

    public List<PlanDTO> interruptPlan(int planId) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.interruptPlan(planId);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"interruptPlan", (Exception)e);
        }
        return this.assembleRecentPlanHistory(20);
    }

    public List<PlanDTO> retryPlan(int planId) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.executePlan(planId, false);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"retryPlan", (Exception)e);
        }
        return this.assembleRecentPlanHistory(20);
    }

    public List<String> getStorageNodePoolNames() throws AdminUIException, NotMasterException {
        ArrayList<String> names = null;
        try {
            this.requireConfigured();
            Parameters p = this.aservice.getParameters();
            names = new ArrayList<String>(p.getStorageNodePoolNames());
            Collections.sort(names);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"getStorageNodePoolNames", (Exception)e);
        }
        return names;
    }

    public List<String> createStorageNodePool(String name) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.addStorageNodePool(name);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"addStorageNodePool", (Exception)e);
        }
        return this.getStorageNodePoolNames();
    }

    public List<String> removeStorageNodePool(String name) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.removeStorageNodePool(name);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"removeStorageNodePool", (Exception)e);
        }
        return this.getStorageNodePoolNames();
    }

    public List<Integer> getStorageNodePoolIds(String name) throws AdminUIException, NotMasterException {
        ArrayList<Integer> snints = new ArrayList<Integer>();
        try {
            this.requireConfigured();
            Parameters p = this.aservice.getParameters();
            StorageNodePool pool = p.getStorageNodePool(name);
            if (pool == null) {
                throw new IllegalArgumentException("No such Storage Node Pool: " + name);
            }
            List<StorageNodeId> snids = pool.getList();
            for (StorageNodeId id : snids) {
                snints.add(new Integer(id.getStorageNodeId()));
            }
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"getStorageNodePoolIds", (Exception)e);
        }
        return snints;
    }

    public List<Integer> replaceStorageNodePool(String name, List<Integer> ids) throws AdminUIException, NotMasterException {
        ArrayList<StorageNodeId> snids = new ArrayList<StorageNodeId>();
        try {
            this.requireConfigured();
            for (Integer id : ids) {
                snids.add(new StorageNodeId(id));
            }
            this.aservice.replaceStorageNodePool(name, snids);
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"replaceStorageNodePool", (Exception)e);
        }
        return this.getStorageNodePoolIds(name);
    }

    public List<PlanDTO> setPolicies(TopologyDTO.Policy newPolicy) throws AdminUIException, NotMasterException {
        try {
            this.requireConfigured();
            this.aservice.setPolicies(this.makeParameterMap(null, null, newPolicy.getMap()));
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"setPolicies", (Exception)e);
        }
        return this.assembleRecentPlanHistory(20);
    }

    public Map<String, Long> getLogFileNames() throws AdminUIException, NotMasterException {
        Map<String, Long> logToTimes = null;
        try {
            this.requireConfigured();
            logToTimes = this.aservice.getLogFileNames();
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"getLogFileNames", (Exception)e);
        }
        return logToTimes;
    }

    public List<String> getCriticalEvents(long from, long to, String eventType) throws AdminUIException, NotMasterException {
        ArrayList<String> eventStrings = new ArrayList<String>();
        try {
            this.requireConfigured();
            CriticalEvent.EventType et = Enum.valueOf(CriticalEvent.EventType.class, eventType);
            List<CriticalEvent> events = this.aservice.getEvents(from, to, et);
            for (CriticalEvent ev : events) {
                eventStrings.add(ev.toString());
            }
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"getCriticalEvents", (Exception)e);
        }
        return eventStrings;
    }

    public String getCriticalEventDetail(String eventId) throws AdminUIException, NotMasterException {
        String result = null;
        try {
            CriticalEvent ce = this.aservice.getOneEvent(eventId);
            if (ce != null) {
                result = ce.getDetailString();
            }
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"getEvents", (Exception)e);
        }
        return result;
    }

    public String[] verifyConfiguration() throws AdminUIException, NotMasterException {
        String result = "";
        try {
            this.requireConfigured();
            VerifyResults vr = this.aservice.verifyConfiguration(false, false, false);
            result = result + vr.display();
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"verifyConfiguration", (Exception)e);
        }
        return result.split(this.eol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateInfo retrieveUpdates(long topologySince, long logSince, long planSince) throws AdminUIException, NotMasterException {
        HttpServletRequest req = this.getThreadLocalRequest();
        HttpSession session = req.getSession();
        String sessionLockObject = session.getId().intern();
        Continuation c = ContinuationSupport.getContinuation((ServletRequest)req);
        if (c.isInitial()) {
            c.setAttribute("oracle.kv.startTime", (Object)new Date());
        }
        List<ServiceChange> serviceChanges = null;
        List<PerfEvent> perfEvents = null;
        List<LogRecord> logEvents = null;
        List<PlanStateChange> planEvents = null;
        AllEventListener listener = null;
        String string = sessionLockObject;
        synchronized (string) {
            try {
                Tracker.RetrievedEvents<LogRecord> logEventsContainer;
                Tracker.RetrievedEvents<PlanStateChange> planEventsContainer;
                Tracker.RetrievedEvents<PerfEvent> perfEventsContainer;
                listener = (AllEventListener)session.getAttribute("oracle.kv.trackerListener");
                if (listener != null && !listener.isRegistered()) {
                    this.removeListener(listener);
                    listener = null;
                }
                if (listener == null) {
                    listener = new AllEventListener(this, logSince, topologySince, planSince, (Object)sessionLockObject, this.aservice);
                    this.addListener(listener);
                    session.setAttribute("oracle.kv.trackerListener", (Object)listener);
                    this.getLogger().info("New admin web client at " + req.getRemoteAddr() + ", session id " + sessionLockObject);
                }
                listener.setAttribute("lastActivity", null);
                Tracker.RetrievedEvents<ServiceChange> statusEventsContainer = this.aservice.getStatusSince(topologySince);
                serviceChanges = statusEventsContainer.getEvents();
                if (serviceChanges.size() > 0) {
                    listener.getStatusListener().setInterestingTime(statusEventsContainer.getLastSyntheticTimestamp());
                }
                if ((perfEvents = (perfEventsContainer = this.aservice.getPerfSince(topologySince)).getEvents()).size() > 0) {
                    listener.getPerfListener().setInterestingTime(perfEventsContainer.getLastSyntheticTimestamp());
                }
                if ((planEvents = (planEventsContainer = this.aservice.getPlanSince(planSince)).getEvents()).size() > 0) {
                    planSince = planEventsContainer.getLastSyntheticTimestamp();
                    listener.getPlanListener().setInterestingTime(planSince);
                }
                if ((logEvents = (logEventsContainer = this.aservice.getLogSince(logSince)).getEvents()).size() != 0) {
                    logSince = logEventsContainer.getLastSyntheticTimestamp();
                    listener.getLogListener().setInterestingTime(logSince);
                }
            }
            catch (Exception e) {
                AdminUIExceptionHelper.rethrow((String)"retrieveUpdates", (Exception)e);
                return null;
            }
            if (serviceChanges.size() == 0 && perfEvents.size() == 0 && logEvents.size() == 0 && planEvents.size() == 0) {
                Date startDate = (Date)c.getAttribute("oracle.kv.startTime");
                if (startDate == null) {
                    throw new RuntimeException("Internal error: StartTime attribute is not set.");
                }
                long startTime = startDate.getTime();
                long now = new Date().getTime();
                long elapsed = now - startTime;
                if (elapsed < 60000L) {
                    c.setTimeout(10000L);
                    listener.setAttribute("continuation", (Object)c);
                    c.suspend();
                    throw new ContinuationException();
                }
            }
            listener.setAttribute("continuation", null);
            listener.setAttribute("lastActivity", (Object)new Date());
        }
        return this.makeUpdateInfo(serviceChanges, perfEvents, planEvents, planSince, logEvents, logSince);
    }

    private synchronized void addListener(AllEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private synchronized void removeListener(AllEventListener listener) {
        this.listeners.remove(listener);
    }

    private void requireConfigured() throws NotMasterException, AdminUIException {
        if (this.isConfigured() == null) {
            throw new IllegalStateException("This command can't be used until the Admin is configured.");
        }
    }

    private void requireNotConfigured() throws NotMasterException, AdminUIException {
        if (this.isConfigured() != null) {
            throw new IllegalStateException("This command is valid only in bootstrap/configuration mode.");
        }
    }

    private void checkMasterState() throws NotMasterException, RemoteException {
        ReplicatedEnvironment.State adminState = this.aservice.getAdminState();
        switch (1.$SwitchMap$com$sleepycat$je$rep$ReplicatedEnvironment$State[adminState.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                URI masterAddress = this.aservice.getMasterHttpAddress();
                String msg = "Redirect to master at " + masterAddress;
                this.getLogger().info(msg);
                throw new NotMasterException(msg, masterAddress.toString());
            }
            case 3: 
            case 4: {
                throw new NotMasterException("The Admin instance is unable to service this request, as it is not the master Admin instance.  Furthermore, its state is such that it does not know the master Admin's forwarding address.", null);
            }
        }
    }

    private List<PlanDTO> assembleRecentPlanHistory(int howMany) throws AdminUIException, NotMasterException {
        ArrayList<PlanDTO> plans = new ArrayList<PlanDTO>();
        try {
            Map<Integer, Plan> chunk;
            int[] range = this.aservice.getPlanIdRange(0L, new Date().getTime(), howMany);
            int planId = range[0];
            howMany = range[1];
            TreeMap<Integer, Plan> sortedPlans = new TreeMap<Integer, Plan>();
            while (howMany > 0 && (chunk = this.aservice.getPlanRange(planId, howMany)).size() != 0) {
                for (Integer k : chunk.keySet()) {
                    Plan p = chunk.get(k);
                    sortedPlans.put(k, p);
                    --howMany;
                }
                planId = (Integer)sortedPlans.lastKey() + 1;
            }
            for (Integer k : sortedPlans.descendingKeySet()) {
                Plan p = this.aservice.getPlanById(k);
                PlanDTO pdto = this.makePlanDTOFromPlan(p);
                this.fillInPlanHistory(p, pdto);
                plans.add(0, pdto);
            }
        }
        catch (Exception e) {
            AdminUIExceptionHelper.rethrow((String)"retrieve plans", (Exception)e);
        }
        return plans;
    }

    private PlanDTO makePlanDTOFromPlan(Plan p) {
        if (DeployDatacenterPlan.class.equals(p.getClass())) {
            DeployDatacenterPlan ddcp = (DeployDatacenterPlan)p;
            return new PlanDTO.DeployDatacenterPlan(ddcp.getId(), ddcp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)ddcp.getState()), ddcp.getCreateTime(), ddcp.getDatacenterName(), ddcp.getRepFactor());
        }
        if (DeploySNPlan.class.equals(p.getClass())) {
            DeploySNPlan dsnp = (DeploySNPlan)p;
            StorageNodeParams snp = dsnp.getInputStorageNodeParams();
            Topology t = dsnp.getTopology();
            StorageNode sn = t.get(dsnp.getStorageNodeId());
            DatacenterId dcid = sn.getDatacenterId();
            return new PlanDTO.DeploySNPlan(dsnp.getId(), dsnp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)dsnp.getState()), dsnp.getCreateTime(), dcid.getDatacenterId(), snp.getHostname(), snp.getRegistryPort(), snp.getComment());
        }
        if (DeployStorePlan.class.equals(p.getClass())) {
            DeployStorePlan dsp = (DeployStorePlan)p;
            return new PlanDTO.DeployStorePlan(dsp.getId(), dsp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)dsp.getState()), dsp.getCreateTime(), dsp.getTargetPool().getName(), dsp.getRepFactor(), dsp.getNumPartitions());
        }
        if (DeployAdminPlan.class.equals(p.getClass())) {
            DeployAdminPlan dap = (DeployAdminPlan)p;
            List<Task> tl = dap.getTaskList().getTasks();
            DeployAdmin t = (DeployAdmin)tl.iterator().next();
            return new PlanDTO.DeployAdminPlan(dap.getId(), dap.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)dap.getState()), dap.getCreateTime(), t.getSnId().getStorageNodeId(), dap.getHttpPort());
        }
        if (DeployTopoPlan.class.equals(p.getClass())) {
            DeployTopoPlan dtp = (DeployTopoPlan)p;
            return new PlanDTO.DeployTopoPlan(dtp.getId(), dtp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)dtp.getState()), dtp.getCreateTime(), dtp.getCandidateName());
        }
        if (StopAllRepNodesPlan.class.equals(p.getClass())) {
            StopAllRepNodesPlan stopp = (StopAllRepNodesPlan)p;
            return new PlanDTO.StopAllRepNodesPlan(stopp.getId(), stopp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)stopp.getState()), stopp.getCreateTime());
        }
        if (StartAllRepNodesPlan.class.equals(p.getClass())) {
            StartAllRepNodesPlan startp = (StartAllRepNodesPlan)p;
            return new PlanDTO.StartAllRepNodesPlan(startp.getId(), startp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)startp.getState()), startp.getCreateTime());
        }
        if (StopRepNodesPlan.class.equals(p.getClass())) {
            StopRepNodesPlan stoprnp = (StopRepNodesPlan)p;
            return new PlanDTO.StopRepNodesPlan(stoprnp.getId(), stoprnp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)stoprnp.getState()), stoprnp.getCreateTime(), this.stuffRnIds(stoprnp.getRepNodeIds()));
        }
        if (StartRepNodesPlan.class.equals(p.getClass())) {
            StartRepNodesPlan startrnp = (StartRepNodesPlan)p;
            return new PlanDTO.StartRepNodesPlan(startrnp.getId(), startrnp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)startrnp.getState()), startrnp.getCreateTime(), this.stuffRnIds(startrnp.getRepNodeIds()));
        }
        if (ChangeSNParamsPlan.class.equals(p.getClass())) {
            ChangeSNParamsPlan csnpp = (ChangeSNParamsPlan)p;
            StorageNodeParams snp = csnpp.getNewParams();
            return new PlanDTO.ChangeSNParamsPlan(csnpp.getId(), csnpp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)csnpp.getState()), csnpp.getCreateTime(), new TopologyDTO.StorageNode(this.makeStorageNodeMap(snp, csnpp.getId())));
        }
        if (ChangeParamsPlan.class.equals(p.getClass())) {
            ChangeParamsPlan cpp = (ChangeParamsPlan)p;
            RepNodeParams rnp = cpp.getNewParams();
            return new PlanDTO.ChangeParamsPlan(cpp.getId(), cpp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)cpp.getState()), cpp.getCreateTime(), new TopologyDTO.RepNode(rnp.getRepNodeId().getGroupId(), rnp.getRepNodeId().getNodeNum(), this.makeRepNodeMap(rnp)));
        }
        if (ChangeAllParamsPlan.class.equals(p.getClass())) {
            ChangeAllParamsPlan capp = (ChangeAllParamsPlan)p;
            RepNodeParams rnp = capp.getNewParams();
            return new PlanDTO.ChangeAllParamsPlan(capp.getId(), capp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)capp.getState()), capp.getCreateTime(), new TopologyDTO.RepNode(0, 0, this.makeRepNodeMap(rnp)));
        }
        if (ChangeAdminParamsPlan.class.equals(p.getClass())) {
            ChangeAdminParamsPlan capp = (ChangeAdminParamsPlan)p;
            AdminParams ap = capp.getNewParams();
            return new PlanDTO.ChangeAdminParamsPlan(capp.getId(), capp.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)capp.getState()), capp.getCreateTime(), new TopologyDTO.Admin(this.makeAdminMap(ap, 0)));
        }
        if (MigrateSNPlan.class.equals(p.getClass())) {
            MigrateSNPlan dap = (MigrateSNPlan)p;
            return new PlanDTO.MigrateSNPlan(dap.getId(), dap.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)dap.getState()), dap.getCreateTime(), dap.getOldNode().getStorageNodeId(), dap.getNewNode().getStorageNodeId(), dap.getHttpPort());
        }
        if (RemoveSNPlan.class.equals(p.getClass())) {
            RemoveSNPlan rap = (RemoveSNPlan)p;
            return new PlanDTO.RemoveSNPlan(rap.getId(), rap.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)rap.getState()), rap.getCreateTime(), rap.getTarget().getStorageNodeId());
        }
        return new PlanDTO(p.getId(), p.getName(), AdminUIServiceImpl.translateDTOState((Plan.State)p.getState()), p.getCreateTime());
    }

    private void fillInPlanHistory(Plan p, PlanDTO pdto) {
        ExecutionState eh = p.getExecutionState();
        if (eh == null) {
            return;
        }
        for (PlanRun pr : eh.getHistory()) {
            String failure = pr.getFailureDescription(true);
            if (failure != null) {
                failure.replaceAll(this.eol, "<br/>        ");
            }
            pdto.addHistoryItem(new PlanDTO.PlanRun(pr.getAttemptNumber(), AdminUIServiceImpl.translateDTOState((Plan.State)p.getState()), new Date(pr.getStartTime()), new Date(pr.getEndTime()), failure));
        }
    }

    private UpdateInfo makeUpdateInfo(List<ServiceChange> serviceChanges, List<PerfEvent> perfEvents, List<PlanStateChange> planEvents, long planRetrievalTime, List<LogRecord> logEvents, long logRetrievalTime) throws AdminUIException, NotMasterException {
        RepNodeId rnid;
        ResourceId id;
        ArrayList<Object> sEventsDTO = new ArrayList<Object>();
        ArrayList<PerfEventDTO> pEventsDTO = new ArrayList<PerfEventDTO>();
        List plans = null;
        if (serviceChanges != null) {
            for (ServiceChange se : serviceChanges) {
                id = se.getTarget();
                if (id.getType().isStorageNode()) {
                    StorageNodeId snid = (StorageNodeId)id;
                    sEventsDTO.add(new StatusEventDTO.StorageNodeStatusEvent(snid.getStorageNodeId(), se.getChangeTime(), AdminUIServiceImpl.translateServiceStatus((ConfigurableService.ServiceStatus)se.getStatus())));
                }
                if (id.getType().isRepNode()) {
                    rnid = (RepNodeId)id;
                    sEventsDTO.add(new StatusEventDTO.RepNodeStatusEvent(rnid.getGroupId(), rnid.getNodeNum(), se.getChangeTime(), AdminUIServiceImpl.translateServiceStatus((ConfigurableService.ServiceStatus)se.getStatus())));
                }
                if (!id.getType().isAdmin()) continue;
                AdminId aid = (AdminId)id;
                sEventsDTO.add(new StatusEventDTO.AdminStatusEvent(aid.getAdminInstanceId(), se.getChangeTime(), AdminUIServiceImpl.translateServiceStatus((ConfigurableService.ServiceStatus)se.getStatus())));
            }
        }
        if (planEvents != null && planEvents.size() > 0) {
            plans = this.assembleRecentPlanHistory(20);
        }
        if (perfEvents != null) {
            for (PerfEvent pe : perfEvents) {
                id = pe.getResourceId();
                if (!id.getType().isRepNode()) continue;
                rnid = (RepNodeId)id;
                LatencyInfo interval = pe.getSingleInt();
                Latency iLat = interval.getLatency();
                LatencyInfo cumulative = pe.getSingleCum();
                Latency cLat = cumulative.getLatency();
                pEventsDTO.add(new PerfEventDTO(rnid.getGroupId(), rnid.getNodeNum(), new PerfEventDTO.LatencyMeasurement(interval.getStart(), interval.getEnd(), iLat.getMin(), iLat.getMax(), iLat.getAvg(), iLat.getTotalOps(), iLat.getTotalRequests(), iLat.get95thPercent(), iLat.get99thPercent()), new PerfEventDTO.LatencyMeasurement(cumulative.getStart(), cumulative.getEnd(), cLat.getMin(), cLat.getMax(), cLat.getAvg(), cLat.getTotalOps(), cLat.getTotalRequests(), cLat.get95thPercent(), cLat.get99thPercent()), pe.needsAlert()));
            }
        }
        ArrayList<LogRecord> translatedLogEvents = new ArrayList<LogRecord>();
        for (LogRecord lr : logEvents) {
            String format = lr.getMessage();
            Object[] lrparams = lr.getParameters();
            String formattedMessage = null;
            if (lrparams != null && lrparams.length != 0) {
                try {
                    formattedMessage = MessageFormat.format(format, lrparams);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (formattedMessage == null) {
                formattedMessage = format;
            }
            LogRecord tlr = new LogRecord(lr.getLevel(), lr.getLevel().getName() + " " + formattedMessage);
            tlr.setMillis(lr.getMillis());
            translatedLogEvents.add(tlr);
        }
        return new UpdateInfo(sEventsDTO, pEventsDTO, translatedLogEvents, logRetrievalTime, plans, planRetrievalTime);
    }

    private TopologyDTO.RepNode[] stuffRnIds(Set<RepNodeId> rnids) {
        TopologyDTO.RepNode[] dtos = new TopologyDTO.RepNode[rnids.size()];
        int i = 0;
        for (RepNodeId rnid : rnids) {
            dtos[i++] = new TopologyDTO.RepNode(rnid.getGroupId(), rnid.getNodeNum(), new TopologyDTO.ParameterMap());
        }
        return dtos;
    }

    private static PlanDTO.State translateDTOState(Plan.State state) {
        switch (1.$SwitchMap$oracle$kv$impl$admin$plan$Plan$State[state.ordinal()]) {
            case 1: {
                return PlanDTO.State.PENDING;
            }
            case 2: {
                return PlanDTO.State.APPROVED;
            }
            case 3: {
                return PlanDTO.State.CANCELED;
            }
            case 4: {
                return PlanDTO.State.RUNNING;
            }
            case 5: {
                return PlanDTO.State.INTERRUPTED;
            }
            case 6: {
                return PlanDTO.State.SUCCEEDED;
            }
            case 7: {
                return PlanDTO.State.ERROR;
            }
            case 8: {
                return PlanDTO.State.INTERRUPT_REQUESTED;
            }
        }
        assert (false);
        return null;
    }

    private static StatusEventDTO.ServiceStatus translateServiceStatus(ConfigurableService.ServiceStatus s) {
        switch (1.$SwitchMap$oracle$kv$impl$util$ConfigurableService$ServiceStatus[s.ordinal()]) {
            case 1: {
                return StatusEventDTO.ServiceStatus.STARTING;
            }
            case 2: {
                return StatusEventDTO.ServiceStatus.WAITING_FOR_DEPLOY;
            }
            case 3: {
                return StatusEventDTO.ServiceStatus.RUNNING;
            }
            case 4: {
                return StatusEventDTO.ServiceStatus.STOPPING;
            }
            case 5: {
                return StatusEventDTO.ServiceStatus.STOPPED;
            }
            case 6: {
                return StatusEventDTO.ServiceStatus.ERROR_RESTARTING;
            }
            case 7: {
                return StatusEventDTO.ServiceStatus.ERROR_NO_RESTART;
            }
            case 8: {
                return StatusEventDTO.ServiceStatus.UNREACHABLE;
            }
        }
        assert (false);
        return null;
    }

    protected String readContent(HttpServletRequest request) throws IOException, ServletException {
        String payload = (String)request.getAttribute("oracle.kv.impl.admin.payload");
        if (payload == null) {
            payload = super.readContent(request);
            request.setAttribute("oracle.kv.impl.admin.payload", (Object)payload);
        }
        return payload;
    }

    protected void doUnexpectedFailure(Throwable caught) {
        Throwable cause;
        if (caught instanceof UnexpectedException && (cause = caught.getCause()) != null && cause instanceof ContinuationException) {
            return;
        }
        this.getLogger().log(Level.WARNING, "Unexpected failure in AdminUIService", caught);
        super.doUnexpectedFailure(caught);
    }

    protected void checkPermutationStrongName() throws SecurityException {
    }

    static /* synthetic */ Logger access$000(AdminUIServiceImpl x0) {
        return x0.getLogger();
    }
}

