/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.List;
import java.util.logging.LogRecord;
import oracle.kv.impl.admin.webapp.client.KVAdminUI;
import oracle.kv.impl.admin.webapp.client.Logs;
import oracle.kv.impl.admin.webapp.shared.UpdateInfo;

public class Logs {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    private final KVAdminUI root;
    @UiField
    Panel container;
    @UiField
    ScrollPanel ttyScroller;
    @UiField
    Panel logTTY;
    @UiField
    CheckBox autoScroll;
    private static final DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss.SSS z");
    private static final com.google.gwt.i18n.client.TimeZone tz = com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0);

    Logs(KVAdminUI root) {
        this.root = root;
        binder.createAndBindUi((Object)this);
        this.autoScroll.setValue(Boolean.valueOf(true));
    }

    void display(Panel place) {
        place.clear();
        place.add((Widget)this.container);
    }

    void applyUpdates(UpdateInfo updates) {
        List newRecords = updates.getLogEvents();
        for (LogRecord lr : newRecords) {
            this.logTTY.add((Widget)new HTML(this.format(lr)));
        }
        if (this.autoScroll.getValue().booleanValue()) {
            this.ttyScroller.scrollToBottom();
        }
    }

    private String format(LogRecord lr) {
        String msg = dtf.format(new Date(lr.getMillis()), (TimeZone)tz);
        msg = msg + " ";
        msg = msg + lr.getMessage();
        msg = msg.replaceAll("\n", "<br/>");
        return msg;
    }
}

