/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.topo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

public class TopologyDiff {
    private static final String CURRENT = "current deployed topology";
    public static final String NO_CHANGE = "No differences in topologies.";
    private final Topology source;
    private final String sourceName;
    private final TopologyCandidate candidate;
    private final Parameters params;
    private final List<RepGroupId> newShards;
    private final Map<RepGroupId, ShardChange> changedShards;
    private final Set<RepNodeId> newRNs;
    private final Set<RepGroupId> removedShards;
    private final Set<RepGroupId> pMigrationSources;
    private final Set<RepGroupId> pMigrationDestinations;
    private int numCreatedPartitions;
    private int numPartitionMigrations;
    private int numRelocatedRNs;
    private Map<RepNodeId, String> mountPointAssignments;

    public TopologyDiff(Topology source, String sourceName, TopologyCandidate candidate, Parameters params) {
        this(source, sourceName, candidate, params, true);
    }

    public TopologyDiff(Topology source, String sourceName, TopologyCandidate candidate, Parameters params, boolean validate) {
        this.source = source;
        this.sourceName = sourceName == null ? CURRENT : sourceName;
        this.candidate = candidate;
        this.params = params;
        this.changedShards = new TreeMap<RepGroupId, ShardChange>(new Comparator<RepGroupId>(){

            @Override
            public int compare(RepGroupId r1, RepGroupId r2) {
                return r1.getGroupId() - r2.getGroupId();
            }
        });
        this.numCreatedPartitions = 0;
        this.newShards = new ArrayList<RepGroupId>();
        this.removedShards = new HashSet<RepGroupId>();
        this.newRNs = new HashSet<RepNodeId>();
        this.pMigrationSources = new HashSet<RepGroupId>();
        this.pMigrationDestinations = new HashSet<RepGroupId>();
        this.doDiff(validate);
    }

    public int getNumCreatedPartitions() {
        return this.numCreatedPartitions;
    }

    public int getNumNewShards() {
        return this.newShards.size();
    }

    public int getNumNewRNs() {
        return this.newRNs.size();
    }

    public int getNumRelocatedRNs() {
        return this.numRelocatedRNs;
    }

    public String display(boolean verbose) {
        int moved;
        int nNewRNs;
        StringBuilder sb = new StringBuilder();
        int nShards = this.getNumNewShards();
        if (nShards > 0) {
            sb.append("Create ").append(nShards).append(" shard").append(this.plural(nShards)).append("\n");
        }
        if ((nNewRNs = this.getNumNewRNs()) > 0) {
            sb.append("Create ").append(nNewRNs).append(" RN").append(this.plural(nNewRNs)).append("\n");
        }
        if ((moved = this.getNumRelocatedRNs()) > 0) {
            sb.append("Relocate ").append(moved).append(" RN").append(this.plural(moved)).append("\n");
        }
        if (this.numCreatedPartitions != 0) {
            sb.append("Create ").append(this.numCreatedPartitions).append(" partition").append(this.plural(this.numCreatedPartitions)).append("\n");
        }
        if (this.numPartitionMigrations != 0) {
            sb.append("Migrate ").append(this.numPartitionMigrations).append(" partition").append(this.plural(this.numPartitionMigrations)).append("\n");
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        String indent = "  ";
        for (Map.Entry<RepGroupId, ShardChange> s : this.changedShards.entrySet()) {
            int nMigrates;
            sb.append("shard ").append(s.getKey()).append("\n");
            ShardChange c = s.getValue();
            int newCreates = c.newlyCreatedRNs.size();
            if (newCreates > 0) {
                sb.append(indent);
                sb.append(newCreates).append(" new RN").append(this.plural(newCreates)).append(": ");
                for (RepNodeId rnId : c.newlyCreatedRNs) {
                    sb.append(rnId).append(" ");
                }
                sb.append("\n");
            }
            if (!c.getRelocatedRNs().isEmpty()) {
                for (RelocatedRN rel : c.getRelocatedRNs()) {
                    sb.append(indent).append(rel).append("\n");
                }
            }
            if (c.newPartitionCount != 0) {
                sb.append(indent).append(c.newPartitionCount).append(" new partition").append(this.plural(c.newPartitionCount)).append("\n");
            }
            if ((nMigrates = c.migrations.size()) <= 0) continue;
            sb.append(indent).append(nMigrates).append(" partition migration").append(this.plural(nMigrates)).append("\n");
            if (!verbose) continue;
            for (RelocatedPartition p : this.sortBySrcAndPart(c.migrations)) {
                sb.append(indent).append(p).append("\n");
            }
        }
        if (sb.length() == 0) {
            return NO_CHANGE;
        }
        return "Topology transformation from " + this.sourceName + " to " + this.candidate.getName() + ":\n" + sb.toString();
    }

    private String plural(int val) {
        return val == 1 ? " " : "s ";
    }

    private List<RelocatedPartition> sortBySrcAndPart(List<RelocatedPartition> migrations) {
        ArrayList<RelocatedPartition> relPart = new ArrayList<RelocatedPartition>(migrations);
        Collections.sort(relPart, new Comparator<RelocatedPartition>(){

            @Override
            public int compare(RelocatedPartition p1, RelocatedPartition p2) {
                int p2Src;
                int p1Src = p1.getSourceShard().getGroupId();
                int shardDiff = p1Src - (p2Src = p2.getSourceShard().getGroupId());
                if (shardDiff != 0) {
                    return shardDiff;
                }
                return p1.getPartitionId().getPartitionId() - p2.getPartitionId().getPartitionId();
            }
        });
        return relPart;
    }

    public Map<RepGroupId, ShardChange> getChangedShards() {
        return this.changedShards;
    }

    public static int shardDelta(Topology topoA, Topology topoB) {
        return topoA.getRepGroupMap().size() - topoB.getRepGroupMap().size();
    }

    private void doDiff(boolean validate) {
        if (validate) {
            Rules.validateTransition(this.source, this.candidate, this.params);
        }
        Topology target = this.candidate.getTopology();
        Set<RepNodeId> originalRNs = this.source.getRepNodeIds();
        this.newRNs.addAll(target.getRepNodeIds());
        this.newRNs.removeAll(originalRNs);
        this.identifyNewRNs();
        this.identifyRelocatedRNs(originalRNs);
        this.findNewShards();
        this.findPartitionChanges();
        this.mountPointAssignments = this.candidate.getAllMountPoints();
    }

    private void identifyNewRNs() {
        for (RepNodeId rnId : this.newRNs) {
            ShardChange change = this.getShardChange(new RepGroupId(rnId.getGroupId()));
            change.addNewRN(rnId);
        }
    }

    private void identifyRelocatedRNs(Set<RepNodeId> originalRNs) {
        Topology target = this.candidate.getTopology();
        for (RepNodeId existingRNId : originalRNs) {
            StorageNodeId targetSNId;
            StorageNodeId sourceSNId = this.source.get(existingRNId).getStorageNodeId();
            if (sourceSNId.equals(targetSNId = target.get(existingRNId).getStorageNodeId())) continue;
            String sourceMountPoint = null;
            RepNodeParams rnp = this.params.get(existingRNId);
            if (rnp != null) {
                sourceMountPoint = rnp.getMountPointString();
            }
            String targetMountPoint = this.candidate.getMountPoint(existingRNId);
            RelocatedRN rel = new RelocatedRN(existingRNId, sourceSNId, sourceMountPoint, targetSNId, targetMountPoint, this.params);
            ShardChange change = this.getShardChange(new RepGroupId(existingRNId.getGroupId()));
            change.addRelocatedRN(rel);
            ++this.numRelocatedRNs;
        }
    }

    private void findNewShards() {
        Topology target = this.candidate.getTopology();
        Set<RepGroupId> originalShards = this.source.getRepGroupIds();
        Set<RepGroupId> candidateShards = target.getRepGroupIds();
        HashSet<RepGroupId> brandNew = new HashSet<RepGroupId>(candidateShards);
        brandNew.removeAll(originalShards);
        this.newShards.addAll(brandNew);
        Collections.sort(this.newShards);
        this.removedShards.addAll(originalShards);
        this.removedShards.removeAll(candidateShards);
        if (this.removedShards.size() > 0) {
            throw new UnsupportedOperationException("These shards " + this.removedShards + " are not present in the topology candidate, which means" + " the candidate store is smaller, but store contraction" + " is not supported in this release.");
        }
    }

    private void findPartitionChanges() {
        Topology target = this.candidate.getTopology();
        if (this.source.getPartitionMap().size() == 0) {
            for (Partition p : target.getPartitionMap().getAll()) {
                ShardChange change = this.getShardChange(p.getRepGroupId());
                change.incNewPartionCount();
                ++this.numCreatedPartitions;
            }
            return;
        }
        HashMap<RepGroupId, AtomicInteger> sourceCount = new HashMap<RepGroupId, AtomicInteger>();
        for (RepGroupId rgId : this.source.getRepGroupIds()) {
            sourceCount.put(rgId, new AtomicInteger(0));
        }
        for (Partition p : this.source.getPartitionMap().getAll()) {
            ((AtomicInteger)sourceCount.get(p.getRepGroupId())).incrementAndGet();
        }
        HashMap<RepGroupId, AtomicInteger> targetCount = new HashMap<RepGroupId, AtomicInteger>();
        for (RepGroupId rgId : target.getRepGroupIds()) {
            targetCount.put(rgId, new AtomicInteger(0));
        }
        for (Partition p : target.getPartitionMap().getAll()) {
            ((AtomicInteger)targetCount.get(p.getRepGroupId())).incrementAndGet();
        }
        HashSet<RepGroupId> changed = new HashSet<RepGroupId>();
        for (RepGroupId rgId : target.getRepGroupIds()) {
            if (sourceCount.get(rgId) == null) {
                changed.add(rgId);
                continue;
            }
            if (((AtomicInteger)sourceCount.get(rgId)).get() == ((AtomicInteger)targetCount.get(rgId)).get()) continue;
            changed.add(rgId);
        }
        for (Partition p : target.getPartitionMap().getAll()) {
            RepGroupId newShard;
            PartitionId pId = (PartitionId)p.getResourceId();
            RepGroupId oldShard = this.source.get(pId).getRepGroupId();
            if (oldShard.equals(newShard = target.get(pId).getRepGroupId()) || !changed.contains(oldShard) || !changed.contains(newShard)) continue;
            ShardChange change = this.getShardChange(newShard);
            change.add(new RelocatedPartition(pId, oldShard));
            this.pMigrationSources.add(oldShard);
            this.pMigrationDestinations.add(newShard);
            ++this.numPartitionMigrations;
        }
    }

    public ShardChange getShardChange(RepGroupId id) {
        ShardChange change = this.changedShards.get(id);
        if (change == null) {
            change = new ShardChange();
            this.changedShards.put(id, change);
        }
        return change;
    }

    public List<RepGroupId> getNewShards() {
        return this.newShards;
    }

    public String getMountPoint(RepNodeId rnId) {
        return this.mountPointAssignments.get(rnId);
    }

    public static class RelocatedPartition {
        private final PartitionId partitionId;
        private final RepGroupId sourceShard;

        public RelocatedPartition(PartitionId partitionId, RepGroupId sourceShard) {
            this.partitionId = partitionId;
            this.sourceShard = sourceShard;
        }

        public PartitionId getPartitionId() {
            return this.partitionId;
        }

        public RepGroupId getSourceShard() {
            return this.sourceShard;
        }

        public String toString() {
            return "Migrate " + this.partitionId + " from " + this.sourceShard;
        }
    }

    public static class RelocatedRN {
        private final RepNodeId rnId;
        private final StorageNodeId oldSNId;
        private final StorageNodeId newSNId;
        private final String oldMountPoint;
        private final String newMountPoint;
        private final String oldRootDir;
        private final String newRootDir;

        RelocatedRN(RepNodeId rnId, StorageNodeId oldSNId, String oldMountPoint, StorageNodeId newSNId, String newMountPoint, Parameters params) {
            this.rnId = rnId;
            this.oldSNId = oldSNId;
            this.oldMountPoint = oldMountPoint;
            this.oldRootDir = params.get(oldSNId).getRootDirPath();
            this.newSNId = newSNId;
            this.newMountPoint = newMountPoint;
            this.newRootDir = params.get(newSNId).getRootDirPath();
        }

        public RepNodeId getRnId() {
            return this.rnId;
        }

        public StorageNodeId getNewSNId() {
            return this.newSNId;
        }

        public StorageNodeId getOldSNId() {
            return this.oldSNId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Relocate ").append(this.rnId).append(" from ");
            sb.append(this.oldSNId).append(" ");
            if (this.oldMountPoint == null) {
                sb.append(this.oldRootDir);
            } else {
                sb.append(this.oldMountPoint);
            }
            sb.append(" to ");
            sb.append(this.newSNId).append(" ");
            if (this.newMountPoint == null) {
                sb.append(this.newRootDir);
            } else {
                sb.append(this.newMountPoint);
            }
            return sb.toString();
        }
    }

    public static class ShardChange {
        private final Set<RepNodeId> newlyCreatedRNs;
        private final Set<RelocatedRN> relocatedRNs = new TreeSet<RelocatedRN>(new Comparator<RelocatedRN>(){

            @Override
            public int compare(RelocatedRN o1, RelocatedRN o2) {
                return o1.getRnId().getNodeNum() - o2.getRnId().getNodeNum();
            }
        });
        private int newPartitionCount;
        private final List<RelocatedPartition> migrations;

        ShardChange() {
            this.newlyCreatedRNs = new TreeSet<RepNodeId>(new Comparator<RepNodeId>(){

                @Override
                public int compare(RepNodeId o1, RepNodeId o2) {
                    return o1.getNodeNum() - o2.getNodeNum();
                }
            });
            this.migrations = new ArrayList<RelocatedPartition>();
        }

        public List<RelocatedPartition> getMigrations() {
            return this.migrations;
        }

        public void add(RelocatedPartition relocatedPartition) {
            this.migrations.add(relocatedPartition);
        }

        void incNewPartionCount() {
            ++this.newPartitionCount;
        }

        public int getNumNewPartitions() {
            return this.newPartitionCount;
        }

        public Set<RepNodeId> getNewRNs() {
            return this.newlyCreatedRNs;
        }

        void addNewRN(RepNodeId rnId) {
            this.newlyCreatedRNs.add(rnId);
        }

        public Set<RelocatedRN> getRelocatedRNs() {
            return this.relocatedRNs;
        }

        void addRelocatedRN(RelocatedRN rel) {
            this.relocatedRNs.add(rel);
        }

        public String getSNSetDescription(Topology topo) {
            StringBuilder sb = new StringBuilder();
            for (RepNodeId rnId : this.newlyCreatedRNs) {
                StorageNodeId snId = topo.get(rnId).getStorageNodeId();
                sb.append(topo.get(snId).toString());
                sb.append(" ");
            }
            return sb.toString();
        }
    }
}

